/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.sdk.AndroidSdkData;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidSdkConfigurableForm {
    private JPanel myContentPanel;
    private JComboBox<IAndroidTarget> myBuildTargetComboBox;
    private final DefaultComboBoxModel myBuildTargetsModel = new DefaultComboBoxModel();
    private String mySdkLocation;
    private boolean myFreeze = false;

    public AndroidSdkConfigurableForm(@NotNull SdkModificator sdkModificator) {
        this.setupUI();
        this.myBuildTargetComboBox.setModel(this.myBuildTargetsModel);
        this.myBuildTargetComboBox.setRenderer((ListCellRenderer<IAndroidTarget>)SimpleListCellRenderer.create((label2, value2, index) -> {
            if (value2 != null) {
                label2.setText(AndroidSdkUtils.getTargetPresentableName(value2));
            } else {
                label2.setText("<html><font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>[none]</font></html>");
            }
        }));
        this.myBuildTargetComboBox.addItemListener(e -> {
            if (this.myFreeze) {
                return;
            }
            IAndroidTarget target2 = (IAndroidTarget)e.getItem();
            List roots = AndroidSdks.getInstance().getLibraryRootsForTarget(target2, FilePaths.stringToFile((String)this.mySdkLocation), true);
            HashMap<OrderRootType, String[]> configuredRoots = new HashMap<OrderRootType, String[]>();
            for (OrderRootType type : OrderRootType.getAllTypes()) {
                if (!AndroidSdkType.getInstance().isRootTypeApplicable(type)) continue;
                VirtualFile[] oldRoots = sdkModificator.getRoots(type);
                String[] oldRootPaths = new String[oldRoots.length];
                for (int i = 0; i < oldRootPaths.length; ++i) {
                    oldRootPaths[i] = oldRoots[i].getPath();
                }
                configuredRoots.put(type, oldRootPaths);
            }
            for (OrderRoot root : roots) {
                if (e.getStateChange() == 2) {
                    sdkModificator.removeRoot(root.getFile(), root.getType());
                    continue;
                }
                Object[] configuredRootsForType = (String[])configuredRoots.get(root.getType());
                if (ArrayUtil.find((Object[])configuredRootsForType, (Object)root.getFile().getPath()) != -1) continue;
                sdkModificator.addRoot(root.getFile(), root.getType());
            }
        });
    }

    @NotNull
    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    @Nullable
    public IAndroidTarget getSelectedBuildTarget() {
        return (IAndroidTarget)this.myBuildTargetComboBox.getSelectedItem();
    }

    public void init(Sdk androidSdk, IAndroidTarget buildTarget) {
        this.mySdkLocation = androidSdk != null ? androidSdk.getHomePath() : null;
        AndroidSdkData androidSdkData = this.mySdkLocation != null ? AndroidSdkData.getSdkData(this.mySdkLocation) : null;
        this.myFreeze = true;
        this.updateBuildTargets(androidSdkData, buildTarget);
        this.myFreeze = false;
    }

    private void updateBuildTargets(AndroidSdkData androidSdkData, IAndroidTarget buildTarget) {
        this.myBuildTargetsModel.removeAllElements();
        if (androidSdkData != null) {
            for (IAndroidTarget target2 : androidSdkData.getTargets()) {
                this.myBuildTargetsModel.addElement(target2);
            }
        }
        if (buildTarget != null) {
            for (int i = 0; i < this.myBuildTargetsModel.getSize(); ++i) {
                IAndroidTarget target3 = (IAndroidTarget)this.myBuildTargetsModel.getElementAt(i);
                if (!buildTarget.hashString().equals(target3.hashString())) continue;
                this.myBuildTargetComboBox.setSelectedIndex(i);
                return;
            }
        }
        this.myBuildTargetComboBox.setSelectedItem(null);
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        label1.setText("Build target:");
        label1.setDisplayedMnemonic('B');
        label1.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myBuildTargetComboBox = new JComboBox();
        this.myContentPanel.add(this.myBuildTargetComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        label1.setLabelFor(this.myBuildTargetComboBox);
    }
}

