/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.sdk.AndroidPlatform;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import javax.swing.JComponent;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkConfigurableForm;
import org.jetbrains.annotations.NotNull;

public class AndroidSdkConfigurable
implements AdditionalDataConfigurable {
    private final AndroidSdkConfigurableForm myForm;
    private Sdk mySdk;

    public AndroidSdkConfigurable(@NotNull SdkModificator sdkModificator) {
        this.myForm = new AndroidSdkConfigurableForm(sdkModificator);
    }

    public void setSdk(Sdk sdk) {
        this.mySdk = sdk;
    }

    public JComponent createComponent() {
        return this.myForm.getContentPanel();
    }

    public boolean isModified() {
        AndroidSdkAdditionalData data2 = AndroidSdkAdditionalData.from(this.mySdk);
        AndroidPlatform currentAndroidPlatform = data2 != null ? data2.getAndroidPlatform() : null;
        IAndroidTarget currentAndroidTarget = currentAndroidPlatform != null ? currentAndroidPlatform.getTarget() : null;
        IAndroidTarget selectedBuildTarget = this.myForm.getSelectedBuildTarget();
        return selectedBuildTarget != null && !selectedBuildTarget.equals((Object)currentAndroidTarget);
    }

    public void apply() throws ConfigurationException {
        AndroidSdkAdditionalData newData = new AndroidSdkAdditionalData(this.mySdk);
        newData.setBuildTarget(this.myForm.getSelectedBuildTarget());
        SdkModificator modificator = this.mySdk.getSdkModificator();
        modificator.setSdkAdditionalData((SdkAdditionalData)newData);
        ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)modificator).commitChanges());
    }

    public void reset() {
        if (this.mySdk == null) {
            return;
        }
        AndroidSdkAdditionalData data2 = AndroidSdkAdditionalData.from(this.mySdk);
        if (data2 == null) {
            return;
        }
        AndroidPlatform platform = data2.getAndroidPlatform();
        this.myForm.init(this.mySdk, platform != null ? data2.getBuildTarget(platform.getSdkData()) : null);
    }
}

