/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.renaming;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.ui.EditorTextField;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.refactoring.renaming.RenameResourceReferenceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J-\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0097\u0002J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0097\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceRenameHandler;", "Lcom/intellij/refactoring/rename/RenameHandler;", "Lcom/intellij/ide/TitledHandler;", "<init>", "()V", "isAvailableOnDataContext", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isAvailableInFile", "file", "Lcom/intellij/psi/PsiFile;", "getWritableResourceReferenceElement", "Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;", "isRenaming", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "getActionTitle", "", "ResourceRenameDialog", "intellij.android.core"})
public class ResourceRenameHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        return this.isAvailableInFile(file) && this.getWritableResourceReferenceElement(dataContext) != null;
    }

    public boolean isAvailableInFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !Intrinsics.areEqual((Object)file.getLanguage(), (Object)KotlinLanguage.INSTANCE);
    }

    private final ResourceReferencePsiElement getWritableResourceReferenceElement(DataContext dataContext) {
        ResourceReferencePsiElement resourceReferenceElement;
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        ResourceReferencePsiElement resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create(element);
        ResourceReferencePsiElement resourceReferencePsiElement2 = resourceReferenceElement = resourceReferencePsiElement != null ? resourceReferencePsiElement.toWritableResourceReferencePsiElement() : null;
        if (resourceReferenceElement != null) {
            return resourceReferenceElement;
        }
        Caret caret = (Caret)CommonDataKeys.CARET.getData(dataContext);
        if (caret == null) {
            return null;
        }
        int offset = caret.getOffset();
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        PsiElement psiElement2 = file.findElementAt(offset);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement elementInFile = psiElement2;
        if (elementInFile.getParent() instanceof XmlTag) {
            return null;
        }
        ResourceReferencePsiElement resourceReferencePsiElement3 = IdeResourcesUtil.getResourceElementFromSurroundingValuesTag(elementInFile);
        return resourceReferencePsiElement3 != null ? resourceReferencePsiElement3.toWritableResourceReferencePsiElement() : null;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.isAvailableOnDataContext(dataContext);
    }

    @UiThread
    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        ResourceReferencePsiElement resourceReferencePsiElement = this.getWritableResourceReferenceElement(dataContext);
        if (resourceReferencePsiElement == null) {
            return;
        }
        ResourceReferencePsiElement referencePsiElement = resourceReferencePsiElement;
        if (file == null) {
            return;
        }
        referencePsiElement.putCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT, file);
        String newName = (String)RenameResourceReferenceKt.getNEW_NAME_RESOURCE().getData(dataContext);
        new ResourceRenameDialog(project, referencePsiElement, null, editor, newName).show(dataContext);
    }

    @UiThread
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        this.invoke(project, editor, file, dataContext);
    }

    @NotNull
    public String getActionTitle() {
        return "Rename Android Resource";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0014J\b\u0010\u0015\u001a\u00020\u000fH\u0002R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceRenameHandler$ResourceRenameDialog;", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "resourceReferenceElement", "Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;", "nameSuggestionContext", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "providedName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "nameValidator", "Lcom/intellij/openapi/ui/InputValidatorEx;", "show", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "canRun", "getNameValidator", "intellij.android.core"})
    private static final class ResourceRenameDialog
    extends RenameDialog {
        @Nullable
        private InputValidatorEx nameValidator;

        public ResourceRenameDialog(@NotNull Project project, @NotNull ResourceReferencePsiElement resourceReferenceElement, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor, @Nullable String providedName) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)((Object)resourceReferenceElement), (String)"resourceReferenceElement");
                super(project, (PsiElement)resourceReferenceElement, nameSuggestionContext, editor);
                if (providedName == null) break block1;
                JComponent jComponent = this.getNameSuggestionsField().getFocusableComponent();
                EditorTextField editorTextField = jComponent instanceof EditorTextField ? (EditorTextField)jComponent : null;
                if (editorTextField != null) {
                    editorTextField.setText(providedName);
                }
            }
        }

        public final void show(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String string = (String)RenameResourceReferenceKt.getNEW_NAME_RESOURCE().getData(dataContext);
                if (string == null && (string = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext)) == null) {
                    return;
                }
                String newTestingName = string;
                this.performRename(newTestingName);
                this.close(0);
            } else {
                super.show();
            }
        }

        protected void canRun() {
            String string = this.getNewName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
            String name2 = string;
            String errorText = this.getNameValidator().getErrorText(name2);
            if (errorText != null) {
                throw new ConfigurationException(errorText);
            }
        }

        private final InputValidatorEx getNameValidator() {
            InputValidatorEx validator = this.nameValidator;
            if (validator == null) {
                InputValidatorEx inputValidatorEx;
                PsiElement psiElement = this.getPsiElement();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.android.tools.idea.res.psi.ResourceReferencePsiElement");
                ResourceReference resourceReference = ((ResourceReferencePsiElement)psiElement).getResourceReference();
                PsiElement psiElement2 = this.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsiElement(...)");
                if (RenameResourceReferenceKt.isFileBased(resourceReference, psiElement2)) {
                    ResourceFolderType resourceFolderType = FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resourceReference.getResourceType());
                    Intrinsics.checkNotNull((Object)resourceFolderType);
                    ResourceFolderType resourceFolderType2 = resourceFolderType;
                    inputValidatorEx = IdeResourceNameValidator.Companion.forFilename$default(IdeResourceNameValidator.Companion, resourceFolderType2, null, null, 6, null);
                } else {
                    ResourceType resourceType = resourceReference.getResourceType();
                    Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"getResourceType(...)");
                    inputValidatorEx = IdeResourceNameValidator.Companion.forResourceName$default(IdeResourceNameValidator.Companion, resourceType, null, 2, null);
                }
                this.nameValidator = validator = inputValidatorEx;
            }
            return validator;
        }
    }
}

