/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.renaming;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.tools.idea.res.psi.ResourceRepositoryToPsiResolver;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.augment.ResourceLightField;
import org.jetbrains.android.augment.StyleableAttrFieldUrl;
import org.jetbrains.android.augment.StyleableAttrLightField;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\rH\u0016J,\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016J7\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0017J\"\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0016H\u0016\u00a8\u0006%"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceReferenceRenameProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findExistingNameConflicts", "", "newName", "", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "prepareRenaming", "allRenames", "", "renameElement", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "renameAndroidLightField", "usage", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "getPostRenameCallback", "Ljava/lang/Runnable;", "elementListener", "ResourceFileReference", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nRenameResourceReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameResourceReference.kt\norg/jetbrains/android/refactoring/renaming/ResourceReferenceRenameProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,397:1\n11228#2:398\n11563#2,3:399\n11228#2:402\n11563#2,3:403\n11228#2:406\n11563#2,3:407\n*S KotlinDebug\n*F\n+ 1 RenameResourceReference.kt\norg/jetbrains/android/refactoring/renaming/ResourceReferenceRenameProcessor\n*L\n177#1:398\n177#1:399,3\n184#1:402\n184#1:403,3\n187#1:406\n187#1:407,3\n*E\n"})
public final class ResourceReferenceRenameProcessor
extends RenamePsiElementProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ResourceReferencePsiElement resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create(element);
        return (resourceReferencePsiElement != null ? resourceReferencePsiElement.toWritableResourceReferencePsiElement() : null) != null;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        if (!(element instanceof ResourceReferencePsiElement)) {
            super.findExistingNameConflicts(element, newName, conflicts);
            return;
        }
        PsiElement psiElement = (PsiElement)((ResourceReferencePsiElement)element).getCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT);
        if (psiElement == null) {
            super.findExistingNameConflicts(element, newName, conflicts);
            return;
        }
        PsiElement contextElement = psiElement;
        ResourceReference oldResourceReference = ((ResourceReferencePsiElement)element).getResourceReference();
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance(contextElement);
        if (studioResourceRepositoryManager == null || (studioResourceRepositoryManager = studioResourceRepositoryManager.getResourcesForNamespace(oldResourceReference.getNamespace())) == null) {
            super.findExistingNameConflicts(element, newName, conflicts);
            return;
        }
        StudioResourceRepositoryManager repository2 = studioResourceRepositoryManager;
        if (repository2.hasResources(oldResourceReference.getNamespace(), oldResourceReference.getResourceType(), newName)) {
            ResourceReference newReference = new ResourceReference(oldResourceReference.getNamespace(), oldResourceReference.getResourceType(), newName);
            for (PsiElement target2 : ResourceRepositoryToPsiResolver.INSTANCE.getGotoDeclarationTargets(newReference, contextElement)) {
                Object[] objectArray = new String[]{"Resource " + newReference.getResourceUrl() + " already exists"};
                conflicts.put((Object)target2, (Collection)CollectionsKt.mutableListOf((Object[])objectArray));
            }
        }
        super.findExistingNameConflicts(element, newName, conflicts);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        if (!(element instanceof ResourceReferencePsiElement)) {
            ResourceReferencePsiElement resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create(element);
            if (resourceReferencePsiElement == null || (resourceReferencePsiElement = resourceReferencePsiElement.toWritableResourceReferencePsiElement()) == null) {
                return;
            }
            ResourceReferencePsiElement resourceReferenceElement = resourceReferencePsiElement;
            resourceReferenceElement.putCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT, element);
            allRenames.remove(element);
            allRenames.put((PsiElement)resourceReferenceElement, newName);
        }
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        for (UsageInfo usage : usages) {
            Language language;
            if (usage.getReference() instanceof BindablePsiReference) continue;
            PsiElement psiElement = usage.getElement();
            Object object = language = psiElement != null ? psiElement.getLanguage() : null;
            if (language != null && (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) || Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) && element instanceof ResourceReferencePsiElement) {
                this.renameAndroidLightField(element, usage, newName);
                continue;
            }
            RenameUtil.rename((UsageInfo)usage, (String)newName);
        }
    }

    private final void renameAndroidLightField(PsiElement element, UsageInfo usage, String newName) {
        PsiElement resolvedValue;
        PsiReference psiReference = usage.getReference();
        Object object = resolvedValue = psiReference != null ? psiReference.resolve() : null;
        if (resolvedValue instanceof ResourceLightField) {
            RenameUtil.rename((UsageInfo)usage, (String)newName);
        } else if (resolvedValue instanceof StyleableAttrLightField) {
            StyleableAttrFieldUrl fieldUrl = ((StyleableAttrLightField)resolvedValue).getStyleableAttrFieldUrl();
            ResourceReferencePsiElement resourceReferencePsiElement = element instanceof ResourceReferencePsiElement ? (ResourceReferencePsiElement)element : null;
            if (resourceReferencePsiElement == null || (resourceReferencePsiElement = resourceReferencePsiElement.getResourceReference()) == null) {
                return;
            }
            ResourceReferencePsiElement resourceReference = resourceReferencePsiElement;
            ResourceType resourceType = resourceReference.getResourceType();
            switch (resourceType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resourceType.ordinal()]) {
                case 1: {
                    String newAttrName = new StyleableAttrFieldUrl(fieldUrl.getStyleable(), new ResourceReference(fieldUrl.getAttr().getNamespace(), ResourceType.ATTR, newName)).toFieldName();
                    RenameUtil.rename((UsageInfo)usage, (String)newAttrName);
                    break;
                }
                case 2: {
                    String newStyleableName = new StyleableAttrFieldUrl(new ResourceReference(fieldUrl.getStyleable().getNamespace(), ResourceType.STYLEABLE, newName), fieldUrl.getAttr()).toFieldName();
                    RenameUtil.rename((UsageInfo)usage, (String)newStyleableName);
                    break;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Trying to rename styleable attr field from incorrect resource type: " + resourceReference.getResourceType().getDisplayName());
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            RenameUtil.rename((UsageInfo)usage, (String)newName);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        Collection collection2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        ResourceReferencePsiElement resourceReferencePsiElement = element instanceof ResourceReferencePsiElement ? (ResourceReferencePsiElement)element : null;
        if (resourceReferencePsiElement == null) {
            Collection collection3 = super.findReferences(element, searchScope, searchInCommentsAndStrings);
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"findReferences(...)");
            return collection3;
        }
        ResourceReferencePsiElement resourceElement = resourceReferencePsiElement;
        PsiElement psiElement = (PsiElement)resourceElement.getCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT);
        if (psiElement == null) {
            Collection collection4 = super.findReferences(element, searchScope, searchInCommentsAndStrings);
            Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"findReferences(...)");
            return collection4;
        }
        PsiElement contextElement = psiElement;
        SearchScope resourceScope = ResourceRepositoryToPsiResolver.getResourceSearchScope(resourceElement.getResourceReference(), contextElement);
        Collection collection5 = super.findReferences(element, searchScope.intersectWith(resourceScope), searchInCommentsAndStrings);
        Intrinsics.checkNotNullExpressionValue((Object)collection5, (String)"findReferences(...)");
        Collection found = collection5;
        PsiFile[] fileResources = AndroidResourceToPsiResolver.getInstance().getGotoDeclarationFileBasedTargets(resourceElement.getResourceReference(), contextElement);
        Intrinsics.checkNotNull((Object)fileResources);
        PsiFile[] psiFileArray = fileResources;
        Collection collection6 = found;
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo2 = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var17_22 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection2.add(new ResourceFileReference((PsiFile)it));
        }
        collection6.addAll((List)destination$iv$iv);
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)contextElement);
        if (androidFacet == null) {
            return found;
        }
        AndroidFacet androidFacet2 = androidFacet;
        ResourceType resourceType = resourceElement.getResourceReference().getResourceType();
        switch (resourceType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resourceType.ordinal()]) {
            case 1: {
                int n2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                PsiField[] fields2;
                String string = resourceElement.getResourceReference().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                PsiField[] $i$f$mapTo2 = fields2 = IdeResourcesUtil.findStyleableAttrFieldsForAttr(androidFacet2, string);
                collection6 = found;
                boolean $i$f$map2 = false;
                void var15_19 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv2).length);
                boolean $i$f$mapTo3 = false;
                int n3 = ((void)$this$mapTo$iv$iv2).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    void it;
                    void item$iv$iv;
                    void var21_31 = item$iv$iv = $this$mapTo$iv$iv2[n2];
                    collection2 = destination$iv$iv2;
                    boolean bl = false;
                    collection2.add(super.findReferences((PsiElement)it, searchScope, searchInCommentsAndStrings));
                }
                collection6.addAll(CollectionsKt.flatten((Iterable)((List)destination$iv$iv2)));
                break;
            }
            case 2: {
                int n2;
                PsiField[] fields2;
                String string = resourceElement.getResourceReference().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                PsiField[] $this$map$iv2 = fields2 = IdeResourcesUtil.findStyleableAttrFieldsForStyleable(androidFacet2, string);
                collection6 = found;
                boolean $i$f$map2 = false;
                PsiField[] $this$mapTo$iv$iv2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
                boolean $i$f$mapTo4 = false;
                int n4 = $this$mapTo$iv$iv2.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    PsiField item$iv$iv;
                    PsiField it = item$iv$iv = $this$mapTo$iv$iv2[n2];
                    collection2 = destination$iv$iv2;
                    boolean bl = false;
                    collection2.add(super.findReferences((PsiElement)it, searchScope, searchInCommentsAndStrings));
                }
                collection6.addAll(CollectionsKt.flatten((Iterable)((List)destination$iv$iv2)));
            }
        }
        return found;
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String newName, @NotNull RefactoringElementListener elementListener) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)elementListener, (String)"elementListener");
        ResourceReferencePsiElement resourceReferencePsiElement = element instanceof ResourceReferencePsiElement ? (ResourceReferencePsiElement)element : null;
        if (resourceReferencePsiElement == null || (resourceReferencePsiElement = resourceReferencePsiElement.getManager()) == null) {
            return null;
        }
        ResourceReferencePsiElement psiManager = resourceReferencePsiElement;
        return () -> ResourceReferenceRenameProcessor.getPostRenameCallback$lambda$0((PsiManager)psiManager);
    }

    private static final void getPostRenameCallback$lambda$0(PsiManager $psiManager) {
        IdeResourcesUtil.scheduleNewResolutionAndHighlighting($psiManager);
    }

    static {
        Logger logger = Logger.getInstance(ResourceReferenceRenameProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceReferenceRenameProcessor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0012\u0010\u0010\u001a\f0\u000b\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceReferenceRenameProcessor$ResourceFileReference;", "Lcom/intellij/psi/PsiReference;", "myFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "getMyFile", "()Lcom/intellij/psi/PsiFile;", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "", "getElement", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "resolve", "getCanonicalText", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "bindToElement", "element", "isReferenceTo", "", "isSoft", "intellij.android.core"})
    public static final class ResourceFileReference
    implements PsiReference {
        @NotNull
        private final PsiFile myFile;

        public ResourceFileReference(@NotNull PsiFile myFile) {
            Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
            this.myFile = myFile;
        }

        @NotNull
        public final PsiFile getMyFile() {
            return this.myFile;
        }

        @NotNull
        public PsiElement handleElementRename(@NotNull String newElementName) {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            if (this.myFile.isValid()) {
                String string = this.myFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String originalName = string;
                String string2 = FileUtilRt.getNameWithoutExtension((String)originalName);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
                String nameWithoutExtension = string2;
                if (Intrinsics.areEqual((Object)nameWithoutExtension, (Object)originalName)) {
                    this.myFile.setName(newElementName);
                } else {
                    String string3 = FileUtilRt.getExtension((String)originalName);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getExtension(...)");
                    String extension = string3;
                    if (StringsKt.endsWith$default((String)nameWithoutExtension, (String)".9", (boolean)false, (int)2, null) && FileUtilRt.extensionEquals((String)originalName, (String)"png")) {
                        this.myFile.setName(newElementName + ".9." + extension);
                    } else {
                        this.myFile.setName(newElementName + "." + extension);
                    }
                }
            }
            return (PsiElement)this.myFile;
        }

        @NotNull
        public PsiFile getElement() {
            return this.myFile;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return textRange;
        }

        @NotNull
        public PsiFile resolve() {
            return this.myFile;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @NotNull
        public PsiElement bindToElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (PsiElement)this.myFile;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return false;
        }

        public boolean isSoft() {
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            try {
                nArray[ResourceType.ATTR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.STYLEABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

