/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.AgpVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.dsl.android.model.android.AndroidModelUtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslContextModel;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvokerKt;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.MigrateToDefaultTargetSdkToCompileSdkIfUnsetKt;
import org.jetbrains.android.refactoring.namespaces.PropertiesUsageInfo;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0003#$%B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u001f2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019H\u0014\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u001fH\u0014J\b\u0010\"\u001a\u00020\u000eH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "facetsToMigrate", "", "Lorg/jetbrains/android/facet/AndroidFacet;", "updateTopLevelGradleProperties", "", "agpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;ZLcom/android/ide/common/repository/AgpVersion;)V", "uuid", "", "getUuid", "()Ljava/lang/String;", "projectBuildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "Lorg/jetbrains/annotations/NotNull;", "getProjectBuildModel", "()Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "performPsiSpoilingRefactoring", "getCommandName", "Companion", "MigratePropertiesUsageInfo", "MigrateUsageInfo", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nMigrateToDefaultTargetSdkToCompileSdkIfUnset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateToDefaultTargetSdkToCompileSdkIfUnset.kt\norg/jetbrains/android/refactoring/MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,270:1\n1617#2,9:271\n1869#2:280\n1870#2:282\n1626#2:283\n1#3:281\n37#4:284\n36#4,3:285\n13472#5,2:288\n*S KotlinDebug\n*F\n+ 1 MigrateToDefaultTargetSdkToCompileSdkIfUnset.kt\norg/jetbrains/android/refactoring/MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor\n*L\n158#1:271,9\n158#1:280\n158#1:282\n158#1:283\n158#1:281\n191#1:284\n191#1:285,3\n197#1:288,2\n*E\n"})
public final class MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor
extends BaseRefactoringProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<AndroidFacet> facetsToMigrate;
    private final boolean updateTopLevelGradleProperties;
    @NotNull
    private final AgpVersion agpVersion;
    @NotNull
    private final String uuid;
    @NotNull
    private final ProjectBuildModel projectBuildModel;
    @NotNull
    private static final AgpVersion DEFAULT_TARGET_SDK_TO_COMPILE_SDK_IF_UNSET_ENABLE_BY_DEFAULT = AgpVersion.Companion.parse("9.0.0-alpha01");
    @NotNull
    private static final AgpVersion DEFAULT_TARGET_SDK_TO_COMPILE_SDK_IF_UNSET_AVAILABLE = AgpVersion.Companion.parse("8.11.0");
    @NotNull
    private static final Logger LOG;

    private MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor(Project project, Collection<? extends AndroidFacet> facetsToMigrate, boolean updateTopLevelGradleProperties, AgpVersion agpVersion) {
        super(project);
        this.facetsToMigrate = facetsToMigrate;
        this.updateTopLevelGradleProperties = updateTopLevelGradleProperties;
        this.agpVersion = agpVersion;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.uuid = string;
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        this.projectBuildModel = projectBuildModel;
    }

    @NotNull
    public final String getUuid() {
        return this.uuid;
    }

    @NotNull
    public final ProjectBuildModel getProjectBuildModel() {
        return this.projectBuildModel;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(){

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return AndroidBundle.message("android.refactoring.migrateto.resourceview.header", new Object[0]);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        void $this$mapNotNullTo$iv$iv;
        ProgressIndicator progressIndicator;
        ProgressIndicator progressIndicator2 = progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator2 != null) {
            progressIndicator2.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator3 = progressIndicator;
        if (progressIndicator3 != null) {
            progressIndicator3.setText(AndroidBundle.message("android.refactoring.migrateto.defaulttargetsdktocompilesdkifunset.progress.findusages", new Object[0]));
        }
        Iterable $this$mapNotNull$iv = this.facetsToMigrate;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MigrateUsageInfo migrateUsageInfo;
            GradleAndroidModel gradleAndroidModel;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AndroidFacet facet = (AndroidFacet)element$iv$iv;
            boolean bl2 = false;
            GradleAndroidModel gradleAndroidModel2 = GradleAndroidModel.Companion.get(facet);
            GradleAndroidModel gradleAndroidModel3 = gradleAndroidModel2;
            if ((gradleAndroidModel3 != null && (gradleAndroidModel3 = gradleAndroidModel3.getSelectedVariant()) != null ? gradleAndroidModel3.getTargetSdkVersion() : null) == null && ((gradleAndroidModel = gradleAndroidModel2) != null && (gradleAndroidModel = gradleAndroidModel.getSelectedVariant()) != null ? gradleAndroidModel.getMinSdkVersion() : null) != null) {
                if (this.projectBuildModel.getModuleBuildModel(facet.getModule()) != null) {
                    GradleBuildModel buildModel;
                    boolean bl3 = false;
                    if (buildModel.getPsiFile() != null) {
                        PsiFile it;
                        boolean bl4 = false;
                        PsiElement psiElement = (PsiElement)it;
                        Module module = facet.getModule();
                        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
                        migrateUsageInfo = new MigrateUsageInfo(psiElement, this.projectBuildModel, module, gradleAndroidModel2.getMinSdkVersion());
                    } else {
                        migrateUsageInfo = null;
                    }
                } else {
                    migrateUsageInfo = null;
                }
            } else {
                migrateUsageInfo = null;
            }
            if (migrateUsageInfo == null) continue;
            MigrateUsageInfo it$iv$iv = migrateUsageInfo;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List usages = (List)destination$iv$iv;
        ProgressIndicator progressIndicator4 = progressIndicator;
        if (progressIndicator4 != null) {
            progressIndicator4.setText(null);
        }
        List allUsageInfos = CollectionsKt.toMutableList((Collection)usages);
        if (this.updateTopLevelGradleProperties) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            PropertiesFile propertiesFile = AndroidRefactoringUtil.getProjectProperties(project, false);
            if (propertiesFile != null) {
                PsiFile psiFile = propertiesFile.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                allUsageInfos.add(new PropertiesUsageInfo("android.sdk.defaultTargetSdkToCompileSdkIfUnset", (PsiElement)psiFile));
            }
        }
        Collection $this$toTypedArray$iv = allUsageInfos;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
        UsageInfo[] $this$forEach$iv = usages;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            UsageInfo element$iv;
            UsageInfo it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            MigratePropertiesUsageInfo migratePropertiesUsageInfo = it instanceof MigratePropertiesUsageInfo ? (MigratePropertiesUsageInfo)it : null;
            if (migratePropertiesUsageInfo == null) continue;
            migratePropertiesUsageInfo.doIt();
        }
        if (this.updateTopLevelGradleProperties) {
            boolean onByDefault = this.agpVersion.compareTo(DEFAULT_TARGET_SDK_TO_COMPILE_SDK_IF_UNSET_ENABLE_BY_DEFAULT) >= 0;
            boolean available = this.agpVersion.compareTo(DEFAULT_TARGET_SDK_TO_COMPILE_SDK_IF_UNSET_AVAILABLE) >= 0;
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            PropertiesFile propertiesFile = AndroidRefactoringUtil.getProjectProperties(project, !onByDefault);
            if (propertiesFile != null) {
                if (onByDefault) {
                    PsiElement psiElement;
                    IProperty iProperty = propertiesFile.findPropertyByKey("android.sdk.defaultTargetSdkToCompileSdkIfUnset");
                    if (iProperty != null && (psiElement = iProperty.getPsiElement()) != null) {
                        psiElement.delete();
                    }
                } else if (available) {
                    IProperty iProperty = propertiesFile.findPropertyByKey("android.sdk.defaultTargetSdkToCompileSdkIfUnset");
                    if (iProperty != null) {
                        iProperty.setValue("true");
                    }
                } else {
                    LOG.error("AGP version too low for DefaultTargetSdkToCompileSdkIfUnset: " + this.agpVersion);
                }
            }
        }
    }

    protected void performPsiSpoilingRefactoring() {
        PropertiesFileImpl gradlePropertiesFile;
        PropertiesFileImpl propertiesFileImpl;
        this.projectBuildModel.applyChanges();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        PropertiesFile propertiesFile = AndroidRefactoringUtil.getProjectProperties(project, false);
        if (propertiesFile != null && (propertiesFile = propertiesFile.getVirtualFile()) != null) {
            PropertiesFile it = propertiesFile;
            boolean bl = false;
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)it);
            propertiesFileImpl = psiFile instanceof PropertiesFileImpl ? (PropertiesFileImpl)psiFile : null;
        } else {
            propertiesFileImpl = null;
        }
        PropertiesFileImpl propertiesFileImpl2 = gradlePropertiesFile = propertiesFileImpl;
        if (propertiesFileImpl2 != null) {
            PropertiesFileImpl it = propertiesFileImpl2;
            boolean bl = false;
            Document document = documentManager.getDocument((PsiFile)it);
            if (document != null) {
                Document document2 = document;
                if (documentManager.isDocumentBlockedByPsi(document2)) {
                    documentManager.doPostponedOperationsAndUnblockDocument(document2);
                }
                FileDocumentManager.getInstance().saveDocument(document2);
                if (!documentManager.isCommitted(document2)) {
                    documentManager.commitDocument(document2);
                }
            }
        }
        UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)new BasicUndoableAction(this){
            final /* synthetic */ MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public void undo() {
                GradleSyncInvoker gradleSyncInvoker = GradleSyncInvoker.Companion.getInstance();
                Project project = MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor.access$getMyProject$p$s1102214198(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getMyProject$p$s1102214198(...)");
                GradleSyncInvokerKt.requestProjectSync$default(gradleSyncInvoker, project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_UNDONE, null, 4, null);
            }

            public void redo() {
                GradleSyncInvoker gradleSyncInvoker = GradleSyncInvoker.Companion.getInstance();
                Project project = MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor.access$getMyProject$p$s1102214198(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getMyProject$p$s1102214198(...)");
                GradleSyncInvokerKt.requestProjectSync$default(gradleSyncInvoker, project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_REDONE, null, 4, null);
            }
        });
    }

    @NotNull
    protected String getCommandName() {
        String string = AndroidBundle.message("android.refactoring.migrateto.defaulttargetsdktocompilesdkifunset.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public /* synthetic */ MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor(Project project, Collection facetsToMigrate, boolean updateTopLevelGradleProperties, AgpVersion agpVersion, DefaultConstructorMarker $constructor_marker) {
        this(project, facetsToMigrate, updateTopLevelGradleProperties, agpVersion);
    }

    public static final /* synthetic */ Project access$getMyProject$p$s1102214198(MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor $this) {
        return $this.myProject;
    }

    static {
        Logger logger = Logger.getInstance(BaseRefactoringProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor$Companion;", "", "<init>", "()V", "DEFAULT_TARGET_SDK_TO_COMPILE_SDK_IF_UNSET_ENABLE_BY_DEFAULT", "Lcom/android/ide/common/repository/AgpVersion;", "DEFAULT_TARGET_SDK_TO_COMPILE_SDK_IF_UNSET_AVAILABLE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "forEntireProject", "Lorg/jetbrains/android/refactoring/MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "agpVersion", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor forEntireProject(@NotNull Project project, @NotNull AgpVersion agpVersion) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
            return new MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor(project, MigrateToDefaultTargetSdkToCompileSdkIfUnsetKt.access$findFacetsToMigrate(project), true, agpVersion, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor$MigratePropertiesUsageInfo;", "Lcom/intellij/usageView/UsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "doIt", "", "intellij.android.projectSystem.gradle"})
    public static abstract class MigratePropertiesUsageInfo
    extends UsageInfo {
        public MigratePropertiesUsageInfo(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element);
        }

        public abstract void doIt();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor$MigrateUsageInfo;", "Lorg/jetbrains/android/refactoring/MigrateToDefaultTargetSdkToCompileSdkIfUnsetProcessor$MigratePropertiesUsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "buildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "module", "Lcom/intellij/openapi/module/Module;", "minSdk", "Lcom/android/sdklib/AndroidVersion;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;Lcom/intellij/openapi/module/Module;Lcom/android/sdklib/AndroidVersion;)V", "getBuildModel", "()Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getMinSdk", "()Lcom/android/sdklib/AndroidVersion;", "doIt", "", "intellij.android.projectSystem.gradle"})
    public static final class MigrateUsageInfo
    extends MigratePropertiesUsageInfo {
        @NotNull
        private final ProjectBuildModel buildModel;
        @NotNull
        private final Module module;
        @NotNull
        private final AndroidVersion minSdk;

        public MigrateUsageInfo(@NotNull PsiElement element, @NotNull ProjectBuildModel buildModel, @NotNull Module module, @NotNull AndroidVersion minSdk) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)buildModel, (String)"buildModel");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)"minSdk");
            super(element);
            this.buildModel = buildModel;
            this.module = module;
            this.minSdk = minSdk;
        }

        @NotNull
        public final ProjectBuildModel getBuildModel() {
            return this.buildModel;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final AndroidVersion getMinSdk() {
            return this.minSdk;
        }

        @Override
        public void doIt() {
            block0: {
                GradleDslContextModel gradleDslContextModel = this.buildModel.getModuleBuildModel(this.module);
                if (gradleDslContextModel == null || (gradleDslContextModel = AndroidModelUtilsKt.android((GradleBuildModel)gradleDslContextModel)) == null || (gradleDslContextModel = gradleDslContextModel.defaultConfig()) == null || (gradleDslContextModel = gradleDslContextModel.targetSdkVersion()) == null) break block0;
                gradleDslContextModel.setValue(this.minSdk.getApiStringWithExtension());
            }
        }
    }
}

