/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"BUILDCONFIG_PROPERTY", "", "CHANGED_DEFAULT_VERSION", "Lcom/android/ide/common/repository/AgpVersion;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "shouldEnable", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.projectSystem.gradle"})
public final class MigrateBuildConfigFromGradlePropertiesKt {
    @NotNull
    private static final String BUILDCONFIG_PROPERTY = "android.defaults.buildfeatures.buildconfig";
    @NotNull
    private static final AgpVersion CHANGED_DEFAULT_VERSION = AgpVersion.Companion.parse("8.0.0-beta01");
    @NotNull
    private static final Logger LOG;

    private static final boolean shouldEnable(Project project) {
        boolean bl;
        VirtualFile virtualFile = project.getBaseDir();
        if (virtualFile == null || (virtualFile = VirtualFileUtil.findFile((VirtualFile)virtualFile, (String)"gradle.properties")) == null) {
            return false;
        }
        VirtualFile propertiesFile = virtualFile;
        if (!propertiesFile.isValid()) {
            return false;
        }
        AgpVersion agpVersion = GradleProjectSystemUtil.getAndroidGradleModelVersionInUse(project);
        if (agpVersion == null) {
            return false;
        }
        AgpVersion version2 = agpVersion;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(propertiesFile);
        PropertiesFile propertiesFile2 = psiFile instanceof PropertiesFile ? (PropertiesFile)psiFile : null;
        if (propertiesFile2 == null) {
            return false;
        }
        PropertiesFile propertiesPsi = propertiesFile2;
        IProperty property2 = propertiesPsi.findPropertyByKey(BUILDCONFIG_PROPERTY);
        if (version2.compareTo(CHANGED_DEFAULT_VERSION) < 0) {
            String string;
            Object object = property2;
            if (object != null && (object = object.getValue()) != null) {
                Object object2 = object;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string2 = ((String)object2).toLowerCase(locale);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            bl = !Intrinsics.areEqual(string, (Object)"false");
        } else if (version2.compareTo(CHANGED_DEFAULT_VERSION) >= 0) {
            bl = property2 != null;
        } else {
            throw new IllegalStateException("unreachable".toString());
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$shouldEnable(Project project) {
        return MigrateBuildConfigFromGradlePropertiesKt.shouldEnable(project);
    }

    public static final /* synthetic */ AgpVersion access$getCHANGED_DEFAULT_VERSION$p() {
        return CHANGED_DEFAULT_VERSION;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance((String)"MigrateBuildConfigFromGradleProperties");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

