/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.tools.idea.actions.ExportProjectZip;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.errorreporter.ErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a.\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0000\u001a*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007\u001a\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010\u001a$\u0010\"\u001a\u00020#2\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&\u001a\u0016\u0010'\u001a\u0004\u0018\u00010(*\u00020\u00012\b\b\u0002\u0010)\u001a\u00020*\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\u001d\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/actionSystem/DataContext;", "getProject", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/module/Module;", "getParentStyle", "Lorg/jetbrains/android/refactoring/StyleRefData;", "style", "Lorg/jetbrains/android/dom/resources/Style;", "computeAttributeMap", "", "Lorg/jetbrains/android/refactoring/AndroidAttributeInfo;", "", "errorReporter", "Lorg/jetbrains/android/refactoring/errorreporter/ErrorReporter;", "errorReportTitle", "findOrCreateClass", "Lcom/intellij/psi/PsiClass;", "migration", "Lcom/intellij/psi/PsiMigration;", "qName", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findOrCreatePackage", "Lcom/intellij/psi/PsiPackage;", "RESULT_MIGRATE_WITH_BACKUP", "", "RESULT_MIGRATE", "RESULT_CANCEL", "ACTION_WARNING_TEXT", "offerToCreateBackupAndRun", "", "title", "runRefactoring", "Lkotlin/Function0;", "getProjectProperties", "Lcom/intellij/lang/properties/psi/PropertiesFile;", "createIfNotExists", "", "intellij.android.core"})
@JvmName(name="AndroidRefactoringUtil")
@SourceDebugExtension(value={"SMAP\nAndroidRefactoringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidRefactoringUtil.kt\norg/jetbrains/android/refactoring/AndroidRefactoringUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
public final class AndroidRefactoringUtil {
    private static final int RESULT_MIGRATE_WITH_BACKUP = 0;
    private static final int RESULT_MIGRATE = 1;
    private static final int RESULT_CANCEL = 2;
    @NotNull
    private static final String ACTION_WARNING_TEXT = "\nBefore proceeding, we recommend that you make a backup of your project.\n\nDepending on your project dependencies, you might need to manually fix\nsome errors after the refactoring in order to successfully compile your project.\n\nDo you want to proceed with the migration?\n";

    @Nullable
    public static final Project getProject(@NotNull DataContext $this$project) {
        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"<this>");
        return (Project)LangDataKeys.PROJECT.getData($this$project);
    }

    @Nullable
    public static final Module getModule(@NotNull DataContext $this$module) {
        Intrinsics.checkNotNullParameter((Object)$this$module, (String)"<this>");
        return (Module)PlatformCoreDataKeys.MODULE.getData($this$module);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final StyleRefData getParentStyle(@NotNull Style style) {
        StyleRefData styleRefData;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        ResourceValue parentStyleRefValue = (ResourceValue)style.getParentStyle().getValue();
        if (parentStyleRefValue != null) {
            String string = parentStyleRefValue.getResourceName();
            if (string == null) return null;
            String it = string;
            boolean bl = false;
            styleRefData = new StyleRefData(it, parentStyleRefValue.getPackage());
            return styleRefData;
        } else {
            String string;
            String string2 = style.getName().getStringValue();
            if (string2 == null) return null;
            String it = string = string2;
            boolean bl = false;
            if (StringsKt.indexOf$default((CharSequence)it, (char)'.', (int)0, (boolean)false, (int)6, null) <= 0) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            String string3 = string;
            String string4 = string3;
            if (string4 == null) return null;
            it = string4;
            boolean bl3 = false;
            styleRefData = new StyleRefData(StringsKt.substringBeforeLast$default((String)it, (char)'.', null, (int)2, null), null);
        }
        return styleRefData;
    }

    @Nullable
    public static final Map<AndroidAttributeInfo, String> computeAttributeMap(@NotNull Style style, @NotNull ErrorReporter errorReporter, @NotNull String errorReportTitle) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)errorReportTitle, (String)"errorReportTitle");
        Map attributeValues = new LinkedHashMap();
        for (StyleItem item : style.getItems()) {
            String attributeName = item.getName().getStringValue();
            String attributeValue = item.getStringValue();
            CharSequence charSequence = attributeName;
            if (charSequence == null || charSequence.length() == 0 || attributeValue == null) continue;
            String localName = StringsKt.substringAfterLast$default((String)attributeName, (char)':', null, (int)2, null);
            String nsPrefix = StringsKt.substringBefore((String)attributeName, (char)':', (String)"");
            if (((CharSequence)nsPrefix).length() > 0) {
                if (!Intrinsics.areEqual((Object)"android", (Object)nsPrefix)) {
                    errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)("Unknown XML attribute prefix '" + nsPrefix + ":'")), errorReportTitle);
                    return null;
                }
            } else {
                errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)"The style contains attribute without 'android' prefix."), errorReportTitle);
                return null;
            }
            attributeValues.put(new AndroidAttributeInfo(localName, nsPrefix), attributeValue);
        }
        return attributeValues;
    }

    @JvmOverloads
    @NotNull
    public static final PsiClass findOrCreateClass(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(qName, scope);
        if (psiClass == null) {
            Object object = ActionsKt.runWriteAction(() -> AndroidRefactoringUtil.findOrCreateClass$lambda$0(migration, qName));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
            psiClass = (PsiClass)object;
        }
        return psiClass;
    }

    public static /* synthetic */ PsiClass findOrCreateClass$default(Project project, PsiMigration psiMigration, String string, GlobalSearchScope globalSearchScope, int n, Object object) {
        if ((n & 8) != 0) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"allScope(...)");
            globalSearchScope = globalSearchScope2;
        }
        return AndroidRefactoringUtil.findOrCreateClass(project, psiMigration, string, globalSearchScope);
    }

    @NotNull
    public static final PsiPackage findOrCreatePackage(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(qName);
        if (psiPackage == null) {
            Object object = ActionsKt.runWriteAction(() -> AndroidRefactoringUtil.findOrCreatePackage$lambda$0(migration, qName));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
            psiPackage = (PsiPackage)object;
        }
        return psiPackage;
    }

    public static final void offerToCreateBackupAndRun(@NotNull Project project, @NotNull String title2, @NotNull Function0<Unit> runRefactoring) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(runRefactoring, (String)"runRefactoring");
        String[] stringArray = new String[]{"Migrate", "Cancel"};
        int okCancelResult = Messages.showCheckboxMessageDialog((String)((Object)StringsKt.trim((CharSequence)ACTION_WARNING_TEXT)).toString(), (String)title2, (String[])stringArray, (String)"Backup project as Zip file", (boolean)true, (int)0, (int)0, (Icon)Messages.getWarningIcon(), AndroidRefactoringUtil::offerToCreateBackupAndRun$lambda$0);
        switch (okCancelResult) {
            case 2: {
                return;
            }
            case 0: {
                ExportProjectZip exportZip = new ExportProjectZip();
                AnAction anAction = exportZip;
                DataContext dataContext = SimpleDataContext.getProjectContext((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getProjectContext(...)");
                ActionUtil.invokeAction((AnAction)anAction, (DataContext)dataContext, (String)title2, null, () -> AndroidRefactoringUtil.offerToCreateBackupAndRun$lambda$1(runRefactoring));
                break;
            }
            default: {
                runRefactoring.invoke();
            }
        }
    }

    @Nullable
    public static final PropertiesFile getProjectProperties(@NotNull Project $this$getProjectProperties, boolean createIfNotExists) {
        VirtualFile gradlePropertiesFile;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getProjectProperties, (String)"<this>");
        if ($this$getProjectProperties.isDisposed()) {
            return null;
        }
        VirtualFile projectBaseDirectory = ProjectUtil.guessProjectDir((Project)$this$getProjectProperties);
        if (createIfNotExists) {
            VirtualFile virtualFile = projectBaseDirectory;
            object = virtualFile != null ? virtualFile.findOrCreateChildData((Object)$this$getProjectProperties, "gradle.properties") : null;
        } else {
            VirtualFile virtualFile = projectBaseDirectory;
            object = virtualFile != null ? virtualFile.findChild("gradle.properties") : null;
        }
        VirtualFile virtualFile = gradlePropertiesFile = object;
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiPropertiesFile = PsiManager.getInstance((Project)$this$getProjectProperties).findFile(virtualFile);
        return psiPropertiesFile instanceof PropertiesFile ? (PropertiesFile)psiPropertiesFile : null;
    }

    public static /* synthetic */ PropertiesFile getProjectProperties$default(Project project, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return AndroidRefactoringUtil.getProjectProperties(project, bl);
    }

    @JvmOverloads
    @NotNull
    public static final PsiClass findOrCreateClass(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        return AndroidRefactoringUtil.findOrCreateClass$default(project, migration, qName, null, 8, null);
    }

    private static final PsiClass findOrCreateClass$lambda$0(PsiMigration $migration, String $qName) {
        return $migration.createClass($qName);
    }

    private static final PsiPackage findOrCreatePackage$lambda$0(PsiMigration $migration, String $qName) {
        return $migration.createPackage($qName);
    }

    private static final Integer offerToCreateBackupAndRun$lambda$0(int index, JCheckBox checkbox) {
        Intrinsics.checkNotNullParameter((Object)checkbox, (String)"checkbox");
        return index != 0 ? 2 : (checkbox.isSelected() ? 0 : 1);
    }

    private static final void offerToCreateBackupAndRun$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

