/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.refactoring.AndroidFindStyleApplicationsProcessor;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindStyleApplicationsDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JBRadioButton myModuleScopeRadio;
    private JBRadioButton myFileScopeRadio;
    private JBRadioButton myProjectScopeRadio;
    private JBLabel myCaptionLabel;
    private final VirtualFile myFile;
    private final AndroidFindStyleApplicationsProcessor myProcessor;
    private static final String FIND_STYLE_APPLICATIONS_SCOPE_PROPERTY = "ANDROID_FIND_STYLE_APPLICATION_SCOPE";

    protected AndroidFindStyleApplicationsDialog(@Nullable VirtualFile file, @NotNull AndroidFindStyleApplicationsProcessor processor, boolean showModuleRadio) {
        super(processor.getModule().getProject(), true);
        this.setupUI();
        this.myFile = file;
        this.myProcessor = processor;
        Module module = processor.getModule();
        this.myModuleScopeRadio.setText(CodeInsightBundle.message((String)"scope.option.module.with.mnemonic", (Object[])new Object[]{module.getName()}));
        this.myModuleScopeRadio.setVisible(showModuleRadio);
        if (file != null) {
            this.myFileScopeRadio.setText("File '" + file.getName() + "'");
        } else {
            this.myFileScopeRadio.setVisible(false);
        }
        String scopeValue = PropertiesComponent.getInstance().getValue(FIND_STYLE_APPLICATIONS_SCOPE_PROPERTY);
        AndroidFindStyleApplicationsProcessor.MyScope scope = null;
        if (scopeValue != null) {
            try {
                scope = Enum.valueOf(AndroidFindStyleApplicationsProcessor.MyScope.class, scopeValue);
            }
            catch (IllegalArgumentException e) {
                scope = null;
            }
        }
        if (scope == null) {
            scope = AndroidFindStyleApplicationsProcessor.MyScope.FILE;
        }
        switch (scope) {
            case PROJECT: {
                this.myProjectScopeRadio.setSelected(true);
                break;
            }
            case MODULE: {
                this.myModuleScopeRadio.setSelected(true);
                break;
            }
            case FILE: {
                this.myFileScopeRadio.setSelected(true);
            }
        }
        if (this.myModuleScopeRadio.isSelected() && !this.myModuleScopeRadio.isVisible() || this.myFileScopeRadio.isSelected() && !this.myFileScopeRadio.isVisible()) {
            this.myProjectScopeRadio.setSelected(true);
        }
        this.myCaptionLabel.setText("Choose a scope where to search possible applications of style '" + this.myProcessor.getStyleName() + "'");
        this.setTitle(AndroidBundle.message("android.find.style.applications.title", new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        AndroidFindStyleApplicationsProcessor.MyScope scope = this.myModuleScopeRadio.isSelected() ? AndroidFindStyleApplicationsProcessor.MyScope.MODULE : (this.myProjectScopeRadio.isSelected() ? AndroidFindStyleApplicationsProcessor.MyScope.PROJECT : AndroidFindStyleApplicationsProcessor.MyScope.FILE);
        PropertiesComponent.getInstance().setValue(FIND_STYLE_APPLICATIONS_SCOPE_PROPERTY, scope.name());
        this.myProcessor.configureScope(scope, this.myFile);
        this.myProcessor.setPrepareSuccessfulSwingThreadCallback(new Runnable(){

            @Override
            public void run() {
                AndroidFindStyleApplicationsDialog.this.close(0);
            }
        });
        this.myProcessor.run();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myCaptionLabel = new JBLabel();
        this.myCaptionLabel.setText("");
        this.myPanel.add((Component)this.myCaptionLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myProjectScopeRadio = new JBRadioButton();
        this.myProjectScopeRadio.setText("Whole project");
        this.myProjectScopeRadio.setMnemonic('W');
        this.myProjectScopeRadio.setDisplayedMnemonicIndex(0);
        panel1.add((Component)this.myProjectScopeRadio, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myModuleScopeRadio = new JBRadioButton();
        panel1.add((Component)this.myModuleScopeRadio, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myFileScopeRadio = new JBRadioButton();
        this.myFileScopeRadio.setText("Current file");
        this.myFileScopeRadio.setMnemonic('F');
        this.myFileScopeRadio.setDisplayedMnemonicIndex(8);
        panel1.add((Component)this.myFileScopeRadio, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.myProjectScopeRadio);
        buttonGroup.add((AbstractButton)this.myModuleScopeRadio);
        buttonGroup.add((AbstractButton)this.myFileScopeRadio);
    }
}

