/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.SdkUtils;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.AndroidGotoRelatedLineMarkerProvider;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.layout.LayoutViewElementDomFileDescription;
import org.jetbrains.android.dom.menu.MenuDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.intentions.AndroidCreateOnClickHandlerAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

public class AndroidMissingOnClickHandlerInspection
extends LocalInspectionTool {
    @NotNull
    private static Set<PsiClass> findRelatedActivities(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        if (AndroidResourceDomFileDescription.isFileInResourceFolderType(file, ResourceFolderType.LAYOUT)) {
            List<GotoRelatedItem> items = AndroidGotoRelatedLineMarkerProvider.Handler.getItemsForXmlFile(file, facet);
            if (items == null || items.isEmpty()) {
                return Collections.emptySet();
            }
            return items.stream().map(item -> {
                PsiElement itemElement = item.getElement();
                if (itemElement instanceof PsiClass) {
                    return (PsiClass)itemElement;
                }
                if (itemElement instanceof KtClass) {
                    return LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClass)itemElement));
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return AndroidMissingOnClickHandlerInspection.findRelatedActivitiesForMenu(file, facet);
    }

    @NotNull
    private static Set<PsiClass> findRelatedActivitiesForMenu(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        String resourceName = SdkUtils.fileNameToResourceName((String)file.getName());
        PsiField[] fields2 = IdeResourcesUtil.findResourceFields(facet, ResourceType.MENU.getName(), resourceName);
        if (fields2.length == 0) {
            return Collections.emptySet();
        }
        Module module = facet.getModule();
        GlobalSearchScope scope = module.getModuleScope(false);
        PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(module);
        if (activityClass == null) {
            return Collections.emptySet();
        }
        HashSet<PsiClass> result2 = new HashSet<PsiClass>();
        PsiField menuResourceField = fields2[0];
        ReferencesSearch.search((PsiElement)menuResourceField, (SearchScope)scope).forEach(reference -> {
            PsiElement element = reference.getElement();
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (aClass != null && !result2.contains(aClass) && aClass.isInheritor(activityClass, true)) {
                result2.add(aClass);
            }
            return true;
        });
        return result2;
    }

    @Nullable
    public static PsiClass findActivityClass(@NotNull Module module) {
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("android.app.Activity", module.getModuleWithDependenciesAndLibrariesScope(false));
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DomFileDescription description2 = DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file);
        if (!(description2 instanceof LayoutViewElementDomFileDescription) && !(description2 instanceof MenuDomFileDescription)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        MyVisitor visitor2 = new MyVisitor(manager, isOnTheFly);
        file.accept((PsiElementVisitor)visitor2);
        return visitor2.myResult.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(@NotNull InspectionManager inspectionManager, boolean onTheFly) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
        }

        public void visitXmlAttributeValue(@NotNull XmlAttributeValue value2) {
            for (PsiReference reference : value2.getReferences()) {
                OnClickConverter.MyReference ref;
                String methodName;
                if (!(reference instanceof OnClickConverter.MyReference) || (methodName = (ref = (OnClickConverter.MyReference)reference).getValue()).isEmpty()) continue;
                ResolveResult[] results2 = ref.multiResolve(false);
                HashSet<PsiClass> resolvedClasses = new HashSet<PsiClass>();
                HashSet<PsiClass> resolvedClassesWithMistake = new HashSet<PsiClass>();
                for (ResolveResult result2 : results2) {
                    PsiClass aClass;
                    PsiElement element;
                    if (!(result2 instanceof OnClickConverter.MyResolveResult) || (element = result2.getElement()) == null || (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) == null) continue;
                    resolvedClasses.add(aClass);
                    if (((OnClickConverter.MyResolveResult)result2).hasCorrectSignature()) continue;
                    resolvedClassesWithMistake.add(aClass);
                }
                PsiClass activity = null;
                PsiFile containingFile = value2.getContainingFile();
                AndroidFacet facet = AndroidFacet.getInstance((PsiElement)containingFile);
                if (facet == null) {
                    return;
                }
                Set<PsiClass> activities = AndroidMissingOnClickHandlerInspection.findRelatedActivities((XmlFile)containingFile, facet);
                for (PsiClass relatedActivity : activities) {
                    if (!MyVisitor.containsOrExtends(resolvedClasses, relatedActivity)) {
                        activity = relatedActivity;
                        break;
                    }
                    if (activity != null || !MyVisitor.containsOrExtends(resolvedClassesWithMistake, relatedActivity)) continue;
                    activity = relatedActivity;
                }
                if (activity != null) {
                    this.reportMissingOnClickProblem(ref, activity, methodName, resolvedClassesWithMistake.contains(activity));
                    continue;
                }
                if (results2.length == 0) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)value2, reference.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]));
                    continue;
                }
                if (resolvedClassesWithMistake.isEmpty()) continue;
                this.reportMissingOnClickProblem(ref, (PsiClass)resolvedClassesWithMistake.iterator().next(), methodName, true);
            }
        }

        private static boolean containsOrExtends(@NotNull Set<PsiClass> resolvedClasses, @NotNull PsiClass relatedActivity) {
            if (resolvedClasses.contains(relatedActivity)) {
                return true;
            }
            for (PsiClass resolvedClass : resolvedClasses) {
                if (!relatedActivity.isInheritor(resolvedClass, false)) continue;
                return true;
            }
            return false;
        }

        private void reportMissingOnClickProblem(OnClickConverter.MyReference reference, PsiClass activity, String methodName, boolean incorrectSignature) {
            LocalQuickFix[] localQuickFixArray;
            String message;
            String activityName = activity.getName();
            if (activityName == null) {
                activityName = "";
            }
            String string = message = incorrectSignature ? AndroidBundle.message("android.inspections.on.click.missing.incorrect.signature", methodName, activityName) : AndroidBundle.message("android.inspections.on.click.missing.problem", methodName, activityName);
            if (StringUtil.isJavaIdentifier((String)methodName)) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new MyQuickFix(methodName, reference.getConverter(), activity);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myResult.add(this.myInspectionManager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, fixes));
        }
    }

    public static class MyQuickFix
    extends AbstractIntentionAction
    implements LocalQuickFix {
        private final String myMethodName;
        private final OnClickConverter myConverter;
        private final PsiClass myClass;

        private MyQuickFix(@NotNull String methodName, @NotNull OnClickConverter converter, @NotNull PsiClass aClass) {
            this.myMethodName = methodName;
            this.myConverter = converter;
            this.myClass = aClass;
        }

        @NotNull
        public String getFamilyName() {
            return "Create '" + this.myMethodName + "(" + this.myConverter.getShortParameterName() + ")' in '" + this.myClass.getName() + "'";
        }

        @NotNull
        public String getText() {
            return this.getName();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethodAndNavigate(project, this.myClass, this.myMethodName, paramType);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            this.doApplyFix(project);
        }

        public void doApplyFix(@NotNull Project project) {
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethod(project, this.myClass, this.myMethodName, paramType);
        }
    }
}

