/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.AndroidXConstants;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidComponentEntryPoint
extends EntryPoint {
    public boolean ADD_ANDROID_COMPONENTS_TO_ENTRIES = true;
    private static final String[] ANDROID_ENTRY_CLASSES = new String[]{"android.app.Application", "android.app.Activity", "android.app.Service", "android.app.Fragment", AndroidXConstants.CLASS_V4_FRAGMENT.oldName(), AndroidXConstants.CLASS_V4_FRAGMENT.newName(), "android.content.ContentProvider", "android.content.BroadcastReceiver", "android.view.View", "android.view.ActionProvider", "android.os.Parcelable", "android.app.backup.BackupAgent", "android.content.Context"};

    @NotNull
    public String getDisplayName() {
        return AndroidBundle.message("android.component.entry.point", new Object[0]);
    }

    public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        return this.isEntryPoint(psiElement);
    }

    public boolean isEntryPoint(@NotNull PsiElement psiElement) {
        return this.ADD_ANDROID_COMPONENTS_TO_ENTRIES && psiElement instanceof PsiClass && Arrays.stream(ANDROID_ENTRY_CLASSES).anyMatch(baseClass -> InheritanceUtil.isInheritor((PsiClass)((PsiClass)psiElement), (String)baseClass));
    }

    public boolean isSelected() {
        return this.ADD_ANDROID_COMPONENTS_TO_ENTRIES;
    }

    public void setSelected(boolean selected) {
        this.ADD_ANDROID_COMPONENTS_TO_ENTRIES = selected;
    }

    public void readExternal(@NotNull Element element) {
        XmlSerializer.deserializeInto((Element)element, (Object)((Object)this));
    }

    public void writeExternal(@NotNull Element element) {
        XmlSerializer.serializeObjectInto((Object)((Object)this), (Element)element);
    }
}

