/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.DelegatingFormattingModel;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.xml.XmlFormattingModelBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.dom.color.fileDescriptions.ColorStateListDomFileDescription;
import org.jetbrains.android.dom.drawable.fileDescriptions.DrawableStateListDomFileDescription;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlFormattingModelBuilder
implements CustomFormattingModelBuilder {
    private final XmlFormattingModelBuilder myXmlFormattingModelBuilder = new XmlFormattingModelBuilder();

    public boolean isEngagedToFormat(@NotNull PsiElement context) {
        XmlFile xmlFile = AndroidXmlFormattingModelBuilder.getOriginalContainingXmlFile(context);
        if (xmlFile == null || xmlFile instanceof HtmlCompatibleFile) {
            return false;
        }
        return new ColorStateListDomFileDescription().isMyFile(xmlFile, null) || new DrawableStateListDomFileDescription().isMyFile(xmlFile, null) || ManifestDomFileDescription.isManifestFile(xmlFile) || IdeResourcesUtil.getFolderType((PsiFile)xmlFile) != null;
    }

    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        FormattingModel baseModel = this.myXmlFormattingModelBuilder.createModel(formattingContext);
        CodeStyleSettings codeStyleSettings = formattingContext.getCodeStyleSettings();
        AndroidXmlCodeStyleSettings baseSettings = AndroidXmlCodeStyleSettings.getInstance(codeStyleSettings);
        if (!baseSettings.USE_CUSTOM_SETTINGS) {
            return baseModel;
        }
        AndroidXmlCodeStyleSettings.MySettings settings = AndroidXmlFormattingModelBuilder.getContextSpecificSettings(formattingContext.getPsiElement(), baseSettings);
        return settings != null ? new DelegatingFormattingModel(baseModel, AndroidXmlFormattingModelBuilder.createDelegatingBlock(baseModel, settings, codeStyleSettings)) : baseModel;
    }

    private static Block createDelegatingBlock(FormattingModel model, AndroidXmlCodeStyleSettings.MySettings customSettings, CodeStyleSettings settings) {
        Block block = model.getRootBlock();
        if (block instanceof XmlBlock) {
            XmlBlock b = (XmlBlock)block;
            XmlPolicy policy = customSettings.createXmlPolicy(settings, model.getDocumentModel());
            return new XmlBlock(b.getNode(), b.getWrap(), b.getAlignment(), (XmlFormattingPolicy)policy, b.getIndent(), b.getTextRange()){

                protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
                    return new XmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace());
                }
            };
        }
        return block;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return this.myXmlFormattingModelBuilder.getRangeAffectingIndent(file, offset, elementAtOffset);
    }

    @Nullable
    private static AndroidXmlCodeStyleSettings.MySettings getContextSpecificSettings(@NotNull PsiElement context, @NotNull AndroidXmlCodeStyleSettings settings) {
        XmlFile xmlFile = AndroidXmlFormattingModelBuilder.getOriginalContainingXmlFile(context);
        if (xmlFile == null) {
            return null;
        }
        if (new ColorStateListDomFileDescription().isMyFile(xmlFile, null) || new DrawableStateListDomFileDescription().isMyFile(xmlFile, null)) {
            return settings.VALUE_RESOURCE_FILE_SETTINGS;
        }
        if (ManifestDomFileDescription.isManifestFile(xmlFile)) {
            return settings.MANIFEST_SETTINGS;
        }
        ResourceFolderType type = IdeResourcesUtil.getFolderType((PsiFile)xmlFile);
        if (type == null) {
            return null;
        }
        switch (type) {
            case ANIM: 
            case ANIMATOR: 
            case COLOR: 
            case DRAWABLE: 
            case FONT: 
            case INTERPOLATOR: {
                return settings.OTHER_SETTINGS;
            }
            case LAYOUT: {
                return settings.LAYOUT_SETTINGS;
            }
            case MENU: 
            case MIPMAP: 
            case NAVIGATION: 
            case RAW: 
            case TRANSITION: {
                return settings.OTHER_SETTINGS;
            }
            case VALUES: {
                return settings.VALUE_RESOURCE_FILE_SETTINGS;
            }
            case XML: {
                return settings.OTHER_SETTINGS;
            }
        }
        return null;
    }

    @Nullable
    private static XmlFile getOriginalContainingXmlFile(PsiElement context) {
        PsiFile psiFile = context.getContainingFile().getOriginalFile();
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        PsiFile originalFile = (PsiFile)xmlFile.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (originalFile instanceof XmlFile) {
            XmlFile originalXmlFile = (XmlFile)originalFile;
            return originalXmlFile;
        }
        return xmlFile;
    }
}

