/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.xml;

import com.android.AndroidXConstants;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.psi.TagToClassMapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.xml.XmlResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0007R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/android/dom/xml/AndroidXmlResourcesUtil;", "", "<init>", "()V", "SPECIAL_STYLEABLE_NAMES", "", "", "KNOWN_ROOT_TAGS", "", "getPossibleRoots", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "isSupportedRootTag", "", "rootTagName", "PreferenceSource", "intellij.android.core"})
public final class AndroidXmlResourcesUtil {
    @NotNull
    public static final AndroidXmlResourcesUtil INSTANCE = new AndroidXmlResourcesUtil();
    @JvmField
    @NotNull
    public static final Map<String, String> SPECIAL_STYLEABLE_NAMES;
    @JvmField
    @NotNull
    public static final Set<String> KNOWN_ROOT_TAGS;

    private AndroidXmlResourcesUtil() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> getPossibleRoots(@NotNull AndroidFacet facet) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Module module = facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        Module module2 = module;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module2.getProject());
        Intrinsics.checkNotNull((Object)javaPsiFacade);
        PreferenceSource preferenceSource = AndroidXmlResourcesUtil.getPossibleRoots$hasClass(javaPsiFacade, module2, PreferenceSource.ANDROIDX.getQualifiedBaseClass()) ? PreferenceSource.ANDROIDX : (AndroidXmlResourcesUtil.getPossibleRoots$hasClass(javaPsiFacade, module2, PreferenceSource.SUPPORT.getQualifiedBaseClass()) ? PreferenceSource.SUPPORT : PreferenceSource.FRAMEWORK);
        Map<String, PsiClass> map2 = TagToClassMapper.getInstance(module2).getClassMap(preferenceSource.getQualifiedBaseClass());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getClassMap(...)");
        Map<String, PsiClass> classMap = map2;
        List $this$getPossibleRoots_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Collection<String> collection2 = AndroidDomUtil.removeUnambiguousNames(classMap);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"removeUnambiguousNames(...)");
        $this$getPossibleRoots_u24lambda_u240.addAll(collection2);
        $this$getPossibleRoots_u24lambda_u240.addAll((Collection)KNOWN_ROOT_TAGS);
        return CollectionsKt.build((List)list2);
    }

    @JvmStatic
    public static final boolean isSupportedRootTag(@NotNull AndroidFacet facet, @NotNull String rootTagName) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)rootTagName, (String)"rootTagName");
        return KNOWN_ROOT_TAGS.contains(rootTagName) || AndroidClassesForXmlUtilKt.findClassValidInXMLByName(facet, rootTagName, "android.preference.Preference") != null;
    }

    private static final boolean getPossibleRoots$hasClass(JavaPsiFacade $this$getPossibleRoots_u24hasClass, Module module, String className) {
        return $this$getPossibleRoots_u24hasClass.findClass(className, module.getModuleWithLibrariesScope()) != null;
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"appwidget-provider", (Object)"AppWidgetProviderInfo"), TuplesKt.to((Object)"searchable", (Object)"Searchable"), TuplesKt.to((Object)"actionkey", (Object)"SearchableActionKey"), TuplesKt.to((Object)"intent", (Object)"Intent"), TuplesKt.to((Object)"Keyboard", (Object)"Keyboard"), TuplesKt.to((Object)"Row", (Object)"Keyboard_Row"), TuplesKt.to((Object)"Key", (Object)"Keyboard_Key"), TuplesKt.to((Object)"device-admin", (Object)"DeviceAdmin"), TuplesKt.to((Object)"account-authenticator", (Object)"AccountAuthenticator"), TuplesKt.to((Object)"header", (Object)"PreferenceHeader")};
        SPECIAL_STYLEABLE_NAMES = MapsKt.mapOf((Pair[])object);
        Object $this$KNOWN_ROOT_TAGS_u24lambda_u240 = object = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$KNOWN_ROOT_TAGS_u24lambda_u240.addAll((Collection)XmlResourceDomFileDescription.Util.SUPPORTED_TAGS);
        $this$KNOWN_ROOT_TAGS_u24lambda_u240.add("restrictions");
        $this$KNOWN_ROOT_TAGS_u24lambda_u240.add("paths");
        $this$KNOWN_ROOT_TAGS_u24lambda_u240.add("MotionScene");
        $this$KNOWN_ROOT_TAGS_u24lambda_u240.add("accessibility-service");
        if (((Boolean)StudioFlags.WEAR_DECLARATIVE_WATCH_FACE_XML_EDITOR_SUPPORT.get()).booleanValue()) {
            $this$KNOWN_ROOT_TAGS_u24lambda_u240.add("WatchFaces");
            $this$KNOWN_ROOT_TAGS_u24lambda_u240.add("WatchFaceInfo");
        }
        KNOWN_ROOT_TAGS = SetsKt.build((Set)object);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/android/dom/xml/AndroidXmlResourcesUtil$PreferenceSource;", "", "qualifiedBaseClass", "", "qualifiedGroupClass", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getQualifiedBaseClass", "()Ljava/lang/String;", "getQualifiedGroupClass", "ANDROIDX", "SUPPORT", "FRAMEWORK", "Companion", "intellij.android.core"})
    public static final class PreferenceSource
    extends Enum<PreferenceSource> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String qualifiedBaseClass;
        @NotNull
        private final String qualifiedGroupClass;
        public static final /* enum */ PreferenceSource ANDROIDX;
        public static final /* enum */ PreferenceSource SUPPORT;
        public static final /* enum */ PreferenceSource FRAMEWORK;
        private static final /* synthetic */ PreferenceSource[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PreferenceSource(String qualifiedBaseClass, String qualifiedGroupClass) {
            this.qualifiedBaseClass = qualifiedBaseClass;
            this.qualifiedGroupClass = qualifiedGroupClass;
        }

        @NotNull
        public final String getQualifiedBaseClass() {
            return this.qualifiedBaseClass;
        }

        @NotNull
        public final String getQualifiedGroupClass() {
            return this.qualifiedGroupClass;
        }

        public static PreferenceSource[] values() {
            return (PreferenceSource[])$VALUES.clone();
        }

        public static PreferenceSource valueOf(String value2) {
            return Enum.valueOf(PreferenceSource.class, value2);
        }

        @NotNull
        public static EnumEntries<PreferenceSource> getEntries() {
            return $ENTRIES;
        }

        @JvmStatic
        @NotNull
        public static final PreferenceSource getPreferencesSource(@NotNull XmlTag tag, @NotNull AndroidFacet facet) {
            return Companion.getPreferencesSource(tag, facet);
        }

        static {
            String string = AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_ANDROIDX.newName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newName(...)");
            String string2 = AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_GROUP_ANDROIDX.newName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"newName(...)");
            ANDROIDX = new PreferenceSource(string, string2);
            String string3 = AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_ANDROIDX.oldName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"oldName(...)");
            String string4 = AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_GROUP_ANDROIDX.oldName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"oldName(...)");
            SUPPORT = new PreferenceSource(string3, string4);
            FRAMEWORK = new PreferenceSource("android.preference.Preference", "android.preference.PreferenceGroup");
            $VALUES = preferenceSourceArray = new PreferenceSource[]{PreferenceSource.ANDROIDX, PreferenceSource.SUPPORT, PreferenceSource.FRAMEWORK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/dom/xml/AndroidXmlResourcesUtil$PreferenceSource$Companion;", "", "<init>", "()V", "getPreferencesSource", "Lorg/jetbrains/android/dom/xml/AndroidXmlResourcesUtil$PreferenceSource;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final PreferenceSource getPreferencesSource(@NotNull XmlTag tag, @NotNull AndroidFacet facet) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
                PsiFile psiFile = tag.getContainingFile();
                Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
                XmlTag xmlTag = ((XmlFile)psiFile).getRootTag();
                if (xmlTag == null) {
                    return FRAMEWORK;
                }
                XmlTag rootTag = xmlTag;
                String string = rootTag.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String rootTagName = string;
                if (StringsKt.startsWith$default((String)rootTagName, (String)"androidx.", (boolean)false, (int)2, null)) {
                    return ANDROIDX;
                }
                if (StringsKt.startsWith$default((String)rootTagName, (String)"android.support.v", (boolean)false, (int)2, null)) {
                    String string2 = StringUtil.getPackageName((String)rootTagName);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageName(...)");
                    if (StringsKt.endsWith$default((String)string2, (String)"preference", (boolean)false, (int)2, null)) {
                        return SUPPORT;
                    }
                }
                if (StringsKt.startsWith$default((String)rootTagName, (String)"android.", (boolean)false, (int)2, null)) {
                    return FRAMEWORK;
                }
                Project project = facet.getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                String supportLibName = AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_ANDROIDX.oldName();
                String androidXLibName = AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_ANDROIDX.newName();
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
                if (psiFacade.findClass(supportLibName, rootTag.getResolveScope()) == null && psiFacade.findClass(androidXLibName, rootTag.getResolveScope()) == null) {
                    return FRAMEWORK;
                }
                PsiJavaParserFacade psiJavaParserFacade = psiFacade.getParserFacade();
                Intrinsics.checkNotNullExpressionValue((Object)psiJavaParserFacade, (String)"getParserFacade(...)");
                PsiJavaParserFacade parser = psiJavaParserFacade;
                try {
                    PsiType psiType = parser.createTypeFromText(rootTagName, null);
                    Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"createTypeFromText(...)");
                    PsiType type = psiType;
                    if (type instanceof PsiClassType && ((PsiClassType)type).resolve() != null) {
                        return InheritanceUtil.isInheritor((PsiType)type, (String)androidXLibName) ? ANDROIDX : (InheritanceUtil.isInheritor((PsiType)type, (String)supportLibName) ? SUPPORT : FRAMEWORK);
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
                if (psiFacade.findClass(androidXLibName, rootTag.getResolveScope()) != null) {
                    return ANDROIDX;
                }
                return SUPPORT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

