/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure.manifest;

import com.android.tools.idea.projectsystem.AndroidIconProviderProjectToken;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.annotations.Nullable;

public class ApplicationPresentationProvider
extends PresentationProvider<Application> {
    @Nullable
    public String getName(Application application) {
        PsiClass aClass = (PsiClass)application.getName().getValue();
        return aClass == null ? null : aClass.getName();
    }

    @Nullable
    public Icon getIcon(Application application) {
        Module module = application.getModule();
        if (module != null) {
            Project project = module.getProject();
            AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
            AndroidIconProviderProjectToken token = AndroidIconProviderProjectToken.getEP_NAME().getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst().orElse(null);
            if (token != null) {
                return token.getModuleIcon(projectSystem, module);
            }
        }
        return StudioIcons.Shell.Filetree.ANDROID_MODULE;
    }

    @Nullable
    public String getTypeName(Application application) {
        return "Application";
    }
}

