/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.RClassNaming;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.DataBindingUtils;
import com.android.utils.HashCodes;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.util.PsiUtil;
import java.util.Objects;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceValue {
    private static final String PLUS_ID = "+id";
    private String myValue;
    private char myPrefix;
    private String myPackage;
    private String myResourceType;
    private String myResourceName;
    public static final ResourceValue INVALID = new ResourceValue();

    private ResourceValue() {
    }

    public char getPrefix() {
        return this.myPrefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceValue that = (ResourceValue)o;
        if (this.myPrefix != that.myPrefix) {
            return false;
        }
        if (!Objects.equals(this.myPackage, that.myPackage)) {
            return false;
        }
        if (!Objects.equals(this.myResourceName, that.myResourceName)) {
            return false;
        }
        if (!Objects.equals(this.myResourceType, that.myResourceType)) {
            return false;
        }
        return Objects.equals(this.myValue, that.myValue);
    }

    public int hashCode() {
        return HashCodes.mix((int)Objects.hashCode(this.myValue), (int)Character.hashCode(this.myPrefix), (int)Objects.hashCode(this.myPackage), (int)Objects.hashCode(this.myResourceType), (int)Objects.hashCode(this.myResourceName));
    }

    @Nullable
    public static ResourceValue parse(@Nullable String s, boolean withLiterals, boolean withPrefix, boolean requireValid) {
        ResourceValue reference;
        if (s == null) {
            return null;
        }
        if ((s.startsWith("@") || s.startsWith("?")) && !DataBindingUtils.isBindingExpression((String)s)) {
            ResourceValue reference2 = ResourceValue.reference(s, true);
            return reference2 != null && (!requireValid || reference2.isValidReference()) ? reference2 : null;
        }
        if (!withPrefix && (reference = ResourceValue.reference(s, false)) != null) {
            return reference;
        }
        return withLiterals ? ResourceValue.literal(s) : null;
    }

    public static ResourceValue literal(String value2) {
        ResourceValue result2 = new ResourceValue();
        result2.myValue = value2;
        return result2;
    }

    @Nullable
    public static ResourceValue reference(String value2) {
        return ResourceValue.reference(value2, true);
    }

    @Nullable
    public static ResourceValue reference(String value2, boolean withPrefix) {
        ResourceValue result2 = new ResourceValue();
        if (withPrefix) {
            assert (!value2.isEmpty());
            result2.myPrefix = value2.charAt(0);
        }
        int startIndex = withPrefix ? 1 : 0;
        int pos = value2.indexOf(47);
        if (pos > 0) {
            String resType = value2.substring(startIndex, pos);
            int colonIndex = resType.indexOf(58);
            if (colonIndex > 0) {
                result2.myPackage = resType.substring(0, colonIndex);
                result2.myResourceType = resType.substring(colonIndex + 1);
            } else {
                result2.myResourceType = resType;
            }
            if (result2.myResourceType.startsWith("+") && !result2.myResourceType.equals(PLUS_ID)) {
                return null;
            }
            String suffix = value2.substring(pos + 1);
            if (ResourceType.SAMPLE_DATA.getName().equals(resType)) {
                result2.myResourceName = value2.substring(pos + 1);
                return result2;
            }
            colonIndex = suffix.indexOf(58);
            if (colonIndex > 0) {
                String aPackage = suffix.substring(0, colonIndex);
                if (result2.myPackage == null || result2.myPackage.isEmpty() || aPackage.equals(result2.myPackage)) {
                    result2.myPackage = aPackage;
                    result2.myResourceName = suffix.substring(colonIndex + 1);
                } else {
                    result2.myResourceName = suffix;
                }
            } else {
                result2.myResourceName = suffix;
            }
        } else {
            int colonIndex = value2.indexOf(58);
            if (colonIndex > startIndex) {
                result2.myPackage = value2.substring(startIndex, colonIndex);
                result2.myResourceName = value2.substring(colonIndex + 1);
            } else {
                result2.myResourceName = value2.substring(startIndex);
            }
        }
        return result2;
    }

    public static ResourceValue referenceTo(char prefix, @Nullable String resPackage, @Nullable String resourceType, String resourceName) {
        ResourceValue result2 = new ResourceValue();
        result2.myPrefix = prefix;
        result2.myPackage = resPackage;
        result2.myResourceType = resourceType;
        result2.myResourceName = resourceName;
        return result2;
    }

    public boolean isReference() {
        return this.myValue == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidReference() {
        ResourceType type;
        if ("null".equals(this.myResourceName)) {
            if (this.myResourceType != null) return false;
            if (this.myPrefix != '@') return false;
            return true;
        }
        if (this.myResourceName == null) return false;
        if (this.myResourceName.isEmpty()) {
            return false;
        }
        if (this.myResourceType == null) {
            if (this.myPrefix != '?') return false;
            type = ResourceType.ATTR;
        } else if (PLUS_ID.equals(this.myResourceType)) {
            type = ResourceType.ID;
        } else {
            type = ResourceType.fromXmlValue((String)this.myResourceType);
            if (type == null) {
                return false;
            }
        }
        if (type == ResourceType.SAMPLE_DATA) {
            return true;
        }
        if (AndroidUtils.isIdentifier(this.myResourceName)) return true;
        if (!FolderTypeRelationship.getRelatedFolders((ResourceType)type).contains(ResourceFolderType.VALUES)) return false;
        if (!AndroidUtils.isIdentifier(RClassNaming.getFieldNameByResourceName((String)this.myResourceName))) return false;
        return true;
    }

    @Nullable
    public String getErrorMessage() {
        ResourceType type;
        if ("null".equals(this.myResourceName) && this.myResourceType == null && this.myPrefix == '@') {
            return null;
        }
        if (this.myResourceName == null || this.myResourceName.isEmpty()) {
            if (this.myResourceType == null && (this.myPrefix == '@' || this.myPrefix == '?')) {
                return "Missing resource type";
            }
            return "Missing resource name";
        }
        if (this.myResourceType == null) {
            if (this.myPrefix != '?') {
                if (this.myPrefix == '@' && this.myResourceName.indexOf(47) == -1) {
                    return "Missing /";
                }
                return "Missing resource type";
            }
            type = ResourceType.ATTR;
        } else if (PLUS_ID.equals(this.myResourceType)) {
            type = ResourceType.ID;
        } else {
            type = ResourceType.fromXmlValue((String)this.myResourceType);
            if (type == null) {
                return "Unknown resource type " + this.myResourceType;
            }
        }
        String name2 = this.myResourceName;
        if (FolderTypeRelationship.getRelatedFolders((ResourceType)type).contains(ResourceFolderType.VALUES)) {
            name2 = RClassNaming.getFieldNameByResourceName((String)name2);
        }
        if (!AndroidUtils.isIdentifier(name2)) {
            if (PsiUtil.isKeyword((String)name2, (LanguageLevel)LanguageLevel.JDK_1_5)) {
                return "Resource name cannot be a Java keyword (" + name2 + ")";
            }
            if (!Character.isJavaIdentifierStart(name2.charAt(0))) {
                return "Resource name must begin with a letter";
            }
            if (ResourceType.SAMPLE_DATA == type) {
                return null;
            }
            int n = name2.length();
            for (int i = 1; i < n; ++i) {
                char c = name2.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                return String.format("'%1$c' is not a valid resource name character", Character.valueOf(c));
            }
            return "Resource name '" + name2 + "' must be a valid Java identifier";
        }
        return null;
    }

    @Nullable
    public String getValue() {
        return this.myValue;
    }

    @Nullable
    public String getResourceType() {
        return this.myResourceType;
    }

    @Nullable
    public ResourceType getType() {
        if (this.myResourceType == null) {
            return null;
        }
        if (this.myResourceType.startsWith("+")) {
            assert (PLUS_ID.equals(this.myResourceType)) : this.myResourceType;
            return ResourceType.ID;
        }
        return ResourceType.fromXmlValue((String)this.myResourceType);
    }

    @Nullable
    public String getResourceName() {
        return this.myResourceName;
    }

    @Nullable
    public String getPackage() {
        return this.myPackage;
    }

    @NotNull
    public String toString() {
        if (this.myValue != null) {
            return this.myValue;
        }
        StringBuilder builder = new StringBuilder();
        if (this.myPrefix != '\u0000') {
            builder.append(this.myPrefix);
        }
        if (this.myPackage != null) {
            builder.append(this.myPackage).append(":");
        }
        if (this.myResourceType != null) {
            builder.append(this.myResourceType).append("/");
        }
        builder.append(this.myResourceName);
        return builder.toString();
    }

    public void setResourceType(@NotNull String resourceType) {
        this.myResourceType = resourceType;
    }
}

