/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.tools.res.LocalResourceRepository;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceNameConverter
extends ResolvingConverter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (this.getErrorMessage(s, context) != null) {
            return null;
        }
        return s;
    }

    public String toString(@Nullable String s, @NotNull ConvertContext context) {
        return s;
    }

    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        ResourceType type = null;
        XmlTag tag = context.getTag();
        if (tag != null) {
            type = ResourceType.fromXmlTagName((String)tag.getName());
        }
        return s == null ? null : ValueResourceNameValidator.getErrorText((String)s, (ResourceType)type);
    }

    @Nullable
    public PsiElement resolve(String s, @NotNull ConvertContext context) {
        ResourceType type;
        XmlTag tag;
        XmlElement element = context.getXmlElement();
        XmlTag xmlTag = tag = element instanceof XmlTag ? (XmlTag)element : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null || s == null) {
            return null;
        }
        ResourceNamespace namespace = IdeResourcesUtil.getResourceNamespace((PsiElement)element);
        if (namespace == null) {
            return null;
        }
        PsiFile file = tag.getContainingFile();
        if (file == null) {
            return null;
        }
        PsiDirectory directory = file.getParent();
        if (directory == null) {
            return null;
        }
        ResourceFolderType resType = ResourceFolderType.getFolderType((String)directory.getName());
        if (ResourceFolderType.VALUES == resType && (type = IdeResourcesUtil.getResourceTypeForResourceTag(tag)) != null) {
            return new ResourceReferencePsiElement((PsiElement)element, new ResourceReference(namespace, type, s), false);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue2, @Nullable String resolveResult, @NotNull ConvertContext context) {
        if (element instanceof ResourceReferencePsiElement) {
            return ((ResourceReferencePsiElement)element).getManager().areElementsEquivalent(element, this.resolve(stringValue2, context));
        }
        return super.isReferenceTo(element, stringValue2, (Object)resolveResult, context);
    }

    @NotNull
    public Collection<String> getVariants(@NotNull ConvertContext context) {
        DomElement element = context.getInvocationElement();
        if (!(element instanceof GenericAttributeValue)) {
            return Collections.emptyList();
        }
        if (element.getParent() instanceof Style) {
            return ResourceNameConverter.getStyleNameVariants(context, (GenericAttributeValue)element);
        }
        return Collections.emptyList();
    }

    private static Collection<String> getStyleNameVariants(ConvertContext context, GenericAttributeValue element) {
        Module module = context.getModule();
        if (module == null) {
            return Collections.emptyList();
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return Collections.emptyList();
        }
        LocalResourceManager manager = LocalResourceManager.getInstance(module);
        if (manager == null) {
            return Collections.emptyList();
        }
        LocalResourceRepository<VirtualFile> appResources = StudioResourceRepositoryManager.getAppResources(facet);
        Set styleNames = appResources.getResources(ResourceNamespace.TODO(), ResourceType.STYLE).keySet();
        ArrayList<String> result2 = new ArrayList<String>();
        String currentValue = element.getStringValue();
        for (String name2 : styleNames) {
            if (currentValue != null && currentValue.startsWith(name2)) continue;
            result2.add(name2 + ".");
        }
        return result2;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value2, PsiElement element, ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        DomElement parent = value2.getParent();
        if (parent instanceof Style) {
            return ResourceNameConverter.getReferencesInStyleName((Style)parent, value2, facet);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getReferencesInStyleName(@NotNull Style style, @NotNull GenericDomValue<String> value2, @NotNull AndroidFacet facet) {
        String s = value2.getStringValue();
        if (s == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String[] ids = s.split("\\.");
        if (ids.length < 2 || style.getParentStyle().getStringValue() != null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<Object> result2 = new ArrayList<Object>(ids.length);
        int offset = s.length();
        for (int i = ids.length - 1; i >= 0; --i) {
            if (i == ids.length - 1) {
                result2.add(new GenericDomValueReference(value2));
            } else {
                String parentStyleName = s.substring(0, offset);
                ResourceValue val = ResourceValue.referenceTo('\u0000', null, ResourceType.STYLE.getName(), parentStyleName);
                result2.add((Object)new MyParentStyleReference((GenericDomValue)value2, new TextRange(1, 1 + offset), val, facet));
                if (ResourceNameConverter.hasExplicitParent(facet, parentStyleName)) break;
            }
            offset = offset - ids[i].length() - 1;
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    public static boolean hasExplicitParent(@NotNull AndroidFacet facet, @NotNull String localStyleName) {
        LocalResourceRepository<VirtualFile> repository2 = StudioResourceRepositoryManager.getAppResources(facet);
        List styles = repository2.getResources(ResourceNamespace.TODO(), ResourceType.STYLE, localStyleName);
        if (styles.isEmpty()) {
            return false;
        }
        for (ResourceItem style : styles) {
            com.android.ide.common.rendering.api.ResourceValue resourceValue = style.getResourceValue();
            if (resourceValue instanceof StyleResourceValue && ((StyleResourceValue)resourceValue).getParentStyleName() != null) continue;
            return false;
        }
        return true;
    }

    public static class MyParentStyleReference
    extends AndroidResourceReferenceBase
    implements LocalQuickFixProvider {
        public MyParentStyleReference(@NotNull GenericDomValue value2, @Nullable TextRange range, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet) {
            super(value2, range, resourceValue, facet);
        }

        public LocalQuickFix[] getQuickFixes() {
            String resourceName = this.getValue();
            if (resourceName.isEmpty()) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            PsiFile psiFile = ((XmlElement)this.getElement()).getContainingFile();
            if (psiFile == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{new CreateValueResourceQuickFix(this.myFacet, ResourceType.STYLE, resourceName, psiFile)};
        }
    }
}

