/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.resources.PublicResource;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/android/dom/resources/PublicResourceNameConverter;", "Lcom/intellij/util/xml/ResolvingConverter$StringConverter;", "<init>", "()V", "resolve", "Lcom/intellij/psi/PsiElement;", "resourceName", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "getVariants", "", "intellij.android.core"})
public final class PublicResourceNameConverter
extends ResolvingConverter.StringConverter {
    @Nullable
    public PsiElement resolve(@Nullable String resourceName, @NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (resourceName == null) {
            return null;
        }
        XmlElement xmlElement = context.getXmlElement();
        if (xmlElement == null) {
            return null;
        }
        XmlElement element = xmlElement;
        ResourceNamespace resourceNamespace = IdeResourcesUtil.getResourceNamespace((PsiElement)element);
        if (resourceNamespace == null) {
            return null;
        }
        ResourceNamespace resourceNamespace2 = resourceNamespace;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), XmlTag.class);
        if (xmlTag == null) {
            return null;
        }
        XmlTag tag = xmlTag;
        XmlAttribute xmlAttribute = tag.getAttribute("type");
        if (xmlAttribute == null) {
            return null;
        }
        XmlAttribute xmlAttribute2 = xmlAttribute;
        String string = xmlAttribute2.getValue();
        if (string == null) {
            return null;
        }
        String attributeValue = string;
        ResourceType resourceType = ResourceType.fromXmlValue((String)attributeValue);
        if (resourceType == null) {
            return null;
        }
        ResourceType resourceType2 = resourceType;
        return (PsiElement)new ResourceReferencePsiElement((PsiElement)element, new ResourceReference(resourceNamespace2, resourceType2, resourceName), false, 4, null);
    }

    @NotNull
    public Collection<String> getVariants(@NotNull ConvertContext context) {
        Collection collection2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DomElement domElement = context.getInvocationElement().getParent();
        PublicResource publicResource = domElement instanceof PublicResource ? (PublicResource)domElement : null;
        if (publicResource == null) {
            return CollectionsKt.emptyList();
        }
        PublicResource element = publicResource;
        Module module = context.getModule();
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            return CollectionsKt.emptyList();
        }
        AndroidFacet facet = androidFacet;
        GenericAttributeValue<ResourceType> genericAttributeValue = element.getType();
        ResourceType elementType = genericAttributeValue != null ? (ResourceType)genericAttributeValue.getValue() : null;
        ResourceRepository resourceRepository = StudioResourceRepositoryManager.getInstance(facet).getModuleResources();
        Intrinsics.checkNotNullExpressionValue((Object)resourceRepository, (String)"<get-moduleResources>(...)");
        ResourceRepository moduleResources2 = resourceRepository;
        if (elementType == null) {
            List list2 = moduleResources2.getAllResources().stream().map(arg_0 -> PublicResourceNameConverter.getVariants$lambda$1(PublicResourceNameConverter::getVariants$lambda$0, arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNull(list2);
            collection2 = list2;
        } else {
            Set<String> set2 = moduleResources2.getResourceNames(ResourceNamespace.RES_AUTO, elementType);
            Intrinsics.checkNotNull(set2);
            collection2 = set2;
        }
        return collection2;
    }

    private static final String getVariants$lambda$0(ResourceItem obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getName();
    }

    private static final String getVariants$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

