/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.converters.CreateMissingClassQuickFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\fH\u0016J\r\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/android/dom/converters/CreateMissingJavaClassQuickFix;", "Lorg/jetbrains/android/dom/converters/CreateMissingClassQuickFix;", "destinationPackage", "Lcom/intellij/psi/PsiPackage;", "className", "", "module", "Lcom/intellij/openapi/module/Module;", "baseClassFqName", "<init>", "(Lcom/intellij/psi/PsiPackage;Ljava/lang/String;Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "getName", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "createClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "directory", "Lcom/intellij/psi/PsiDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
public final class CreateMissingJavaClassQuickFix
extends CreateMissingClassQuickFix {
    public CreateMissingJavaClassQuickFix(@NotNull PsiPackage destinationPackage, @NotNull String className, @NotNull Module module, @Nullable String baseClassFqName) {
        Intrinsics.checkNotNullParameter((Object)destinationPackage, (String)"destinationPackage");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(destinationPackage, className, module, baseClassFqName, null);
    }

    @NotNull
    public String getName() {
        return "Create Java class '" + this.getClassName() + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Create Java class";
    }

    @Override
    @NotNull
    protected VirtualFile createClass(@NotNull PsiDirectory directory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiClass psiClass = JavaDirectoryService.getInstance().createClass(directory, this.getClassName());
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"createClass(...)");
        PsiClass psiClass2 = psiClass;
        if (this.getBaseClassFqName() != null) {
            PsiReferenceList psiReferenceList = psiClass2.getExtendsList();
            if (psiReferenceList != null) {
                PsiReferenceList extendsList = psiReferenceList;
                boolean bl = false;
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiClass parentClass = facade.findClass(this.getBaseClassFqName(), GlobalSearchScope.allScope((Project)project));
                if (parentClass != null) {
                    extendsList.add((PsiElement)facade.getElementFactory().createClassReferenceElement(parentClass));
                }
            }
        }
        PsiModifierList psiModifierList = psiClass2.getModifierList();
        if (psiModifierList != null) {
            psiModifierList.setModifierProperty("public", true);
        }
        VirtualFile virtualFile = psiClass2.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return virtualFile;
    }
}

