/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.sdk.AndroidPlatform;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.android.dom.manifest.UsesPermission;
import org.jetbrains.android.dom.manifest.UsesPermissionSdk23;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AndroidPermissionPurposeConverter
extends ResolvingConverter<String> {
    private static final Logger LOG = Logger.getInstance(AndroidPermissionPurposeConverter.class);
    private static Map<String, Map<String, List<String>>> purposeMapCache = new ConcurrentHashMap<String, Map<String, List<String>>>();

    @NotNull
    public Collection<String> getVariants(@NotNull ConvertContext context) {
        UsesPermissionSdk23 usesPermissionSdk23;
        DomElement invocationElement = context.getInvocationElement();
        String permissionName = null;
        UsesPermission usesPermission = (UsesPermission)invocationElement.getParentOfType(UsesPermission.class, true);
        if (usesPermission != null) {
            permissionName = usesPermission.getName().getStringValue();
        }
        if (permissionName == null && (usesPermissionSdk23 = (UsesPermissionSdk23)invocationElement.getParentOfType(UsesPermissionSdk23.class, true)) != null) {
            permissionName = usesPermissionSdk23.getName().getStringValue();
        }
        if (permissionName == null) {
            return Collections.emptyList();
        }
        Map<String, List<String>> permissionsMap = AndroidPermissionPurposeConverter.getPermissionsMap(context);
        List<String> permissionPurposes = permissionsMap.get(permissionName);
        return permissionPurposes == null ? Collections.emptyList() : permissionPurposes;
    }

    @Nullable
    public String fromString(@Nullable String s, @NotNull ConvertContext context) {
        return s;
    }

    @Nullable
    public String toString(@Nullable String s, @NotNull ConvertContext context) {
        return s;
    }

    @VisibleForTesting
    public static void clearCache() {
        purposeMapCache = new ConcurrentHashMap<String, Map<String, List<String>>>();
    }

    private static Map<String, List<String>> getPermissionsMap(ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            return Collections.emptyMap();
        }
        AndroidPlatform platform = AndroidPlatforms.getInstance(module);
        if (platform == null) {
            return Collections.emptyMap();
        }
        IAndroidTarget target2 = platform.getTarget();
        String sdkHash = target2.hashString();
        try {
            return purposeMapCache.computeIfAbsent(sdkHash, key -> {
                try {
                    return AndroidPermissionPurposeConverter.parsePermissionsFile(target2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            LOG.error("Error reading permissions info from SDK", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static Map<String, List<String>> parsePermissionsFile(IAndroidTarget target2) throws Exception {
        Path platformDataPath = target2.getPath(29);
        File dataFile = new File(platformDataPath.toString());
        if (!dataFile.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> mapBuilder = new HashMap<String, List<String>>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(dataFile);
        doc.getDocumentElement().normalize();
        NodeList permissionNodes = doc.getElementsByTagName("permission");
        for (int i = 0; i < permissionNodes.getLength(); ++i) {
            List<String> validPurposes;
            Element permissionElement = (Element)permissionNodes.item(i);
            String permissionName = permissionElement.getAttribute("name");
            if (permissionName.isEmpty() || (validPurposes = AndroidPermissionPurposeConverter.getValidPurposes(permissionElement.getElementsByTagName("valid-purpose"))).isEmpty()) continue;
            mapBuilder.put(permissionName, validPurposes);
        }
        return mapBuilder;
    }

    private static List<String> getValidPurposes(NodeList purposeNodes) {
        ArrayList<String> purposes = new ArrayList<String>();
        for (int j = 0; j < purposeNodes.getLength(); ++j) {
            Element purposeElement = (Element)purposeNodes.item(j);
            String purposeName = purposeElement.getAttribute("name");
            if (purposeName.isEmpty()) continue;
            purposes.add(purposeName);
        }
        return purposes;
    }
}

