/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateXmlResourceDialog
extends DialogWrapper {
    final CreateXmlResourcePanel myPanel;

    public CreateXmlResourceDialog(@NotNull Module module, @NotNull ResourceType resourceType, @Nullable String predefinedName, @Nullable String predefinedValue, boolean chooseName, @Nullable VirtualFile defaultFile, @Nullable VirtualFile contextFile) {
        super(module.getProject());
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(module.getProject());
        Function<Module, IdeResourceNameValidator> nameValidatorFactory = selectedModule -> IdeResourceNameValidator.forResourceName(resourceType, StudioResourceRepositoryManager.getAppResources(module));
        this.myPanel = newResourceHandler.createNewResourceValuePanel(module, resourceType, ResourceFolderType.VALUES, predefinedName, predefinedValue, chooseName, true, true, defaultFile, contextFile, nameValidatorFactory);
        this.init();
    }

    public CreateXmlResourceDialog(@NotNull Module module, @NotNull ResourceType resourceType, @Nullable String predefinedName, @Nullable String predefinedValue, boolean chooseName, @Nullable VirtualFile defaultFile, @Nullable VirtualFile contextFile, boolean allowValueEditing) {
        this(module, resourceType, predefinedName, predefinedValue, chooseName, defaultFile, contextFile);
        this.myPanel.setAllowValueEditing(allowValueEditing);
    }

    protected ValidationInfo doValidate() {
        return this.myPanel.doValidate();
    }

    protected void doOKAction() {
        String resourceName = this.myPanel.getResourceName();
        String fileName = this.myPanel.getFileName();
        List<String> dirNames = this.myPanel.getDirNames();
        Module module = this.myPanel.getModule();
        JComponent panel2 = this.myPanel.getPanel();
        if (resourceName.isEmpty()) {
            Messages.showErrorDialog((Component)panel2, (String)"Resource name is not specified", (String)CommonBundle.getErrorTitle());
        } else if (!IdeResourcesUtil.isCorrectAndroidResourceName(resourceName)) {
            Messages.showErrorDialog((Component)panel2, (String)(resourceName + " is not correct resource name"), (String)CommonBundle.getErrorTitle());
        } else if (fileName.isEmpty()) {
            Messages.showErrorDialog((Component)panel2, (String)"File name is not specified", (String)CommonBundle.getErrorTitle());
        } else if (dirNames.isEmpty()) {
            Messages.showErrorDialog((Component)panel2, (String)"Directories are not selected", (String)CommonBundle.getErrorTitle());
        } else if (module == null) {
            Messages.showErrorDialog((Component)panel2, (String)"Module is not specified", (String)CommonBundle.getErrorTitle());
        } else {
            super.doOKAction();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateXmlResourceDialog";
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    @Nullable
    public VirtualFile getResourceDirectory() {
        return this.myPanel.getResourceDirectory();
    }

    public String getResourceName() {
        return this.myPanel.getResourceName();
    }

    public String getFileName() {
        return this.myPanel.getFileName();
    }

    public List<String> getDirNames() {
        return this.myPanel.getDirNames();
    }

    public String getValue() {
        return this.myPanel.getValue();
    }

    @Nullable
    public static ValidationInfo checkIfResourceAlreadyExists(@NotNull Project project, @NotNull VirtualFile resourceDir, @NotNull String resourceName, @Nullable String resourceValue, @NotNull ResourceType resourceType, @NotNull List<String> dirNames, @NotNull String fileName) {
        if (resourceName.isEmpty() || dirNames.isEmpty() || fileName.isEmpty()) {
            return null;
        }
        for (String directoryName : dirNames) {
            VirtualFile resFile;
            VirtualFile resourceSubdir = resourceDir.findChild(directoryName);
            if (resourceSubdir == null || (resFile = resourceSubdir.findChild(fileName)) == null) continue;
            if (!FileTypeRegistry.getInstance().isFileOfType(resFile, (FileType)XmlFileType.INSTANCE)) {
                return new ValidationInfo("File " + FileUtil.toSystemDependentName((String)resFile.getPath()) + " is not XML file");
            }
            Resources resources = AndroidUtils.loadDomElement(project, resFile, Resources.class);
            if (resources == null) {
                return new ValidationInfo(AndroidBundle.message("not.resource.file.error", FileUtil.toSystemDependentName((String)resFile.getPath())));
            }
            for (ResourceElement element : IdeResourcesUtil.getValueResourcesFromElement(resourceType, resources)) {
                if (!resourceName.equals(element.getName().getStringValue()) || StringUtil.equals((CharSequence)resourceValue, (CharSequence)element.getStringValue())) continue;
                return new ValidationInfo("resource '" + resourceName + "' already exists in " + FileUtil.toSystemDependentName((String)resFile.getPath()) + "with a different value.");
            }
        }
        return null;
    }
}

