/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.android.actions.widgets.SourceSetCellRenderer;
import org.jetbrains.android.actions.widgets.SourceSetItem;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceDialogUtils {
    private static final Logger LOG = Logger.getInstance(ExternalSystemUtil.class);

    @Nullable
    private static String getResourceUrl(@NotNull JComboBox combo) {
        SourceSetItem comboItem = (SourceSetItem)combo.getSelectedItem();
        if (comboItem != null) {
            return comboItem.getResDirUrl();
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getOrCreateResourceDirectory(@NotNull JComboBox combo, @NotNull Module module) {
        VirtualFile res2;
        PsiDirectory dir;
        String resDirUrl = CreateResourceDialogUtils.getResourceUrl(combo);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        VirtualFile virtualFile = null;
        if (resDirUrl != null && (virtualFile = VirtualFileManager.getInstance().findFileByUrl(resDirUrl)) == null) {
            try {
                virtualFile = VfsUtil.createDirectories((String)VfsUtilCore.urlToPath((String)resDirUrl));
            }
            catch (IOException ex) {
                LOG.warn((Throwable)ex);
            }
        }
        if (virtualFile != null && (dir = manager.findDirectory(virtualFile)) != null) {
            return dir;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet != null && (res2 = ResourceFolderManager.getInstance(facet).getPrimaryFolder()) != null) {
            return PsiManager.getInstance((Project)module.getProject()).findDirectory(res2);
        }
        return null;
    }

    public static void updateSourceSetCombo(@NotNull JComponent label2, @NotNull JComboBox combo, @Nullable AndroidFacet facet, @Nullable PsiDirectory resDirectory) {
        if (resDirectory != null) {
            label2.setVisible(false);
            combo.setVisible(false);
            return;
        }
        if (facet != null && AndroidModel.isRequired(facet) && AndroidModel.get(facet) != null) {
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            ProjectSystemService.getInstance(facet.getModule().getProject()).getProjectSystem().getModuleSystem(facet.getModule()).getModuleTemplates(null).stream().flatMap(namedTemplate -> namedTemplate.getPaths().getResDirectories().stream().map(resDir -> SourceSetItem.create(namedTemplate, resDir)).filter(Objects::nonNull)).forEach(model::addElement);
            combo.setModel(model);
            combo.setRenderer(new SourceSetCellRenderer());
            label2.setVisible(true);
            combo.setVisible(true);
        } else {
            label2.setVisible(false);
            combo.setVisible(false);
        }
    }

    @Nullable
    private static VirtualFile getResFolderParent(@NotNull LocalResourceManager manager, @NotNull VirtualFile file) {
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!current.isDirectory() || !manager.isResourceDir(current)) continue;
            return current;
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findResourceDirectory(@NotNull DataContext dataContext) {
        VirtualFile resFolder;
        LocalResourceManager manager;
        Module module;
        AbstractProjectViewPane pane;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && (pane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane()).getId().equals("AndroidView")) {
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file != null && (module = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext)) != null && (manager = LocalResourceManager.getInstance(module)) != null && (resFolder = CreateResourceDialogUtils.getResFolderParent(manager, file)) != null) {
            return AndroidPsiUtils.getPsiDirectorySafely((Project)module.getProject(), (VirtualFile)resFolder);
        }
        return null;
    }
}

