/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.Client;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.execution.common.debug.utils.AndroidConnectDebugger;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.annotations.NotNull;

public class AndroidConnectDebuggerAction
extends AnAction {
    private final boolean isAndroidStudio = IdeInfo.getInstance().isAndroidStudio();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        AndroidProcessChooserDialog dialog2 = new AndroidProcessChooserDialog(project, true);
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            Client client = dialog2.getClient();
            if (client == null) {
                return;
            }
            AppExecutorUtil.getAppExecutorService().execute(() -> AndroidConnectDebugger.closeOldSessionAndRun(project, dialog2.getSelectedAndroidDebugger(), client, dialog2.getRunConfiguration()));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean isVisible = this.isAndroidStudio || project != null && CommonAndroidUtil.getInstance().isAndroidProject(project);
        e.getPresentation().setVisible(isVisible);
    }
}

