/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidResourceExternalAnnotatorBase
extends ExternalAnnotator<FileAnnotationInfo, Map<PsiElement, GutterIconRenderer>> {
    private static final Logger LOG = Logger.getInstance(AndroidResourceExternalAnnotatorBase.class);
    private final LineMarkerProvider lineMarkerProvider = new LineMarkerProvider();

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (!LineMarkerSettings.getSettings().isEnabled((GutterIconDescriptor)this.lineMarkerProvider)) {
            return null;
        }
        return this.collectInformation(file, editor);
    }

    @Nullable
    protected abstract FileAnnotationInfo collectInformation(@NotNull PsiFile var1, @NotNull Editor var2);

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file) {
        return null;
    }

    @Nullable
    public Map<PsiElement, GutterIconRenderer> doAnnotate(@NotNull FileAnnotationInfo fileAnnotationsInfo) {
        AndroidFacet facet = fileAnnotationsInfo.getFacet();
        Editor editor = fileAnnotationsInfo.getEditor();
        long timestamp = fileAnnotationsInfo.getTimestamp();
        Document document = editor.getDocument();
        HashMap<PsiElement, GutterIconRenderer> rendererMap = new HashMap<PsiElement, GutterIconRenderer>();
        Configuration configuration2 = AndroidAnnotatorUtil.pickConfiguration(fileAnnotationsInfo.getFile(), facet);
        if (configuration2 == null) {
            return null;
        }
        ResourceResolver resolver = configuration2.getResourceResolver();
        for (FileAnnotationInfo.AnnotatableElement element : fileAnnotationsInfo.getElements()) {
            GutterIconRenderer gutterIconRenderer;
            ProgressManager.checkCanceled();
            if (editor.isDisposed() || document.getModificationStamp() > timestamp) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Rendering icon for %s in %s.", element.getResource(), fileAnnotationsInfo.getFile()));
            }
            if (element.getResource() != null) {
                gutterIconRenderer = AndroidResourceExternalAnnotatorBase.getResourceGutterIconRenderer(element.getResource(), element.getPsiElement(), resolver, facet, configuration2);
            } else {
                assert (element.getColor() != null);
                Color color = element.getColor();
                gutterIconRenderer = (GutterIconRenderer)ReadAction.nonBlocking(() -> AndroidResourceExternalAnnotatorBase.buildInlineColorRenderer(element, color, resolver, facet)).executeSynchronously();
            }
            if (gutterIconRenderer == null) continue;
            rendererMap.put(element.getPsiElement(), gutterIconRenderer);
        }
        return rendererMap;
    }

    @NotNull
    private static AndroidAnnotatorUtil.ColorRenderer buildInlineColorRenderer(FileAnnotationInfo.AnnotatableElement element, Color color, ResourceResolver resolver, AndroidFacet facet) {
        return new AndroidAnnotatorUtil.ColorRenderer(element.getPsiElement(), color, resolver, null, true, facet);
    }

    @Slow
    @Nullable
    private static GutterIconRenderer getResourceGutterIconRenderer(@NotNull ResourceReference reference, @NotNull PsiElement element, @NotNull ResourceResolver resolver, @NotNull AndroidFacet facet, @NotNull Configuration configuration2) {
        ResourceValue renderableValue;
        ResourceValue resolvedResource = null;
        if (reference.getResourceType() == ResourceType.ATTR) {
            ResourceValue resolvedAttribute = resolver.findItemInTheme(reference);
            if (resolvedAttribute == null || resolvedAttribute.getValue() == null) {
                return null;
            }
            ResourceValue resourceValue = resolver.resolveResValue(resolvedAttribute);
            if (resourceValue == null) {
                return null;
            }
            ResourceType resourceValueType = resourceValue.getResourceType();
            if (resourceValueType == ResourceType.DRAWABLE || resourceValueType == ResourceType.MIPMAP || resourceValueType == ResourceType.COLOR || resourceValueType == ResourceType.STYLE_ITEM || resourceValueType == ResourceType.MACRO) {
                resolvedResource = resourceValue;
            } else {
                return null;
            }
        }
        ResourceValue resourceValue = renderableValue = resolvedResource == null ? resolver.getResolvedResource(reference) : resolvedResource;
        if (renderableValue == null) {
            return null;
        }
        ResourceType renderableValueResourceType = renderableValue.getResourceType();
        if (renderableValueResourceType == ResourceType.COLOR || renderableValueResourceType == ResourceType.STYLE_ITEM || renderableValueResourceType == ResourceType.MACRO) {
            return (GutterIconRenderer)ReadAction.nonBlocking(() -> AndroidResourceExternalAnnotatorBase.getColorGutterIconRenderer(resolver, renderableValue, facet, element)).executeSynchronously();
        }
        if (renderableValueResourceType == ResourceType.DRAWABLE || renderableValueResourceType == ResourceType.MIPMAP) {
            return AndroidResourceExternalAnnotatorBase.getDrawableGutterIconRenderer(element, resolver, renderableValue, facet, configuration2);
        }
        return null;
    }

    @NotNull
    private static GutterIconRenderer getDrawableGutterIconRenderer(@NotNull PsiElement element, @NotNull ResourceResolver resourceResolver, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet, @NotNull Configuration configuration2) {
        VirtualFile resourceFile = AndroidAnnotatorUtil.resolveDrawableFile(resourceValue, resourceResolver, facet);
        if (resourceFile != null) {
            GutterIconCache.getInstance(facet.getModule().getProject()).getIcon(resourceFile, (RenderResources)resourceResolver, facet);
        }
        return new com.android.tools.idea.rendering.GutterIconRenderer(element, resourceResolver, facet, resourceFile, configuration2);
    }

    @Nullable
    private static GutterIconRenderer getColorGutterIconRenderer(@NotNull ResourceResolver resourceResolver, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet, @NotNull PsiElement element) {
        Color color = IdeResourcesUtil.resolveColor((RenderResources)resourceResolver, resourceValue, facet.getModule().getProject());
        if (color == null) {
            return null;
        }
        boolean withCustomColorPalette = AndroidAnnotatorUtil.getFileType(element) == XmlFileType.INSTANCE;
        return new AndroidAnnotatorUtil.ColorRenderer(element, color, resourceResolver, resourceValue, withCustomColorPalette, facet);
    }

    public void apply(@NotNull PsiFile file, @NotNull Map<PsiElement, GutterIconRenderer> iconRendererMap, @NotNull AnnotationHolder holder) {
        iconRendererMap.forEach((k, v) -> {
            if (k.isValid()) {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(k).gutterIconRenderer(v).create();
            }
        });
    }

    public static class LineMarkerProvider
    extends LineMarkerProviderDescriptor {
        public String getName() {
            return "Resource preview";
        }

        public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
            return null;
        }
    }

    protected static class FileAnnotationInfo {
        @NotNull
        private final AndroidFacet myFacet;
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final Editor myEditor;
        private final long myTimestamp;
        @NotNull
        private final List<AnnotatableElement> myElements;

        public FileAnnotationInfo(@NotNull AndroidFacet facet, @NotNull PsiFile file, @NotNull Editor editor) {
            this.myFacet = facet;
            this.myFile = file;
            this.myEditor = editor;
            this.myTimestamp = this.myEditor.getDocument().getModificationStamp();
            this.myElements = new ArrayList<AnnotatableElement>();
        }

        @NotNull
        public AndroidFacet getFacet() {
            return this.myFacet;
        }

        @NotNull
        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public List<AnnotatableElement> getElements() {
            return this.myElements;
        }

        @NotNull
        public Editor getEditor() {
            return this.myEditor;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        public static class AnnotatableElement {
            @Nullable
            private final ResourceReference myReference;
            @NotNull
            private final PsiElement myPsiElement;
            @Nullable
            private final Color myColor;

            public AnnotatableElement(@NotNull ResourceReference reference, @NotNull PsiElement element) {
                this.myReference = reference;
                this.myPsiElement = element;
                this.myColor = null;
            }

            AnnotatableElement(@NotNull Color color, @NotNull PsiElement element) {
                this.myReference = null;
                this.myPsiElement = element;
                this.myColor = color;
            }

            @Nullable
            public ResourceReference getResource() {
                return this.myReference;
            }

            @NotNull
            public PsiElement getPsiElement() {
                return this.myPsiElement;
            }

            @Nullable
            public Color getColor() {
                return this.myColor;
            }
        }
    }
}

