/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfo;
import com.google.gct.login2.GoogleAccountClient;
import com.google.gct.login2.GoogleAccountClientKt;
import com.google.gct.login2.GoogleLoginUtils;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Image;
import java.io.IOException;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/google/gct/login2/GoogleAccountClientImpl;", "Lcom/google/gct/login2/GoogleAccountClient;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getUserPicture", "Ljava/awt/Image;", "userInfo", "Lcom/google/api/services/oauth2/model/Userinfo;", "getUserInfo", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "google-login"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nGoogleAccountClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleAccountClient.kt\ncom/google/gct/login2/GoogleAccountClientImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class GoogleAccountClientImpl
implements GoogleAccountClient {
    public static final int $stable;

    private final Logger getLOG() {
        Logger logger = Logger.getInstance(GoogleLoginUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @Override
    @Nullable
    public Image getUserPicture(@NotNull Userinfo userInfo) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        try {
            image = ImageIO.read(GoogleLoginUtils.appendSizeParameter(userInfo.getPicture()));
        }
        catch (Exception e) {
            this.getLOG().warn("Failed to fetch user picture", (Throwable)e);
            image = null;
        }
        return image;
    }

    @Override
    @Nullable
    public Userinfo getUserInfo(@NotNull Credential credential) {
        Oauth2.Builder builder;
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Oauth2.Builder $this$getUserInfo_u24lambda_u240 = builder = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Android Studio");
        boolean bl = false;
        String string = GoogleAccountClientKt.access$getTestServerRootUrl$p();
        if (string == null) {
            string = $this$getUserInfo_u24lambda_u240.getRootUrl();
        }
        $this$getUserInfo_u24lambda_u240.setRootUrl(string);
        Oauth2 userInfoService = builder.build();
        try {
            builder = (Userinfo)userInfoService.userinfo().get().execute();
        }
        catch (IOException e) {
            this.getLOG().warn("Error retrieving user information.", (Throwable)e);
            builder = null;
        }
        return builder;
    }
}

