/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.Credential;
import com.google.auth.oauth2.DefaultPKCEProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.gct.login2.CancellableRedirectServer;
import com.google.gct.login2.GoogleLoginUtils;
import com.google.gct.login2.RequestCancelledException;
import com.google.gct.login2.common.AuthorizationCodeHolder;
import com.google.gct.login2.common.LoginCallbackHandler;
import com.google.gct.login2.common.UiFacade;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageDialogBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016JD\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013H\u0016JX\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013H\u0007J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0017J\u0014\u0010\u001b\u001a\u00020\t2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/google/gct/login2/AndroidUiFacade;", "Lcom/google/gct/login2/common/UiFacade;", "clientId", "", "<init>", "(Ljava/lang/String;)V", "server", "Lcom/google/gct/login2/CancellableRedirectServer;", "stop", "", "interactWithBrowser", "", "scopes", "", "preferredUser", "featureHandlers", "", "Lcom/google/gct/login2/common/LoginCallbackHandler;", "authorizationCodeCallback", "Lkotlin/Function1;", "Lcom/google/gct/login2/common/AuthorizationCodeHolder;", "Lcom/google/api/client/auth/oauth2/Credential;", "authSuccessLandingPage", "authFailureLandingPage", "askYesOrNo", "title", "message", "logErrorAndDisplayDialog", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "AuthorizationCodeLoginCallbackHandler", "google-login"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAndroidUiFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidUiFacade.kt\ncom/google/gct/login2/AndroidUiFacade\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n24#2:140\n1#3:141\n*S KotlinDebug\n*F\n+ 1 AndroidUiFacade.kt\ncom/google/gct/login2/AndroidUiFacade\n*L\n100#1:140\n*E\n"})
public final class AndroidUiFacade
implements UiFacade {
    @NotNull
    private final String clientId;
    @Nullable
    private volatile CancellableRedirectServer server;
    public static final int $stable = 8;

    public AndroidUiFacade(@NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.clientId = clientId;
    }

    @Override
    public void stop() {
        try {
            CancellableRedirectServer cancellableRedirectServer = this.server;
            if (cancellableRedirectServer != null) {
                cancellableRedirectServer.stop();
            }
        }
        catch (IOException e) {
            this.logErrorAndDisplayDialog(e);
        }
    }

    @Override
    public boolean interactWithBrowser(@NotNull Collection<String> scopes, @Nullable String preferredUser, @NotNull List<? extends LoginCallbackHandler> featureHandlers, @NotNull Function1<? super AuthorizationCodeHolder, ? extends Credential> authorizationCodeCallback) {
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter(featureHandlers, (String)"featureHandlers");
        Intrinsics.checkNotNullParameter(authorizationCodeCallback, (String)"authorizationCodeCallback");
        return this.interactWithBrowser(scopes, preferredUser, featureHandlers, "https://developer.android.com/studio/login.html?utm_source=android-studio-app&utm_medium=app&success=true", "https://developer.android.com/studio/login.html?utm_source=android-studio-app&utm_medium=app&success=false", authorizationCodeCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final boolean interactWithBrowser(@NotNull Collection<String> scopes, @Nullable String preferredUser, @NotNull List<? extends LoginCallbackHandler> featureHandlers, @Nullable String authSuccessLandingPage, @Nullable String authFailureLandingPage, @NotNull Function1<? super AuthorizationCodeHolder, ? extends Credential> authorizationCodeCallback) {
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter(featureHandlers, (String)"featureHandlers");
        Intrinsics.checkNotNullParameter(authorizationCodeCallback, (String)"authorizationCodeCallback");
        AuthorizationCodeLoginCallbackHandler handler2 = new AuthorizationCodeLoginCallbackHandler(this.clientId, scopes, preferredUser, (Function1<? super AuthorizationCodeHolder, ? extends Credential>)((Function1)arg_0 -> AndroidUiFacade.interactWithBrowser$lambda$0(authorizationCodeCallback, this, arg_0)));
        List handlers = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)handler2), (Iterable)featureHandlers);
        this.server = new CancellableRedirectServer(-1, handlers, authSuccessLandingPage, authFailureLandingPage);
        try {
            CancellableRedirectServer cancellableRedirectServer = this.server;
            if (cancellableRedirectServer != null) {
                cancellableRedirectServer.start();
            }
            CancellableRedirectServer cancellableRedirectServer2 = this.server;
            if (cancellableRedirectServer2 != null) {
                cancellableRedirectServer2.await();
            }
        }
        catch (RequestCancelledException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.logErrorAndDisplayDialog(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.server = null;
        }
        return true;
    }

    @Override
    @UiThread
    public boolean askYesOrNo(@NotNull String title2, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return MessageDialogBuilder.Companion.yesNo(title2, message).guessWindowAndAsk();
    }

    private final void logErrorAndDisplayDialog(Exception exception) {
        AndroidUiFacade $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AndroidUiFacade.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn(exception.getMessage(), (Throwable)exception);
        String string = exception.getMessage();
        if (string == null) {
            string = "Unknown error";
        }
        GoogleLoginUtils.showErrorDialog(string, "Google Login");
    }

    private static final Credential interactWithBrowser$lambda$0(Function1 $authorizationCodeCallback, AndroidUiFacade this$0, AuthorizationCodeHolder it) {
        Object object;
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            object = $authorizationCodeCallback.invoke((Object)it);
            Credential credential = (Credential)object;
            boolean bl = false;
            CancellableRedirectServer cancellableRedirectServer = this$0.server;
            if (cancellableRedirectServer == null) break block0;
            cancellableRedirectServer.setCredential(credential);
        }
        return (Credential)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ*\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/google/gct/login2/AndroidUiFacade$AuthorizationCodeLoginCallbackHandler;", "Lcom/google/gct/login2/common/LoginCallbackHandler;", "clientId", "", "scopes", "", "preferredUser", "authorizationCodeCallback", "Lkotlin/Function1;", "Lcom/google/gct/login2/common/AuthorizationCodeHolder;", "Lcom/google/api/client/auth/oauth2/Credential;", "<init>", "(Ljava/lang/String;Ljava/util/Collection;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "callbackPath", "pkce", "Lcom/google/auth/oauth2/DefaultPKCEProvider;", "redirectUri", "getUrl", "host", "port", "", "authUser", "credential", "canHandle", "", "handle", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "google-login"})
    private static final class AuthorizationCodeLoginCallbackHandler
    implements LoginCallbackHandler {
        @NotNull
        private final String clientId;
        @NotNull
        private final Collection<String> scopes;
        @Nullable
        private final String preferredUser;
        @NotNull
        private final Function1<AuthorizationCodeHolder, Credential> authorizationCodeCallback;
        @NotNull
        private final String callbackPath;
        @NotNull
        private final DefaultPKCEProvider pkce;
        @NotNull
        private String redirectUri;

        public AuthorizationCodeLoginCallbackHandler(@NotNull String clientId, @NotNull Collection<String> scopes, @Nullable String preferredUser, @NotNull Function1<? super AuthorizationCodeHolder, ? extends Credential> authorizationCodeCallback) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
            Intrinsics.checkNotNullParameter(authorizationCodeCallback, (String)"authorizationCodeCallback");
            this.clientId = clientId;
            this.scopes = scopes;
            this.preferredUser = preferredUser;
            this.authorizationCodeCallback = authorizationCodeCallback;
            this.callbackPath = "/CALLBACK_AUTH";
            this.pkce = new DefaultPKCEProvider();
            this.redirectUri = "";
        }

        @Override
        @NotNull
        public String getUrl(@NotNull String host, int port, int authUser, @Nullable Credential credential) {
            AuthorizationCodeRequestUrl authorizationCodeRequestUrl;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.redirectUri = "http://" + host + ":" + port + this.callbackPath;
            AuthorizationCodeRequestUrl $this$getUrl_u24lambda_u240 = authorizationCodeRequestUrl = new AuthorizationCodeRequestUrl("https://accounts.google.com/o/oauth2/auth", this.clientId).setRedirectUri(this.redirectUri).setScopes(this.scopes).set("login_hint", (Object)this.preferredUser);
            boolean bl = false;
            $this$getUrl_u24lambda_u240.setCodeChallenge(this.pkce.getCodeChallenge());
            $this$getUrl_u24lambda_u240.setCodeChallengeMethod(this.pkce.getCodeChallengeMethod());
            String string = authorizationCodeRequestUrl.build();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"build(...)");
            return string;
        }

        @Override
        public boolean canHandle(@NotNull String callbackPath) {
            Intrinsics.checkNotNullParameter((Object)callbackPath, (String)"callbackPath");
            return Intrinsics.areEqual((Object)this.callbackPath, (Object)callbackPath);
        }

        @Override
        public boolean handle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            String string = request.getParameter("code");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParameter(...)");
            String string2 = this.pkce.getCodeVerifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCodeVerifier(...)");
            AuthorizationCodeHolder authorizationCodeHolder = new AuthorizationCodeHolder(string, this.redirectUri, string2);
            this.authorizationCodeCallback.invoke((Object)authorizationCodeHolder);
            return true;
        }
    }
}

