/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.dom.attrs.AttributeDefinitionsImpl;
import com.android.tools.dom.attrs.FilteredAttributeDefinitions;
import com.android.tools.environment.Logger;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLibraryLoader;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.res.FrameworkOverlay;
import com.android.tools.res.FrameworkResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidSdkData;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.tools.sdk.EmbeddedRenderTarget;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AndroidTargetData {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.android.sdk.AndroidTargetData");
    private final AndroidSdkData mySdkData;
    private final IAndroidTarget myTarget;
    private final Object myAttrDefsLock = new Object();
    private AttributeDefinitions myAttrDefs;
    private LayoutLibrary myLayoutLibrary;
    private volatile MyStaticConstantsData myStaticConstantsData;
    private static final Map<AndroidSdkData, Map<String, SoftReference<AndroidTargetData>>> myTargetDataCache = new WeakHashMap<AndroidSdkData, Map<String, SoftReference<AndroidTargetData>>>();

    @VisibleForTesting
    public AndroidTargetData(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target2) {
        this.mySdkData = sdkData;
        this.myTarget = target2;
    }

    @NotNull
    public AttributeDefinitions getPublicAttrDefs() {
        AttributeDefinitions attrDefs = this.getAllAttrDefs();
        return new PublicAttributeDefinitions(attrDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AttributeDefinitions getAllAttrDefs() {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            if (this.myAttrDefs == null) {
                String attrsPath = this.myTarget.getPath(8).toString().replace('\\', '/');
                String attrsManifestPath = this.myTarget.getPath(9).toString().replace('\\', '/');
                this.myAttrDefs = AttributeDefinitionsImpl.parseFrameworkFiles(new File(attrsPath), new File(attrsManifestPath));
            }
            return this.myAttrDefs;
        }
    }

    public boolean isResourcePublic(@NotNull ResourceType type, @NotNull String name2) {
        ResourceRepository frameworkResources = this.getFrameworkResources(Collections.emptySet(), Collections.emptyList());
        if (frameworkResources == null) {
            return false;
        }
        List resources = frameworkResources.getResources(ResourceNamespace.ANDROID, type, name2);
        return !resources.isEmpty() && ((ResourceItemWithVisibility)resources.get(0)).getVisibility() == ResourceVisibility.PUBLIC;
    }

    @Slow
    @NotNull
    LayoutLibrary getLayoutLibrary(@NotNull Consumer<LayoutLibrary> register2, @NotNull Supplier<Boolean> hasLayoutlibCrash) throws RenderingException {
        if (this.myLayoutLibrary == null || this.myLayoutLibrary.isDisposed()) {
            IAndroidTarget target2;
            AndroidTargetData targetData;
            if (this.myTarget instanceof CompatibilityRenderTarget && (targetData = AndroidTargetData.get(this.mySdkData, target2 = ((CompatibilityRenderTarget)this.myTarget).getRenderTarget())) != this) {
                this.myLayoutLibrary = targetData.getLayoutLibrary(register2, hasLayoutlibCrash);
                return this.myLayoutLibrary;
            }
            if (!(this.myTarget instanceof EmbeddedRenderTarget)) {
                LOG.warn("Rendering will not use the EmbeddedRenderTarget");
            }
            this.myLayoutLibrary = LayoutLibraryLoader.load((IAndroidTarget)this.myTarget, this.getFrameworkEnumValues(), hasLayoutlibCrash);
            register2.accept(this.myLayoutLibrary);
        }
        return this.myLayoutLibrary;
    }

    @Slow
    @NotNull
    private Map<String, Map<String, Integer>> getFrameworkEnumValues() {
        ResourceRepository resources = this.getFrameworkResources((Set<String>)ImmutableSet.of(), (List<? extends FrameworkOverlay>)ImmutableList.of());
        if (resources == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Integer>> result2 = new HashMap<String, Map<String, Integer>>();
        Collection items = resources.getResources(ResourceNamespace.ANDROID, ResourceType.ATTR).values();
        for (ResourceItem item : items) {
            Map valueMap;
            ResourceValue attr = item.getResourceValue();
            if (!(attr instanceof AttrResourceValue) || (valueMap = ((AttrResourceValue)attr).getAttributeValues()).isEmpty()) continue;
            result2.put(attr.getName(), valueMap);
        }
        items = resources.getResources(ResourceNamespace.ANDROID, ResourceType.STYLEABLE).values();
        for (ResourceItem item : items) {
            ResourceValue styleable = item.getResourceValue();
            if (!(styleable instanceof StyleableResourceValue)) continue;
            List attrs = ((StyleableResourceValue)styleable).getAllAttributes();
            for (AttrResourceValue attr : attrs) {
                Map valueMap = attr.getAttributeValues();
                if (valueMap.isEmpty()) continue;
                result2.put(attr.getName(), valueMap);
            }
        }
        return result2;
    }

    public void clearLayoutBitmapCache(Object moduleKey) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearResourceCaches(moduleKey);
        }
    }

    public void clearFontCache(String path) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearFontCache(path);
        }
    }

    public void clearAllCaches(Object moduleKey) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearAllCaches(moduleKey);
        }
    }

    @NotNull
    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    @NotNull
    public synchronized MyStaticConstantsData getStaticConstantsData() {
        if (this.myStaticConstantsData == null) {
            this.myStaticConstantsData = new MyStaticConstantsData();
        }
        return this.myStaticConstantsData;
    }

    @Slow
    @Nullable
    public synchronized ResourceRepository getFrameworkResources(@NotNull Set<String> languages, @NotNull List<? extends FrameworkOverlay> overlays) {
        return FrameworkResourceRepositoryManager.getInstance().getFrameworkResources(this.myTarget.getPath(11), this.myTarget instanceof CompatibilityRenderTarget, languages, overlays);
    }

    @Nullable
    public static AndroidTargetData getTargetData(@NotNull IAndroidTarget target2, @Nullable AndroidPlatform platform) {
        return platform != null ? AndroidTargetData.get(platform.getSdkData(), target2) : null;
    }

    public static AndroidTargetData get(@NotNull AndroidSdkData sdk, @NotNull IAndroidTarget target2) {
        AndroidTargetData targetData;
        String key;
        Map targetDataByTarget = myTargetDataCache.computeIfAbsent(sdk, s -> Maps.newHashMap());
        SoftReference targetDataRef = (SoftReference)targetDataByTarget.get(key = target2.hashString());
        AndroidTargetData androidTargetData = targetData = targetDataRef != null ? (AndroidTargetData)targetDataRef.get() : null;
        if (targetData == null) {
            targetData = new AndroidTargetData(sdk, target2);
            targetDataByTarget.put(key, new SoftReference<AndroidTargetData>(targetData));
        }
        return targetData;
    }

    @TestOnly
    public static void clearCache() {
        myTargetDataCache.clear();
    }

    private class PublicAttributeDefinitions
    extends FilteredAttributeDefinitions {
        protected PublicAttributeDefinitions(AttributeDefinitions wrappee) {
            super(wrappee);
        }

        @Override
        protected boolean isAttributeAcceptable(@NotNull ResourceReference attr) {
            return attr.getNamespace().equals((Object)ResourceNamespace.ANDROID) && !attr.getName().startsWith("__removed") && AndroidTargetData.this.isResourcePublic(ResourceType.ATTR, attr.getName());
        }
    }

    public class MyStaticConstantsData {
        private final Set<String> myActivityActions = this.collectValues(14);
        private final Set<String> myServiceActions = this.collectValues(16);
        private final Set<String> myReceiverActions = this.collectValues(15);
        private final Set<String> myCategories = this.collectValues(17);

        private MyStaticConstantsData() {
        }

        @Nullable
        public Set<String> getActivityActions() {
            return this.myActivityActions;
        }

        @Nullable
        public Set<String> getServiceActions() {
            return this.myServiceActions;
        }

        @Nullable
        public Set<String> getReceiverActions() {
            return this.myReceiverActions;
        }

        @Nullable
        public Set<String> getCategories() {
            return this.myCategories;
        }

        @Nullable
        private Set<String> collectValues(int pathId) {
            HashSet<String> hashSet;
            block9: {
                BufferedReader reader2 = Files.newBufferedReader(AndroidTargetData.this.myTarget.getPath(pathId));
                try {
                    String line;
                    HashSet<String> result2 = new HashSet<String>();
                    while ((line = reader2.readLine()) != null) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        result2.add(line);
                    }
                    hashSet = result2;
                    if (reader2 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader2 != null) {
                            try {
                                reader2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                reader2.close();
            }
            return hashSet;
        }
    }
}

