/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.tracking;

import com.android.tools.rendering.tracking.AllocationStackTrace;
import com.android.tools.rendering.tracking.DisposeStackTrace;
import com.android.tools.rendering.tracking.RenderTaskAllocationTracker;
import com.android.tools.rendering.tracking.RenderTaskAllocationTrackerImplKt;
import com.android.tools.rendering.tracking.StackTraceCapture;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/rendering/tracking/RenderTaskAllocationTrackerImpl;", "Lcom/android/tools/rendering/tracking/RenderTaskAllocationTracker;", "shouldTrackAllocations", "", "<init>", "(Z)V", "captureDisposeStackTrace", "Lcom/android/tools/rendering/tracking/StackTraceCapture;", "captureAllocationStackTrace", "intellij.android.rendering"})
public final class RenderTaskAllocationTrackerImpl
implements RenderTaskAllocationTracker {
    private final boolean shouldTrackAllocations;

    public RenderTaskAllocationTrackerImpl(boolean shouldTrackAllocations) {
        this.shouldTrackAllocations = shouldTrackAllocations;
    }

    @Override
    @NotNull
    public StackTraceCapture captureDisposeStackTrace() {
        StackTraceCapture stackTraceCapture;
        if (this.shouldTrackAllocations) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            stackTraceCapture = new DisposeStackTrace(CollectionsKt.drop((Iterable)ArraysKt.asList((Object[])stackTraceElementArray), (int)2));
        } else {
            stackTraceCapture = RenderTaskAllocationTrackerImplKt.access$getNULL_STACK_TRACE$p();
        }
        return stackTraceCapture;
    }

    @Override
    @NotNull
    public StackTraceCapture captureAllocationStackTrace() {
        StackTraceCapture stackTraceCapture;
        if (this.shouldTrackAllocations) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            stackTraceCapture = new AllocationStackTrace(CollectionsKt.drop((Iterable)ArraysKt.asList((Object[])stackTraceElementArray), (int)2));
        } else {
            stackTraceCapture = RenderTaskAllocationTrackerImplKt.access$getNULL_STACK_TRACE$p();
        }
        return stackTraceCapture;
    }
}

