/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.configurations.Configuration;
import com.android.tools.module.AndroidModuleInfo;
import com.android.tools.rendering.api.RenderModelModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/rendering/RenderContext;", "", "module", "Lcom/android/tools/rendering/api/RenderModelModule;", "configuration", "Lcom/android/tools/configurations/Configuration;", "<init>", "(Lcom/android/tools/rendering/api/RenderModelModule;Lcom/android/tools/configurations/Configuration;)V", "getModule", "()Lcom/android/tools/rendering/api/RenderModelModule;", "getConfiguration", "()Lcom/android/tools/configurations/Configuration;", "minSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "getMinSdkVersion", "()Lcom/android/sdklib/AndroidVersion;", "targetSdkVersion", "getTargetSdkVersion", "folderType", "Lcom/android/resources/ResourceFolderType;", "getFolderType", "()Lcom/android/resources/ResourceFolderType;", "setFolderType", "(Lcom/android/resources/ResourceFolderType;)V", "intellij.android.rendering"})
public final class RenderContext {
    @NotNull
    private final RenderModelModule module;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final AndroidVersion minSdkVersion;
    @NotNull
    private final AndroidVersion targetSdkVersion;
    @Nullable
    private ResourceFolderType folderType;

    public RenderContext(@NotNull RenderModelModule module, @NotNull Configuration configuration2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.module = module;
        this.configuration = configuration2;
        AndroidModuleInfo androidModuleInfo = this.module.getInfo();
        if (androidModuleInfo == null || (androidModuleInfo = androidModuleInfo.getMinSdkVersion()) == null) {
            AndroidVersion androidVersion = AndroidVersion.DEFAULT;
            androidModuleInfo = androidVersion;
            Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"DEFAULT");
        }
        this.minSdkVersion = androidModuleInfo;
        AndroidModuleInfo androidModuleInfo2 = this.module.getInfo();
        if (androidModuleInfo2 == null || (androidModuleInfo2 = androidModuleInfo2.getTargetSdkVersion()) == null) {
            AndroidVersion androidVersion = AndroidVersion.DEFAULT;
            androidModuleInfo2 = androidVersion;
            Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"DEFAULT");
        }
        this.targetSdkVersion = androidModuleInfo2;
    }

    @NotNull
    public final RenderModelModule getModule() {
        return this.module;
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final AndroidVersion getMinSdkVersion() {
        return this.minSdkVersion;
    }

    @NotNull
    public final AndroidVersion getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    @Nullable
    public final ResourceFolderType getFolderType() {
        return this.folderType;
    }

    public final void setFolderType(@Nullable ResourceFolderType resourceFolderType) {
        this.folderType = resourceFolderType;
    }
}

