/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertyEditorModel;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.panel.api.TableUIProvider;
import com.android.tools.property.panel.impl.model.CollapsibleLabelModel;
import com.android.tools.property.panel.impl.model.GenericInspectorLineModel;
import com.android.tools.property.panel.impl.model.InspectorPanelModel;
import com.android.tools.property.panel.impl.model.SeparatorLineModel;
import com.android.tools.property.panel.impl.model.TableLineModelImpl;
import com.android.tools.property.panel.impl.model.TitleLineModel;
import com.android.tools.property.panel.impl.ui.CollapsibleLabelPanel;
import com.android.tools.property.panel.impl.ui.GenericLinePanel;
import com.android.tools.property.panel.impl.ui.InspectorPanelImpl;
import com.android.tools.property.panel.impl.ui.TableEditor;
import com.android.tools.property.ptable.ColumnFraction;
import com.android.tools.property.ptable.PTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010.\u001a\u00020,J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000200J\u0006\u00102\u001a\u000200J\u0006\u00103\u001a\u000200J\b\u00104\u001a\u000200H\u0002J\b\u00105\u001a\u000200H\u0002J\u0019\u00106\u001a\u0004\u0018\u00010\u001e2\b\u00107\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020%2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0016J\"\u0010?\u001a\u00020\r2\u0006\u0010;\u001a\u00020%2\u0006\u0010@\u001a\u00020,2\b\u0010A\u001a\u0004\u0018\u00010\rH\u0016J\"\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020!2\b\u0010A\u001a\u0004\u0018\u00010\rH\u0016J8\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020,2\u0006\u0010K\u001a\u00020L2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\b\u0010A\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010M\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\b\u0010A\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010N\u001a\u0002002\u0006\u0010O\u001a\u00020P2\b\u0010A\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010Q\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\rH\u0002J\b\u0010R\u001a\u000200H\u0002J\u0012\u0010S\u001a\u0002002\b\u0010A\u001a\u0004\u0018\u00010\rH\u0002J\u0014\u0010T\u001a\u0004\u0018\u00010\r2\b\u0010U\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010V\u001a\u00020P2\u0006\u0010W\u001a\u00020,2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\rH\u0002R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\t\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R$\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010-\u00a8\u0006X"}, d2={"Lcom/android/tools/property/panel/impl/ui/PropertiesPage;", "Lcom/android/tools/property/panel/api/InspectorPanel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "inspectorModel", "Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "getInspectorModel$annotations", "()V", "getInspectorModel", "()Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "lastAddedLine", "Lcom/android/tools/property/panel/api/InspectorLineModel;", "lastTitleLine", "Lcom/android/tools/property/panel/impl/model/CollapsibleLabelModel;", "nameColumnFraction", "Lcom/android/tools/property/ptable/ColumnFraction;", "getNameColumnFraction$annotations", "getNameColumnFraction", "()Lcom/android/tools/property/ptable/ColumnFraction;", "inspector", "Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl;", "scrollPane", "Ljavax/swing/JScrollPane;", "previousTableEditor", "Lcom/android/tools/property/panel/impl/ui/TableEditor;", "lastFocusedEditor", "Ljava/awt/Component;", "lastFocusedEditorOffset", "", "Ljava/lang/Integer;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "value", "", "filter", "getFilter", "()Ljava/lang/String;", "setFilter", "(Ljava/lang/String;)V", "isEmpty", "", "()Z", "enterInFilter", "clear", "", "propertyValuesChanged", "repaint", "addSeparatorBeforeTabs", "storeFocusOffset", "scrollToFocusEditorOffset", "offsetInInspector", "ofComponent", "(Ljava/awt/Component;)Ljava/lang/Integer;", "createScrollPane", "addTitle", "title", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "addSubTitle", "initiallyExpanded", "parent", "addCustomEditor", "editorModel", "Lcom/android/tools/property/panel/api/PropertyEditorModel;", "editor", "addTable", "Lcom/android/tools/property/panel/api/TableLineModel;", "tableModel", "Lcom/android/tools/property/ptable/PTableModel;", "searchable", "tableUI", "Lcom/android/tools/property/panel/api/TableUIProvider;", "addComponent", "addLine", "model", "Lcom/android/tools/property/panel/impl/model/GenericInspectorLineModel;", "checkNewParent", "addSeparatorBeforeTitle", "addSeparatorAfterTitle", "topParent", "line", "addSeparator", "bottomDivider", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nPropertiesPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertiesPage.kt\ncom/android/tools/property/panel/impl/ui/PropertiesPage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1#2:361\n*E\n"})
public final class PropertiesPage
implements InspectorPanel {
    @NotNull
    private final InspectorPanelModel inspectorModel;
    @Nullable
    private InspectorLineModel lastAddedLine;
    @Nullable
    private CollapsibleLabelModel lastTitleLine;
    @NotNull
    private final ColumnFraction nameColumnFraction;
    @NotNull
    private final InspectorPanelImpl inspector;
    @NotNull
    private final JScrollPane scrollPane;
    @Nullable
    private TableEditor previousTableEditor;
    @Nullable
    private Component lastFocusedEditor;
    @Nullable
    private Integer lastFocusedEditorOffset;
    @NotNull
    private final JComponent component;

    public PropertiesPage(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.inspectorModel = new InspectorPanelModel();
        this.nameColumnFraction = new ColumnFraction(PropertiesComponent.getInstance().getFloat("android.property.left.fraction", 0.4f), true);
        this.inspector = new InspectorPanelImpl(this.inspectorModel, this.nameColumnFraction, parentDisposable);
        this.scrollPane = this.createScrollPane((JComponent)((Object)this.inspector));
        this.nameColumnFraction.getListeners().add(() -> PropertiesPage._init_$lambda$0(this));
        this.inspector.setAfterLayout((Function0<Unit>)((Function0)() -> PropertiesPage._init_$lambda$1(this)));
        this.component = this.scrollPane;
    }

    @NotNull
    public final InspectorPanelModel getInspectorModel() {
        return this.inspectorModel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getInspectorModel$annotations() {
    }

    @NotNull
    public final ColumnFraction getNameColumnFraction() {
        return this.nameColumnFraction;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNameColumnFraction$annotations() {
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final String getFilter() {
        return this.inspectorModel.getFilter();
    }

    public final void setFilter(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.inspectorModel.setFilter(value2);
    }

    public final boolean isEmpty() {
        return this.inspectorModel.getLines().isEmpty();
    }

    public final boolean enterInFilter() {
        return this.inspectorModel.enterInFilter();
    }

    public final void clear() {
        this.inspectorModel.clear();
        this.inspector.removeAll();
        this.previousTableEditor = null;
        this.lastAddedLine = null;
        this.lastTitleLine = null;
        this.lastFocusedEditor = null;
        this.lastFocusedEditorOffset = null;
    }

    public final void propertyValuesChanged() {
        this.storeFocusOffset();
        this.inspectorModel.propertyValuesChanged();
    }

    public final void repaint() {
        this.inspector.revalidate();
        this.inspector.repaint();
    }

    public final void addSeparatorBeforeTabs() {
        this.addSeparatorBeforeTitle();
    }

    private final void storeFocusOffset() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.lastFocusedEditorOffset = this.offsetInInspector(focusOwner);
        this.lastFocusedEditor = this.lastFocusedEditorOffset != null ? focusOwner : null;
    }

    private final void scrollToFocusEditorOffset() {
        Integer offset;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Integer lastOffset = this.lastFocusedEditorOffset;
        if (Intrinsics.areEqual((Object)focusOwner, (Object)this.lastFocusedEditor) && lastOffset != null && (offset = this.offsetInInspector(focusOwner)) != null && !Intrinsics.areEqual((Object)offset, (Object)lastOffset)) {
            Point pos = this.scrollPane.getViewport().getViewPosition();
            pos.y = Math.max(pos.y + offset - lastOffset, 0);
            this.scrollPane.getViewport().setViewPosition(pos);
            this.lastFocusedEditorOffset = this.offsetInInspector(focusOwner);
        }
    }

    private final Integer offsetInInspector(Component ofComponent) {
        Component component;
        int offset = 0;
        for (component = ofComponent; component != null && !Intrinsics.areEqual((Object)component, (Object)((Object)this.inspector)); component = (Component)component.getParent()) {
            offset += component.getY();
        }
        return Intrinsics.areEqual((Object)component, (Object)((Object)this.inspector)) ? Integer.valueOf(offset) : null;
    }

    private final JScrollPane createScrollPane(JComponent component) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)component, (int)20, (int)31);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane scrollPane2 = jScrollPane;
        scrollPane2.setVerticalScrollBar((JScrollBar)new JBScrollBar(){

            public void setOpaque(boolean isOpaque) {
                super.setOpaque(isOpaque || SystemInfo.isMac);
            }
        });
        scrollPane2.setBorder((Border)JBUI.Borders.empty());
        scrollPane2.addComponentListener(new ComponentAdapter(scrollPane2){
            final /* synthetic */ JScrollPane $scrollPane;
            {
                this.$scrollPane = $scrollPane;
            }

            public void componentResized(ComponentEvent event) {
                this.$scrollPane.getVerticalScrollBar().setUnitIncrement(JBUI.scale((int)16) * (SystemInfo.isWindows ? 1 : 2));
                this.$scrollPane.getVerticalScrollBar().setBlockIncrement(this.$scrollPane.getHeight());
            }
        });
        return scrollPane2;
    }

    @Override
    @NotNull
    public InspectorLineModel addTitle(@NotNull String title2, @NotNull List<? extends AnAction> actions2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        this.addSeparatorBeforeTitle();
        TitleLineModel model = new TitleLineModel(title2);
        CollapsibleLabelPanel label2 = new CollapsibleLabelPanel(model, UIUtil.FontSize.NORMAL, 1, actions2, this.nameColumnFraction);
        label2.setOpaque(true);
        label2.setInnerBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        label2.setBorder(JBUI.Borders.merge((Border)((Border)JBUI.Borders.emptyLeft((int)6)), (Border)((Border)new SideBorder(JBColor.border(), 8)), (boolean)true));
        this.addLine(model, null);
        this.inspector.addLineElement(label2);
        label2.setBackground(UIUtil.getPanelBackground());
        this.lastTitleLine = model;
        return model;
    }

    @Override
    @NotNull
    public InspectorLineModel addSubTitle(@NotNull String title2, boolean initiallyExpanded, @Nullable InspectorLineModel parent) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.addSeparatorBeforeTitle();
        TitleLineModel model = new TitleLineModel(title2);
        CollapsibleLabelPanel label2 = new CollapsibleLabelPanel(model, UIUtil.FontSize.NORMAL, 1, null, null, 24, null);
        label2.setOpaque(true);
        label2.setInnerBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        label2.setBorder(JBUI.Borders.merge((Border)((Border)JBUI.Borders.emptyLeft((int)6)), (Border)((Border)new SideBorder(JBColor.border(), 8)), (boolean)true));
        this.addLine(model, parent);
        this.inspector.addLineElement(label2);
        this.lastTitleLine = model;
        model.makeExpandable(initiallyExpanded);
        return model;
    }

    @Override
    @NotNull
    public InspectorLineModel addCustomEditor(@NotNull PropertyEditorModel editorModel, @NotNull JComponent editor, @Nullable InspectorLineModel parent) {
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.addSeparatorAfterTitle(parent);
        CollapsibleLabelModel model = new CollapsibleLabelModel(editorModel.getProperty().getName(), editorModel, false, null, 12, null);
        CollapsibleLabelPanel label2 = new CollapsibleLabelPanel(model, UIUtil.FontSize.SMALL, 0, null, null, 24, null);
        label2.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        editorModel.setLineModel(model);
        this.addLine(model, parent);
        this.inspector.addLineElement(label2, editor);
        return model;
    }

    @Override
    @NotNull
    public TableLineModel addTable(@NotNull PTableModel tableModel2, boolean searchable, @NotNull TableUIProvider tableUI, @NotNull List<? extends AnAction> actions2, @Nullable InspectorLineModel parent) {
        Intrinsics.checkNotNullParameter((Object)tableModel2, (String)"tableModel");
        Intrinsics.checkNotNullParameter((Object)tableUI, (String)"tableUI");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        TableLineModelImpl model = new TableLineModelImpl(tableModel2, searchable);
        TableEditor editor = new TableEditor(model, tableUI.getTableCellRendererProvider(), tableUI.getTableCellEditorProvider(), actions2, this.nameColumnFraction);
        editor.setPreviousTableEditor(this.previousTableEditor);
        TableEditor tableEditor = this.previousTableEditor;
        if (tableEditor != null) {
            tableEditor.setNextTableEditor(editor);
        }
        this.previousTableEditor = editor;
        this.addLine(model, parent);
        this.inspector.addLineElement(editor.getComponent());
        return model;
    }

    @Override
    @NotNull
    public InspectorLineModel addComponent(@NotNull JComponent component, @Nullable InspectorLineModel parent) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.addSeparatorAfterTitle(parent);
        GenericInspectorLineModel model = new GenericInspectorLineModel();
        GenericLinePanel wrapper = new GenericLinePanel(component, model);
        this.addLine(model, parent);
        this.inspector.addLineElement(wrapper);
        return model;
    }

    private final void addLine(GenericInspectorLineModel model, InspectorLineModel parent) {
        InspectorLineModel inspectorLineModel = parent;
        if (inspectorLineModel != null) {
            InspectorLineModel it = inspectorLineModel;
            boolean bl = false;
            this.checkNewParent(it).addChild(model);
        }
        this.inspectorModel.add(model);
        this.lastAddedLine = model;
    }

    private final CollapsibleLabelModel checkNewParent(InspectorLineModel parent) {
        CollapsibleLabelModel collapsibleLabelModel = parent instanceof CollapsibleLabelModel ? (CollapsibleLabelModel)parent : null;
        if (collapsibleLabelModel == null) {
            throw new IllegalArgumentException();
        }
        CollapsibleLabelModel label2 = collapsibleLabelModel;
        if (!label2.getExpandable()) {
            throw new IllegalArgumentException();
        }
        return label2;
    }

    private final void addSeparatorBeforeTitle() {
        if (this.lastAddedLine == null || Intrinsics.areEqual((Object)this.lastAddedLine, (Object)this.lastTitleLine) || this.lastAddedLine instanceof TableLineModel) {
            return;
        }
        this.addSeparator(true, this.topParent(this.lastAddedLine));
    }

    private final void addSeparatorAfterTitle(InspectorLineModel parent) {
        if (this.lastAddedLine == null || Intrinsics.areEqual((Object)this.lastAddedLine, (Object)this.lastTitleLine)) {
            this.addSeparator(false, parent);
        } else {
            InspectorLineModel topParent;
            InspectorLineModel lastTopParent = this.topParent(this.lastAddedLine);
            if (!Intrinsics.areEqual((Object)lastTopParent, (Object)(topParent = this.topParent(parent)))) {
                this.addSeparator(false, topParent);
            }
        }
    }

    private final InspectorLineModel topParent(InspectorLineModel line) {
        InspectorLineModel topParent = line;
        while (true) {
            InspectorLineModel inspectorLineModel = topParent;
            if ((inspectorLineModel != null ? inspectorLineModel.getParent() : null) == null || topParent instanceof TitleLineModel) break;
            topParent = topParent.getParent();
        }
        InspectorLineModel inspectorLineModel = topParent;
        return inspectorLineModel instanceof TitleLineModel ? (TitleLineModel)inspectorLineModel : null;
    }

    private final GenericInspectorLineModel addSeparator(boolean bottomDivider, InspectorLineModel parent) {
        Border border;
        JPanel component = new JPanel();
        component.setPreferredSize((Dimension)new JBDimension(0, 4));
        component.setBackground(this.inspector.getBackground());
        if (bottomDivider) {
            border = (Border)new SideBorder(JBColor.border(), 8);
        } else {
            JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
            border = (Border)jBEmptyBorder;
        }
        component.setBorder(border);
        SeparatorLineModel model = new SeparatorLineModel();
        GenericLinePanel wrapper = new GenericLinePanel(component, model);
        this.addLine(model, parent);
        this.inspector.addLineElement(wrapper);
        return model;
    }

    static /* synthetic */ GenericInspectorLineModel addSeparator$default(PropertiesPage propertiesPage, boolean bl, InspectorLineModel inspectorLineModel, int n, Object object) {
        if ((n & 2) != 0) {
            inspectorLineModel = null;
        }
        return propertiesPage.addSeparator(bl, inspectorLineModel);
    }

    private static final void _init_$lambda$0(PropertiesPage this$0) {
        this$0.inspector.invalidate();
        this$0.inspector.validate();
        this$0.inspector.repaint();
        PropertiesComponent.getInstance().setValue("android.property.left.fraction", this$0.nameColumnFraction.getValue(), 0.4f);
    }

    private static final Unit _init_$lambda$1(PropertiesPage this$0) {
        this$0.scrollToFocusEditorOffset();
        return Unit.INSTANCE;
    }
}

