/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.config;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.ConfigurationSettings;
import com.android.tools.environment.Logger;
import com.android.tools.preview.config.Densities;
import com.android.tools.preview.config.DeviceConfig;
import com.android.tools.preview.config.DeviceConfigKt;
import com.android.tools.preview.config.DimUnit;
import com.android.tools.preview.config.MutableDeviceConfig;
import com.android.tools.preview.config.Orientation;
import com.android.tools.preview.config.Shape;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\r\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u00020\u0011\u001a$\u0010\u0012\u001a\u0004\u0018\u00010\u000e*\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a$\u0010\u0017\u001a\u0004\u0018\u00010\u000e*\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"REFERENCE_PHONE_SPEC", "", "REFERENCE_FOLDABLE_SPEC", "REFERENCE_TABLET_SPEC", "REFERENCE_DESKTOP_SPEC", "DEVICE_BY_ID_PREFIX", "DEVICE_BY_NAME_PREFIX", "DEVICE_BY_SPEC_PREFIX", "DEFAULT_DEVICE_ID", "DEFAULT_WEAROS_DEVICE_ID", "CHIN_SIZE_PX_FOR_ROUND_CHIN", "", "toDeviceConfig", "Lcom/android/tools/preview/config/DeviceConfig;", "Lcom/android/sdklib/devices/Device;", "createDeviceInstance", "getDefaultPreviewDevice", "Lcom/android/tools/configurations/ConfigurationSettings;", "findOrParseFromDefinition", "", "deviceDefinition", "logger", "Lcom/android/tools/environment/Logger;", "findByIdOrName", "intellij.android.preview-elements"})
@SourceDebugExtension(value={"SMAP\nDeviceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceUtils.kt\ncom/android/tools/preview/config/DeviceUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1#2:213\n295#3,2:214\n295#3,2:216\n*S KotlinDebug\n*F\n+ 1 DeviceUtils.kt\ncom/android/tools/preview/config/DeviceUtilsKt\n*L\n192#1:214,2\n200#1:216,2\n*E\n"})
public final class DeviceUtilsKt {
    @NotNull
    public static final String REFERENCE_PHONE_SPEC = "spec:width=411dp,height=891dp";
    @NotNull
    public static final String REFERENCE_FOLDABLE_SPEC = "spec:width=673dp,height=841dp";
    @NotNull
    public static final String REFERENCE_TABLET_SPEC = "spec:width=1280dp,height=800dp,dpi=240";
    @NotNull
    public static final String REFERENCE_DESKTOP_SPEC = "spec:width=1920dp,height=1080dp,dpi=160";
    @NotNull
    public static final String DEVICE_BY_ID_PREFIX = "id:";
    @NotNull
    public static final String DEVICE_BY_NAME_PREFIX = "name:";
    @NotNull
    public static final String DEVICE_BY_SPEC_PREFIX = "spec:";
    @NotNull
    public static final String DEFAULT_DEVICE_ID = "pixel_5";
    @NotNull
    public static final String DEFAULT_WEAROS_DEVICE_ID = "wearos_small_round";
    public static final int CHIN_SIZE_PX_FOR_ROUND_CHIN = 30;

    @NotNull
    public static final DeviceConfig toDeviceConfig(@NotNull Device $this$toDeviceConfig) {
        MutableDeviceConfig mutableDeviceConfig;
        Intrinsics.checkNotNullParameter((Object)$this$toDeviceConfig, (String)"<this>");
        MutableDeviceConfig $this$toDeviceConfig_u24lambda_u240 = mutableDeviceConfig = new MutableDeviceConfig(null, 0.0f, 0.0f, null, 0, null, 0.0f, null, null, null, null, 2047, null);
        boolean bl = false;
        $this$toDeviceConfig_u24lambda_u240.setDimUnit(DimUnit.px);
        MutableDeviceConfig config = mutableDeviceConfig;
        State deviceState2 = $this$toDeviceConfig.getDefaultState();
        Screen screen = deviceState2.getHardware().getScreen();
        config.setWidth(screen.getXDimension());
        config.setHeight(screen.getYDimension());
        config.setDpi(screen.getPixelDensity().getDpiValue());
        ScreenOrientation screenOrientation = deviceState2.getOrientation();
        config.setOrientation((screenOrientation == null ? -1 : WhenMappings.$EnumSwitchMapping$0[screenOrientation.ordinal()]) == 1 ? Orientation.landscape : Orientation.portrait);
        if (screen.getScreenRound() == ScreenRound.ROUND) {
            config.setShape(Shape.Round);
            config.setChinSize(screen.getChin());
        } else {
            config.setShape(Shape.Normal);
        }
        if (!Intrinsics.areEqual((Object)$this$toDeviceConfig.getId(), (Object)"Custom")) {
            config.setParentDeviceId($this$toDeviceConfig.getId());
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Device createDeviceInstance(@NotNull DeviceConfig $this$createDeviceInstance) {
        void $this$createDeviceInstance_u24lambda_u241_u240_u240;
        void $this$createDeviceInstance_u24lambda_u241_u240;
        Screen screen;
        State $this$createDeviceInstance_u24lambda_u240_u240;
        State state2;
        Device.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$createDeviceInstance, (String)"<this>");
        MutableDeviceConfig deviceConfig = !($this$createDeviceInstance instanceof MutableDeviceConfig) ? DeviceConfigKt.toMutableConfig($this$createDeviceInstance) : (MutableDeviceConfig)$this$createDeviceInstance;
        Device.Builder $this$createDeviceInstance_u24lambda_u240 = builder = new Device.Builder();
        boolean bl = false;
        $this$createDeviceInstance_u24lambda_u240.setTagId("");
        $this$createDeviceInstance_u24lambda_u240.setName("Custom");
        $this$createDeviceInstance_u24lambda_u240.setId("Custom");
        $this$createDeviceInstance_u24lambda_u240.setManufacturer("");
        $this$createDeviceInstance_u24lambda_u240.addSoftware(new Software());
        State state3 = state2 = new State();
        Device.Builder builder2 = $this$createDeviceInstance_u24lambda_u240;
        boolean bl2 = false;
        $this$createDeviceInstance_u24lambda_u240_u240.setName("default");
        $this$createDeviceInstance_u24lambda_u240_u240.setDefaultState(true);
        $this$createDeviceInstance_u24lambda_u240_u240.setHardware(new Hardware());
        builder2.addState(state2);
        Device customDevice = builder.build();
        Device.Builder $this$createDeviceInstance_u24lambda_u241 = builder = customDevice.getDefaultState();
        boolean bl3 = false;
        $this$createDeviceInstance_u24lambda_u241.setOrientation(switch (WhenMappings.$EnumSwitchMapping$1[deviceConfig.getOrientation().ordinal()]) {
            case 1 -> ScreenOrientation.LANDSCAPE;
            case 2 -> ScreenOrientation.PORTRAIT;
            default -> throw new NoWhenBranchMatchedException();
        });
        $this$createDeviceInstance_u24lambda_u240_u240 = state2 = new Hardware();
        builder2 = $this$createDeviceInstance_u24lambda_u241;
        boolean bl4 = false;
        Screen screen2 = screen = new Screen();
        void var12_12 = $this$createDeviceInstance_u24lambda_u241_u240;
        boolean bl5 = false;
        Density density = Densities.getCommonScreenDensity(false, deviceConfig.getDpi(), 0);
        Intrinsics.checkNotNullExpressionValue((Object)density, (String)"getCommonScreenDensity(...)");
        Density resolvedDensity = density;
        deviceConfig.setDpi(resolvedDensity.getDpiValue());
        deviceConfig.setDimUnit(DimUnit.px);
        $this$createDeviceInstance_u24lambda_u241_u240_u240.setXDimension(MathKt.roundToInt((float)deviceConfig.getWidth()));
        $this$createDeviceInstance_u24lambda_u241_u240_u240.setYDimension(MathKt.roundToInt((float)deviceConfig.getHeight()));
        $this$createDeviceInstance_u24lambda_u241_u240_u240.setPixelDensity(resolvedDensity);
        $this$createDeviceInstance_u24lambda_u241_u240_u240.setDiagonalLength(Math.sqrt(1.0 * (double)$this$createDeviceInstance_u24lambda_u241_u240_u240.getXDimension() * (double)$this$createDeviceInstance_u24lambda_u241_u240_u240.getXDimension() + 1.0 * (double)$this$createDeviceInstance_u24lambda_u241_u240_u240.getYDimension() * (double)$this$createDeviceInstance_u24lambda_u241_u240_u240.getYDimension()) / (double)$this$createDeviceInstance_u24lambda_u241_u240_u240.getPixelDensity().getDpiValue());
        $this$createDeviceInstance_u24lambda_u241_u240_u240.setScreenRound(deviceConfig.isRound() ? ScreenRound.ROUND : ScreenRound.NOTROUND);
        $this$createDeviceInstance_u24lambda_u241_u240_u240.setChin(deviceConfig.isRound() ? MathKt.roundToInt((float)deviceConfig.getChinSize()) : 0);
        $this$createDeviceInstance_u24lambda_u241_u240_u240.setSize(ScreenSize.getScreenSize((Double)$this$createDeviceInstance_u24lambda_u241_u240_u240.getDiagonalLength()));
        $this$createDeviceInstance_u24lambda_u241_u240_u240.setRatio(ScreenRatio.create((int)$this$createDeviceInstance_u24lambda_u241_u240_u240.getXDimension(), (int)$this$createDeviceInstance_u24lambda_u241_u240_u240.getYDimension()));
        var12_12.setScreen(screen);
        $this$createDeviceInstance_u24lambda_u241_u240.setButtonType(ButtonType.SOFT);
        builder2.setHardware((Hardware)state2);
        Intrinsics.checkNotNull((Object)customDevice);
        return customDevice;
    }

    @Nullable
    public static final Device getDefaultPreviewDevice(@NotNull ConfigurationSettings $this$getDefaultPreviewDevice) {
        Device device2;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$getDefaultPreviewDevice, (String)"<this>");
            Iterable iterable = (Iterable)$this$getDefaultPreviewDevice.getDevices();
            for (Object t : iterable) {
                Device device3 = (Device)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)device3.getId(), (Object)DEFAULT_DEVICE_ID)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((device2 = (Device)v0) == null) {
            device2 = $this$getDefaultPreviewDevice.getDefaultDevice();
        }
        return device2;
    }

    @Nullable
    public static final Device findOrParseFromDefinition(@NotNull Collection<Device> $this$findOrParseFromDefinition, @NotNull String deviceDefinition, @NotNull Logger logger) {
        Device device2;
        Intrinsics.checkNotNullParameter($this$findOrParseFromDefinition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deviceDefinition, (String)"deviceDefinition");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (StringsKt.isBlank((CharSequence)deviceDefinition)) {
            device2 = null;
        } else {
            if (StringsKt.startsWith$default((String)deviceDefinition, (String)DEVICE_BY_SPEC_PREFIX, (boolean)false, (int)2, null)) {
                Device deviceBySpec;
                MutableDeviceConfig mutableDeviceConfig = DeviceConfig.Companion.toMutableDeviceConfigOrNull(deviceDefinition, $this$findOrParseFromDefinition);
                Object object = deviceBySpec = mutableDeviceConfig != null ? DeviceUtilsKt.createDeviceInstance(mutableDeviceConfig) : null;
                if (deviceBySpec == null) {
                    logger.warn("Unable to parse device configuration: " + deviceDefinition);
                }
                return deviceBySpec;
            }
            device2 = DeviceUtilsKt.findByIdOrName($this$findOrParseFromDefinition, deviceDefinition, logger);
        }
        return device2;
    }

    public static /* synthetic */ Device findOrParseFromDefinition$default(Collection collection2, String string, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            logger = Logger.Companion.getInstance(MutableDeviceConfig.class);
        }
        return DeviceUtilsKt.findOrParseFromDefinition(collection2, string, logger);
    }

    @Nullable
    public static final Device findByIdOrName(@NotNull Collection<Device> $this$findByIdOrName, @NotNull String deviceDefinition, @NotNull Logger logger) {
        Object v0;
        Intrinsics.checkNotNullParameter($this$findByIdOrName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deviceDefinition, (String)"deviceDefinition");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Collection<Device> availableDevices = $this$findByIdOrName;
        if (StringsKt.isBlank((CharSequence)deviceDefinition)) {
            v0 = null;
        } else {
            if (StringsKt.startsWith$default((String)deviceDefinition, (String)DEVICE_BY_ID_PREFIX, (boolean)false, (int)2, null)) {
                Object v1;
                String id2;
                block8: {
                    id2 = StringsKt.removePrefix((String)deviceDefinition, (CharSequence)DEVICE_BY_ID_PREFIX);
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                Device deviceById = v1;
                if (deviceById == null) {
                    logger.warn("Unable to find device with id '" + id2 + "'");
                }
                return deviceById;
            }
            if (StringsKt.startsWith$default((String)deviceDefinition, (String)DEVICE_BY_NAME_PREFIX, (boolean)false, (int)2, null)) {
                Object v2;
                String name2;
                block9: {
                    name2 = StringsKt.removePrefix((String)deviceDefinition, (CharSequence)DEVICE_BY_NAME_PREFIX);
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)name2)) continue;
                        v2 = element$iv;
                        break block9;
                    }
                    v2 = null;
                }
                Device deviceByName = v2;
                if (deviceByName == null) {
                    logger.warn("Unable to find device with name '" + name2 + "'");
                }
                return deviceByName;
            }
            logger.warn("Unsupported device definition: " + deviceDefinition);
            v0 = null;
        }
        return v0;
    }

    public static /* synthetic */ Device findByIdOrName$default(Collection collection2, String string, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            logger = Logger.Companion.getInstance(MutableDeviceConfig.class);
        }
        return DeviceUtilsKt.findByIdOrName(collection2, string, logger);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ScreenOrientation.values().length];
            try {
                nArray[ScreenOrientation.LANDSCAPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.landscape.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.portrait.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

