/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizardStepWithDescription
extends DynamicWizardStep
implements Disposable {
    protected static final ScopedStateStore.Key<String> KEY_DESCRIPTION = ScopedStateStore.createKey(String.valueOf(DynamicWizardStepWithDescription.class) + ".description", ScopedStateStore.Scope.STEP, String.class);
    private static final String PROPERTY_FOCUS_OWNER = "focusOwner";
    @Nullable
    private final Disposable myDisposable;
    private PropertyChangeListener myFocusListener;
    private JPanel myRootPane;
    private JLabel myDescriptionLabel;
    private JBLabel myErrorWarningLabel;
    private JPanel mySouthPanel;
    private Map<Component, String> myControlDescriptions = new WeakHashMap<Component, String>();

    public DynamicWizardStepWithDescription(@Nullable Disposable parentDisposable) {
        this.setupUI();
        this.myDisposable = parentDisposable;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
        this.mySouthPanel.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        this.myErrorWarningLabel.setForeground((Color)JBColor.red);
        this.myDescriptionLabel.setText(" ");
    }

    private void setupUI() {
        this.myRootPane = new JPanel();
        this.myRootPane.setLayout(new BorderLayout(0, 0));
        this.mySouthPanel = new JPanel();
        this.mySouthPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myRootPane.add((Component)this.mySouthPanel, "South");
        this.myDescriptionLabel = new JLabel();
        this.myDescriptionLabel.setText("");
        this.mySouthPanel.add((Component)this.myDescriptionLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
        this.myErrorWarningLabel = new JBLabel();
        this.myErrorWarningLabel.setText("");
        this.mySouthPanel.add((Component)this.myErrorWarningLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    @Override
    @NotNull
    protected JPanel createStepBody() {
        return this.myRootPane;
    }

    public void dispose() {
        if (this.myFocusListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(PROPERTY_FOCUS_OWNER, this.myFocusListener);
        }
    }

    protected final void setBodyComponent(JComponent component) {
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)component);
        component.setBorder(new EmptyBorder(new Insets(WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE)));
        this.myRootPane.add((Component)component, "Center");
    }

    @Override
    public void init() {
        this.register(KEY_DESCRIPTION, this.getDescriptionLabel(), new ScopedDataBinder.ComponentBinding<String, JLabel>(){

            @Override
            public void setValue(String newValue, @NotNull JLabel label2) {
                label2.setText(DynamicWizardStepWithDescription.this.toHtml(newValue));
            }
        });
    }

    protected JLabel getDescriptionLabel() {
        return this.myDescriptionLabel;
    }

    @NotNull
    public final JBLabel getMessageLabel() {
        return this.myErrorWarningLabel;
    }

    @Nullable
    protected Disposable getDisposable() {
        return this.myDisposable;
    }
}

