/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.widget;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.tools.idea.widget.AdbConnectionWidget;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StudioAdapter
implements AdbConnectionWidget.StudioAdapter {
    @Nullable
    private Project myProject;
    @Nullable
    private TimerListener myTimerListener;

    StudioAdapter(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    public boolean isBridgeConnected() {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        return bridge != null && bridge.isConnected();
    }

    @Override
    public boolean isBridgeInUserManagedMode() {
        return AndroidDebugBridge.isUserManagedAdbMode();
    }

    @Override
    @Nullable
    public StatusBar getVisibleStatusBar() {
        IdeFrame frame = WindowManager.getInstance().getIdeFrame(this.myProject);
        if (frame == null) {
            return null;
        }
        StatusBar statusBar = frame.getStatusBar();
        if (statusBar == null) {
            return null;
        }
        if (!statusBar.getComponent().isShowing()) {
            return null;
        }
        return statusBar;
    }

    public void dispose() {
        this.removeTimerListener();
        this.myProject = null;
    }

    @Override
    public void setOnUpdate(final @NotNull Runnable update2) {
        if (this.myTimerListener != null) {
            this.removeTimerListener();
        }
        this.myTimerListener = new TimerListener(){

            @NotNull
            public ModalityState getModalityState() {
                return StudioAdapter.this.getModalityState();
            }

            public void run() {
                update2.run();
            }
        };
        ActionManager.getInstance().addTimerListener(this.myTimerListener);
    }

    @NotNull
    private ModalityState getModalityState() {
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
        if (ideFrame == null) {
            return ModalityState.defaultModalityState();
        }
        return ModalityState.stateForComponent((Component)ideFrame.getComponent());
    }

    private void removeTimerListener() {
        if (this.myTimerListener != null) {
            ActionManager.getInstance().removeTimerListener(this.myTimerListener);
        }
        this.myTimerListener = null;
    }
}

