/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.widget;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import icons.StudioIcons;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AdbConnectionWidget
implements StatusBarWidget.IconPresentation,
StatusBarWidget {
    @VisibleForTesting
    static final String ID = "AdbConnectionWidget";
    @NotNull
    private ConnectionState myLastConnectionState;
    @Nullable
    private StudioAdapter myAdapter;

    AdbConnectionWidget(@NotNull StudioAdapter adapter) {
        this.myAdapter = adapter;
        this.myAdapter.setOnUpdate(this::updateIfNeeded);
        Disposer.register((Disposable)this, (Disposable)this.myAdapter);
        this.myLastConnectionState = this.getConnectionState();
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    public void dispose() {
        this.myAdapter = null;
    }

    @NotNull
    public String getTooltipText() {
        return this.myLastConnectionState.myTooltip;
    }

    @NotNull
    public Icon getIcon() {
        return this.myLastConnectionState.myIcon;
    }

    private void updateIfNeeded() {
        if (this.myAdapter == null) {
            return;
        }
        StatusBar statusBar = this.myAdapter.getVisibleStatusBar();
        if (statusBar == null) {
            return;
        }
        ConnectionState connectionState = this.getConnectionState();
        if (connectionState == this.myLastConnectionState) {
            return;
        }
        this.myLastConnectionState = connectionState;
        statusBar.updateWidget(ID);
    }

    @NotNull
    private ConnectionState getConnectionState() {
        if (this.myAdapter == null) {
            return ConnectionState.STUDIO_MANAGED_DISCONNECTED;
        }
        if (this.myAdapter.isBridgeConnected()) {
            return this.myAdapter.isBridgeInUserManagedMode() ? ConnectionState.USER_MANAGED_CONNECTED : ConnectionState.STUDIO_MANAGED_CONNECTED;
        }
        return this.myAdapter.isBridgeInUserManagedMode() ? ConnectionState.USER_MANAGED_DISCONNECTED : ConnectionState.STUDIO_MANAGED_DISCONNECTED;
    }

    static interface StudioAdapter
    extends Disposable {
        public boolean isBridgeConnected();

        public boolean isBridgeInUserManagedMode();

        @Nullable
        public StatusBar getVisibleStatusBar();

        public void setOnUpdate(@NotNull Runnable var1);
    }

    static enum ConnectionState {
        STUDIO_MANAGED_DISCONNECTED(ConnectionState.getStatusIcon(StudioIcons.Shell.StatusBar.ADB_MANAGED, Color.RED), "Not initialized/connected to local adb"),
        STUDIO_MANAGED_CONNECTED(ConnectionState.getStatusIcon(StudioIcons.Shell.StatusBar.ADB_MANAGED, Color.GREEN), "Initialized/connected to local adb"),
        USER_MANAGED_DISCONNECTED(ConnectionState.getStatusIcon(StudioIcons.Shell.StatusBar.ADB_UNMANAGED, Color.RED), "Not connected to remote adb"),
        USER_MANAGED_CONNECTED(ConnectionState.getStatusIcon(StudioIcons.Shell.StatusBar.ADB_UNMANAGED, Color.GREEN), "Connected to remote adb");

        @VisibleForTesting
        @NotNull
        Icon myIcon;
        @VisibleForTesting
        @NotNull
        private String myTooltip;

        private ConnectionState(Icon icon, String tooltip) {
            this.myIcon = icon;
            this.myTooltip = tooltip;
        }

        @NotNull
        private static Icon getStatusIcon(@NotNull Icon base, @NotNull Color color) {
            return ExecutionUtil.getIndicator((Icon)base, (int)base.getIconWidth(), (int)base.getIconHeight(), (Color)color);
        }
    }
}

