/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.whatsnew.assistant.WhatsNewBundleCreator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.concurrent.FutureCallback;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/whatsnew/assistant/WhatsNewCheckVersionTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "uiCallback", "Lorg/apache/http/concurrent/FutureCallback;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/apache/http/concurrent/FutureCallback;)V", "isNewVersion", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onSuccess", "onCancel", "onThrowable", "error", "", "whats-new-assistant"})
public final class WhatsNewCheckVersionTask
extends Task.Backgroundable {
    @NotNull
    private final FutureCallback<Boolean> uiCallback;
    private boolean isNewVersion;

    public WhatsNewCheckVersionTask(@NotNull Project project, @NotNull FutureCallback<Boolean> uiCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(uiCallback, (String)"uiCallback");
        super(project, "Checking What's New Assistant version...");
        this.uiCallback = uiCallback;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        WhatsNewBundleCreator bundleCreator;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        WhatsNewBundleCreator whatsNewBundleCreator = bundleCreator = (WhatsNewBundleCreator)AssistantBundleCreator.EP_NAME.findExtension(WhatsNewBundleCreator.class);
        Intrinsics.checkNotNull((Object)whatsNewBundleCreator);
        this.isNewVersion = whatsNewBundleCreator.isNewConfigVersion();
    }

    public void onSuccess() {
        super.onSuccess();
        this.uiCallback.completed((Object)this.isNewVersion);
    }

    public void onCancel() {
        super.onCancel();
        this.uiCallback.cancelled();
    }

    public void onThrowable(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.uiCallback.failed((Exception)new RuntimeException(error));
    }
}

