/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.sdk.wizard.legacy.LicenseAgreementStep;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.AehdSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.AndroidPlatformSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.AndroidSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.AndroidVirtualDeviceSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.SdkComponentCategoryTreeNode;
import com.android.tools.idea.welcome.install.SdkComponentInstaller;
import com.android.tools.idea.welcome.install.SdkComponentTreeNode;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.welcome.wizard.deprecated.AbstractProgressStep;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.deprecated.InstallSummaryStep;
import com.android.tools.idea.welcome.wizard.deprecated.LongRunningOperationPath;
import com.android.tools.idea.welcome.wizard.deprecated.SdkComponentsStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsPath
extends DynamicWizardPath
implements LongRunningOperationPath {
    @NotNull
    private final FirstRunWizardMode myMode;
    private final ObjectValueProperty<AndroidSdkHandler> myLocalHandlerProperty;
    @NotNull
    private final FirstRunWizardTracker myTracker;
    private SdkComponentTreeNode myComponentTree;
    private final AbstractProgressStep myProgressStep;
    @NotNull
    private final SdkComponentInstaller mySdkComponentInstaller;
    private final boolean myInstallUpdates;
    private SdkComponentsStep myComponentsStep;
    @Nullable
    private LicenseAgreementStep myLicenseAgreementStep;

    public InstallComponentsPath(@NotNull FirstRunWizardMode mode, @NotNull File sdkLocation, @NotNull AbstractProgressStep progressStep2, @NotNull SdkComponentInstaller sdkComponentInstaller, boolean installUpdates, @NotNull FirstRunWizardTracker tracker) {
        this.myMode = mode;
        this.myLocalHandlerProperty = new ObjectValueProperty<AndroidSdkHandler>(AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)sdkLocation.toPath()));
        this.myProgressStep = progressStep2;
        this.mySdkComponentInstaller = sdkComponentInstaller;
        this.myInstallUpdates = installUpdates;
        this.myTracker = tracker;
    }

    private SdkComponentTreeNode createComponentTree(@NotNull FirstRunWizardMode reason, boolean createAvd2) {
        AndroidVirtualDeviceSdkComponentTreeNode avdCreator;
        AehdSdkComponentTreeNode.InstallationIntention installationIntention;
        ArrayList<SdkComponentTreeNode> components = new ArrayList<SdkComponentTreeNode>();
        components.add(new AndroidSdkComponentTreeNode(this.myInstallUpdates));
        AndroidSdkHandler localHandler = this.myLocalHandlerProperty.get();
        RepoManager sdkManager = localHandler.getRepoManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, null, null, (ProgressRunner)new StudioProgressRunner(false, "Finding Available SDK Components", null), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        Collection remotePackages = sdkManager.getPackages().getRemotePackages().values();
        components.add(AndroidPlatformSdkComponentTreeNode.Companion.createSubtree(remotePackages, this.myInstallUpdates));
        AehdSdkComponentTreeNode.InstallationIntention installationIntention2 = installationIntention = this.myInstallUpdates ? AehdSdkComponentTreeNode.InstallationIntention.INSTALL_WITH_UPDATES : AehdSdkComponentTreeNode.InstallationIntention.INSTALL_WITHOUT_UPDATES;
        if (reason == FirstRunWizardMode.NEW_INSTALL && AehdSdkComponentTreeNode.InstallerInfo.canRun()) {
            components.add(new AehdSdkComponentTreeNode(installationIntention));
        }
        if (createAvd2 && (avdCreator = new AndroidVirtualDeviceSdkComponentTreeNode(remotePackages, this.myInstallUpdates)).isAvdCreationNeeded(localHandler)) {
            components.add(avdCreator);
        }
        return new SdkComponentCategoryTreeNode("Root", "Root node that is not supposed to appear in the UI", components);
    }

    @Override
    protected void init() {
        AndroidSdkHandler localHandler = this.myLocalHandlerProperty.get();
        File location = localHandler.getLocation().toFile();
        assert (location != null);
        this.myState.put(WizardConstants.KEY_SDK_INSTALL_LOCATION, location.getAbsolutePath());
        this.myComponentTree = this.createComponentTree(this.myMode, !HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated() && this.myMode.shouldCreateAvd());
        this.myComponentTree.updateState(localHandler);
        Supplier<Collection> supplier = () -> {
            Collection<InstallableSdkComponentTreeNode> components = this.myComponentTree.getChildrenToInstall();
            try {
                return this.mySdkComponentInstaller.getPackagesToInstall(this.myLocalHandlerProperty.get(), components);
            }
            catch (SdkQuickfixUtils.PackageResolutionException e) {
                Logger.getInstance(InstallComponentsPath.class).warn((Throwable)e);
                return null;
            }
        };
        Supplier<List<String>> installRequests = () -> {
            Collection remotePackages = (Collection)supplier.get();
            return remotePackages == null ? null : remotePackages.stream().map(it -> it.getPath()).collect(Collectors.toList());
        };
        this.myLicenseAgreementStep = new LicenseAgreementStep(this.myWizard.getDisposable(), installRequests, this.myLocalHandlerProperty::get, this.myTracker);
        this.myComponentsStep = new SdkComponentsStep(this.getProject(), this.myComponentTree, FirstRunWizard.KEY_CUSTOM_INSTALL, WizardConstants.KEY_SDK_INSTALL_LOCATION, this.myMode, this.myLocalHandlerProperty, this.myLicenseAgreementStep, this.myWizard.getDisposable(), this.myTracker);
        this.addStep(this.myComponentsStep);
        if (this.myMode != FirstRunWizardMode.INSTALL_HANDOFF) {
            this.addStep(new InstallSummaryStep(FirstRunWizard.KEY_CUSTOM_INSTALL, WizardConstants.KEY_SDK_INSTALL_LOCATION, supplier, this.myTracker));
            this.addStep(this.myLicenseAgreementStep);
        }
    }

    @Override
    @NotNull
    public String getPathName() {
        return "Setup Android Studio Components";
    }

    @Override
    public void runLongOperation() throws WizardException {
        if (this.myLicenseAgreementStep != null) {
            this.myLicenseAgreementStep.performFinishingActions();
        }
        Collection<InstallableSdkComponentTreeNode> componentsToInstall = this.myComponentTree.getChildrenToInstall();
        this.myTracker.trackSdkComponentsToInstall(componentsToInstall.stream().map(InstallableSdkComponentTreeNode::sdkComponentsMetricKind).toList());
        AndroidSdkHandler localHandler = this.myLocalHandlerProperty.get();
        this.mySdkComponentInstaller.installComponents(componentsToInstall, new InstallContext(InstallComponentsPath.createTempDir(), this.myProgressStep), this.myMode.getInstallerTimestamp(), ModalityState.stateForComponent((Component)this.myWizard.getContentPane()), localHandler, this.getDestination());
    }

    @Nullable
    public static RemotePackage findLatestPlatform(@NotNull Collection<RemotePackage> remotePackages, boolean returnBaseExtension) {
        AndroidVersion max = null;
        RemotePackage latest = null;
        for (RemotePackage pkg : remotePackages) {
            DetailsTypes.PlatformDetailsType platformDetails;
            AndroidVersion version2;
            TypeDetails details = pkg.getTypeDetails();
            if (!(details instanceof DetailsTypes.PlatformDetailsType) || (version2 = (platformDetails = (DetailsTypes.PlatformDetailsType)details).getAndroidVersion()).isPreview() || returnBaseExtension && !version2.isBaseExtension() || max != null && version2.compareTo(max) <= 0) continue;
            latest = pkg;
            max = version2;
        }
        return latest;
    }

    @NotNull
    private File getDestination() throws WizardException {
        String destinationPath = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
        assert (destinationPath != null);
        File destination = new File(destinationPath);
        if (destination.isFile()) {
            throw new WizardException(String.format("Path %s does not point to a directory", destination));
        }
        return destination;
    }

    @Override
    public boolean performFinishingActions() {
        return true;
    }

    public boolean shouldDownloadingComponentsStepBeShown() {
        String path = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
        assert (path != null);
        return SdkLocationUtils.isWritable(Paths.get(path, new String[0]));
    }

    public static File createTempDir() throws WizardException {
        File tempDirectory;
        try {
            tempDirectory = FileUtil.createTempDirectory((String)"AndroidStudio", (String)"FirstRun", (boolean)true);
        }
        catch (IOException e) {
            throw new WizardException("Unable to create temporary folder: " + e.getMessage(), e);
        }
        return tempDirectory;
    }
}

