/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.vitals.datamodel;

import com.android.tools.idea.insights.model.event.PlayTrack;
import com.android.tools.idea.insights.model.event.Version;
import com.android.tools.idea.vitals.datamodel.Dimension;
import com.android.tools.idea.vitals.datamodel.DimensionType;
import com.android.tools.idea.vitals.datamodel.DimensionValue;
import com.google.play.developer.reporting.Release;
import com.google.play.developer.reporting.Track;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0000\u001a\u0018\u0010\t\u001a\u00020\b*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "toPlayTrack", "Lcom/android/tools/idea/insights/model/event/PlayTrack;", "Lcom/google/play/developer/reporting/Track;", "extract", "", "Lcom/android/tools/idea/insights/model/event/Version;", "fromDimensions", "Lcom/android/tools/idea/insights/model/event/Version$Companion;", "dimensions", "Lcom/android/tools/idea/vitals/datamodel/Dimension;", "intellij.android.app-quality-insights.play-vitals.model"})
@SourceDebugExtension(value={"SMAP\nVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Version.kt\ncom/android/tools/idea/vitals/datamodel/VersionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1374#2:85\n1460#2,2:86\n1374#2:88\n1460#2,2:89\n1563#2:91\n1634#2,3:92\n1462#2,3:95\n1462#2,3:98\n1491#2:101\n1516#2,3:102\n1519#2,3:112\n1563#2:118\n1634#2,3:119\n774#2:123\n865#2,2:124\n1563#2:126\n1634#2,2:127\n1636#2:130\n382#3,7:105\n126#4:115\n153#4,2:116\n155#4:122\n1#5:129\n*S KotlinDebug\n*F\n+ 1 Version.kt\ncom/android/tools/idea/vitals/datamodel/VersionKt\n*L\n39#1:85\n39#1:86,2\n42#1:88\n42#1:89,2\n43#1:91\n43#1:92,3\n42#1:95,3\n39#1:98,3\n48#1:101\n48#1:102,3\n48#1:112,3\n54#1:118\n54#1:119,3\n61#1:123\n61#1:124,2\n62#1:126\n62#1:127,2\n62#1:130\n48#1:105,7\n49#1:115\n49#1:116,2\n49#1:122\n*E\n"})
public final class VersionKt {
    private static final Logger LOG = Logger.getLogger("vitals.datamodel.Verion");

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final PlayTrack toPlayTrack(@NotNull Track $this$toPlayTrack) {
        Intrinsics.checkNotNullParameter((Object)$this$toPlayTrack, (String)"<this>");
        String string = $this$toPlayTrack.getType();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1100897882: {
                    if (!string.equals("Open testing")) break;
                    n = 1;
                    break;
                }
                case -548483879: {
                    if (!string.equals("Production")) break;
                    n = 2;
                    break;
                }
                case 635054813: {
                    if (!string.equals("Internal")) break;
                    n = 3;
                    break;
                }
                case -400076932: {
                    if (!string.equals("Closed testing")) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    PlayTrack playTrack = PlayTrack.PRODUCTION;
                    return playTrack;
                }
                case 3: {
                    PlayTrack playTrack = PlayTrack.INTERNAL;
                    return playTrack;
                }
                case 1: {
                    PlayTrack playTrack = PlayTrack.OPEN_TESTING;
                    return playTrack;
                }
                case 4: {
                    PlayTrack playTrack = PlayTrack.CLOSED_TESTING;
                    return playTrack;
                }
            }
        }
        LOG.log(Level.WARNING, $this$toPlayTrack.getType() + " is not of a supported Play Track type.");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Version> extract(@NotNull List<Track> $this$extract) {
        void $this$mapTo$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Object object;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$extract, (String)"<this>");
        Iterable $this$flatMap$iv = $this$extract;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            Track track = (Track)element$iv$iv;
            boolean bl = false;
            if (VersionKt.toPlayTrack(track) == null) {
                iterable2 = CollectionsKt.emptyList();
            } else {
                void $this$flatMapTo$iv$iv2;
                List list2 = track.getServingReleasesList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getServingReleasesList(...)");
                Iterable $this$flatMap$iv2 = list2;
                boolean $i$f$flatMap2 = false;
                object = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                    void $this$mapTo$iv$iv2;
                    Release release = (Release)element$iv$iv2;
                    boolean bl2 = false;
                    List list3 = release.getVersionCodesList();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getVersionCodesList(...)");
                    Iterable $this$map$iv = list3;
                    boolean $i$f$map = false;
                    Iterable iterable3 = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        PlayTrack trackType;
                        void versionCode2;
                        Long l = (Long)item$iv$iv;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl3 = false;
                        collection2.add(TuplesKt.to((Object)versionCode2, (Object)trackType));
                    }
                    Iterable list$iv$iv2 = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
                }
                iterable2 = (List)destination$iv$iv2;
            }
            list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List flattened = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = flattened;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Long key$iv$iv = (Long)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object3;
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object4 = destination$iv$iv;
            boolean bl = false;
            Long versionCode3 = (Long)entry.getKey();
            List tracks = (List)entry.getValue();
            Iterable $i$f$getOrPut = tracks;
            object = "";
            String string = "";
            String string2 = String.valueOf(versionCode3);
            boolean $i$f$map2 = false;
            void bl2 = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void it;
                Pair $i$f$mapTo3 = (Pair)item$iv$iv2;
                object3 = destination$iv$iv4;
                boolean bl5 = false;
                object3.add((PlayTrack)it.getSecond());
            }
            object3 = (List)destination$iv$iv4;
            Set set2 = CollectionsKt.toSet((Iterable)((Iterable)object3));
            Object object5 = object;
            String string3 = string;
            String string4 = string2;
            object4.add(new Version(string4, string3, (String)object5, set2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Version fromDimensions(@NotNull Version.Companion $this$fromDimensions, @NotNull List<Dimension> dimensions) {
        void $this$mapTo$iv$iv;
        Dimension it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fromDimensions, (String)"<this>");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Iterable $this$filter$iv = dimensions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Dimension)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == DimensionType.VERSION_CODE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2;
            void dimension2;
            it = (Dimension)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            DimensionValue dimensionValue = dimension2.getValue();
            if (dimensionValue instanceof DimensionValue.LongValue) {
                string2 = String.valueOf(((DimensionValue.LongValue)dimension2.getValue()).getValue());
            } else if (dimensionValue instanceof DimensionValue.StringValue) {
                string2 = ((DimensionValue.StringValue)dimension2.getValue()).getValue();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String versionCode2 = string2;
            String it2 = string = dimension2.getDisplayValue();
            boolean bl2 = false;
            String string3 = !(((CharSequence)it2).length() == 0) ? string : null;
            if (string3 == null) {
                string3 = versionCode2;
            }
            String displayValue = string3;
            collection2.add(new Version(versionCode2, displayValue, displayValue, SetsKt.emptySet()));
        }
        return (Version)CollectionsKt.single((List)((List)destination$iv$iv));
    }
}

