/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.vitals.datamodel;

import com.android.tools.idea.insights.model.event.Device;
import com.android.tools.idea.insights.model.event.DeviceType;
import com.android.tools.idea.vitals.datamodel.Dimension;
import com.android.tools.idea.vitals.datamodel.DimensionType;
import com.android.tools.idea.vitals.datamodel.DimensionValue;
import com.google.play.developer.reporting.DeviceModelSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a \u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"fromProto", "Lcom/android/tools/idea/insights/model/event/Device;", "Lcom/android/tools/idea/insights/model/event/Device$Companion;", "proto", "Lcom/google/play/developer/reporting/DeviceModelSummary;", "fromDimensions", "dimensions", "", "Lcom/android/tools/idea/vitals/datamodel/Dimension;", "extractDeviceModel", "", "value", "extractMarketingName", "manufacturer", "model", "createFullDisplayName", "intellij.android.app-quality-insights.play-vitals.model"})
@SourceDebugExtension(value={"SMAP\nDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Device.kt\ncom/android/tools/idea/vitals/datamodel/DeviceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1563#2:85\n1634#2,3:86\n1#3:89\n*S KotlinDebug\n*F\n+ 1 Device.kt\ncom/android/tools/idea/vitals/datamodel/DeviceKt\n*L\n38#1:85\n38#1:86,3\n*E\n"})
public final class DeviceKt {
    @NotNull
    public static final Device fromProto(@NotNull Device.Companion $this$fromProto, @NotNull DeviceModelSummary proto) {
        Intrinsics.checkNotNullParameter((Object)$this$fromProto, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        String brand = proto.getDeviceId().getBuildBrand();
        String model = proto.getDeviceId().getBuildDevice();
        Intrinsics.checkNotNull((Object)brand);
        Intrinsics.checkNotNull((Object)model);
        String string = proto.getMarketingName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMarketingName(...)");
        return new Device(brand, model, DeviceKt.createFullDisplayName(brand, model, string), null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Device fromDimensions(@NotNull Device.Companion $this$fromDimensions, @NotNull List<Dimension> dimensions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fromDimensions, (String)"<this>");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        String deviceModel = null;
        deviceModel = "";
        String displayName = null;
        displayName = "";
        String manufacturer = null;
        manufacturer = "";
        String deviceType = null;
        deviceType = "";
        Iterable $this$map$iv = dimensions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Dimension dimension2 = (Dimension)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                case 1: {
                    DimensionValue dimensionValue = it.getValue();
                    Intrinsics.checkNotNull((Object)dimensionValue, (String)"null cannot be cast to non-null type com.android.tools.idea.vitals.datamodel.DimensionValue.StringValue");
                    manufacturer = ((DimensionValue.StringValue)dimensionValue).getValue();
                    break;
                }
                case 2: {
                    DimensionValue dimensionValue = it.getValue();
                    Intrinsics.checkNotNull((Object)dimensionValue, (String)"null cannot be cast to non-null type com.android.tools.idea.vitals.datamodel.DimensionValue.StringValue");
                    deviceModel = DeviceKt.extractDeviceModel(((DimensionValue.StringValue)dimensionValue).getValue());
                    displayName = DeviceKt.extractMarketingName(manufacturer, deviceModel, it.getDisplayValue());
                    break;
                }
                case 3: {
                    deviceType = it.getDisplayValue();
                    break;
                }
                default: {
                }
            }
            collection2.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return new Device(manufacturer, deviceModel, displayName, new DeviceType(deviceType));
    }

    private static final String extractDeviceModel(String value2) {
        Object object;
        Object object2 = new char[]{'/'};
        int n = 1;
        if (n < (object2 = (Object)StringsKt.split$default((CharSequence)value2, (char[])object2, (boolean)false, (int)0, (int)6, null)).size()) {
            object = object2.get(n);
        } else {
            int it = n;
            boolean bl = false;
            object = value2;
        }
        return (String)object;
    }

    private static final String extractMarketingName(String manufacturer, String model, String value2) {
        Object object;
        block6: {
            block5: {
                CharSequence charSequence;
                Regex regex = new Regex("^" + manufacturer + " " + model + " \\((.*)\\)$");
                MatchResult result2 = regex.matchEntire((CharSequence)value2);
                object = result2;
                if (object == null || (object = object.getGroupValues()) == null || (object = (String)CollectionsKt.getOrNull((List)object, (int)1)) == null) break block5;
                CharSequence charSequence2 = (CharSequence)object;
                if (charSequence2.length() == 0) {
                    boolean bl = false;
                    charSequence = model;
                } else {
                    charSequence = charSequence2;
                }
                if ((object = (String)charSequence) != null) break block6;
            }
            object = value2;
        }
        return object;
    }

    private static final String createFullDisplayName(String manufacturer, String model, String value2) {
        String marketingName = DeviceKt.extractMarketingName(manufacturer, model, value2);
        return StringsKt.startsWith((String)marketingName, (String)manufacturer, (boolean)true) ? marketingName : manufacturer + " " + marketingName;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DimensionType.values().length];
            try {
                nArray[DimensionType.DEVICE_BRAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionType.DEVICE_MODEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionType.DEVICE_TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

