/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u001a8\u0010\u000b\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u001a.\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0014"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "listenUntilNextSync", "", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager$SyncResultListener;", "runWhenSmartAndSynced", "callback", "Ljava/util/function/Consumer;", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager$SyncResult;", "runOnEdt", "", "syncManager", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager;", "runWhenSmartAndSyncedOnEdt", "intellij.android.core"})
@JvmName(name="SyncUtil")
@SourceDebugExtension(value={"SMAP\nSyncUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncUtil.kt\ncom/android/tools/idea/util/SyncUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n61#2,5:139\n61#2,5:144\n61#2,5:149\n61#2,5:154\n61#2,5:159\n*S KotlinDebug\n*F\n+ 1 SyncUtil.kt\ncom/android/tools/idea/util/SyncUtil\n*L\n79#1:139,5\n92#1:144,5\n106#1:149,5\n112#1:154,5\n121#1:159,5\n*E\n"})
public final class SyncUtil {
    private static final Logger getLOG() {
        Logger logger = Logger.getInstance((String)"SyncUtil.kt");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @JvmOverloads
    public static final void listenUntilNextSync(@NotNull Project $this$listenUntilNextSync, @NotNull Disposable parentDisposable, @NotNull ProjectSystemSyncManager.SyncResultListener listener2) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)$this$listenUntilNextSync, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        MessageBusConnection $this$listenUntilNextSync_u24lambda_u240 = messageBusConnection = $this$listenUntilNextSync.getMessageBus().connect(parentDisposable);
        boolean bl = false;
        $this$listenUntilNextSync_u24lambda_u240.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)new ProjectSystemSyncManager.SyncResultListener($this$listenUntilNextSync_u24lambda_u240, listener2){
            final /* synthetic */ MessageBusConnection $this_apply;
            final /* synthetic */ ProjectSystemSyncManager.SyncResultListener $listener;
            {
                this.$this_apply = $receiver;
                this.$listener = $listener;
            }

            public void syncEnded(ProjectSystemSyncManager.SyncResult result2) {
                Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
                this.$this_apply.disconnect();
                this.$listener.syncEnded(result2);
            }
        });
    }

    public static /* synthetic */ void listenUntilNextSync$default(Project project, Disposable disposable, ProjectSystemSyncManager.SyncResultListener syncResultListener, int n, Object object) {
        if ((n & 1) != 0) {
            disposable = (Disposable)project;
        }
        SyncUtil.listenUntilNextSync(project, disposable, syncResultListener);
    }

    @JvmOverloads
    public static final void runWhenSmartAndSynced(@NotNull Project $this$runWhenSmartAndSynced, @NotNull Disposable parentDisposable, @NotNull Consumer<ProjectSystemSyncManager.SyncResult> callback2, boolean runOnEdt, @NotNull ProjectSystemSyncManager syncManager) {
        boolean $i$f$debug;
        Logger $this$debug_u24default$iv;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)$this$runWhenSmartAndSynced, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)syncManager, (String)"syncManager");
        if (Disposer.isDisposed((Disposable)parentDisposable)) {
            SyncUtil.getLOG().warn("parentDisposable was already disposed, callback will not be called.");
            return;
        }
        DumbService dumbService = DumbService.Companion.getInstance($this$runWhenSmartAndSynced);
        Logger $this$debug_u24default$iv2 = SyncUtil.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("runWhenSmartAndSynced isDumb=" + dumbService.isDumb() + " runOnEdt=" + runOnEdt + " callback=" + callback2, e$iv);
        }
        if (dumbService.isDumb()) {
            if (runOnEdt) {
                dumbService.smartInvokeLater(() -> SyncUtil.runWhenSmartAndSynced$lambda$1($this$runWhenSmartAndSynced, parentDisposable, callback2, runOnEdt, syncManager));
            } else {
                dumbService.runWhenSmart(() -> SyncUtil.runWhenSmartAndSynced$lambda$2($this$runWhenSmartAndSynced, parentDisposable, callback2, runOnEdt, syncManager));
            }
            return;
        }
        if (syncManager.isSyncInProgress()) {
            $this$debug_u24default$iv2 = SyncUtil.getLOG();
            e$iv = null;
            $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("runWhenSmartAndSynced waiting for sync callback=" + callback2, e$iv);
            }
            SyncUtil.listenUntilNextSync($this$runWhenSmartAndSynced, parentDisposable, arg_0 -> SyncUtil.runWhenSmartAndSynced$lambda$4($this$runWhenSmartAndSynced, parentDisposable, callback2, runOnEdt, syncManager, arg_0));
            return;
        }
        ProjectSystemSyncManager.SyncResult lastSyncResult = syncManager.getLastSyncResult();
        if (lastSyncResult == ProjectSystemSyncManager.SyncResult.UNKNOWN) {
            $this$debug_u24default$iv = SyncUtil.getLOG();
            Throwable e$iv2 = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("last sync result is in unknown state=" + callback2, e$iv2);
            }
            SyncUtil.listenUntilNextSync($this$runWhenSmartAndSynced, parentDisposable, arg_0 -> SyncUtil.runWhenSmartAndSynced$lambda$6($this$runWhenSmartAndSynced, parentDisposable, callback2, runOnEdt, syncManager, arg_0));
            return;
        }
        if (runOnEdt && !ApplicationManager.getApplication().isDispatchThread()) {
            $this$debug_u24default$iv = SyncUtil.getLOG();
            Throwable e$iv3 = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("runWhenSmartAndSynced needs EDT callback=" + callback2, e$iv3);
            }
            UIUtil.invokeLaterIfNeeded(() -> SyncUtil.runWhenSmartAndSynced$lambda$8($this$runWhenSmartAndSynced, parentDisposable, callback2, runOnEdt, syncManager));
            return;
        }
        if (Disposer.isDisposed((Disposable)parentDisposable)) {
            SyncUtil.getLOG().warn("parentDisposable was already disposed, callback will not be called.");
            return;
        }
        $this$debug_u24default$iv = SyncUtil.getLOG();
        Throwable e$iv4 = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("runWhenSmartAndSynced all conditions met callback=" + callback2, e$iv4);
        }
        callback2.accept(lastSyncResult);
    }

    public static /* synthetic */ void runWhenSmartAndSynced$default(Project project, Disposable disposable, Consumer consumer2, boolean bl, ProjectSystemSyncManager projectSystemSyncManager, int n, Object object) {
        if ((n & 1) != 0) {
            disposable = (Disposable)project;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            projectSystemSyncManager = ProjectSystemUtil.getSyncManager(project);
        }
        SyncUtil.runWhenSmartAndSynced(project, disposable, consumer2, bl, projectSystemSyncManager);
    }

    @JvmOverloads
    public static final void runWhenSmartAndSyncedOnEdt(@NotNull Project $this$runWhenSmartAndSyncedOnEdt, @NotNull Disposable parentDisposable, @NotNull Consumer<ProjectSystemSyncManager.SyncResult> callback2, @NotNull ProjectSystemSyncManager syncManager) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenSmartAndSyncedOnEdt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)syncManager, (String)"syncManager");
        SyncUtil.runWhenSmartAndSynced($this$runWhenSmartAndSyncedOnEdt, parentDisposable, callback2, true, syncManager);
    }

    public static /* synthetic */ void runWhenSmartAndSyncedOnEdt$default(Project project, Disposable disposable, Consumer consumer2, ProjectSystemSyncManager projectSystemSyncManager, int n, Object object) {
        if ((n & 1) != 0) {
            disposable = (Disposable)project;
        }
        if ((n & 4) != 0) {
            projectSystemSyncManager = ProjectSystemUtil.getSyncManager(project);
        }
        SyncUtil.runWhenSmartAndSyncedOnEdt(project, disposable, consumer2, projectSystemSyncManager);
    }

    @JvmOverloads
    public static final void listenUntilNextSync(@NotNull Project $this$listenUntilNextSync, @NotNull ProjectSystemSyncManager.SyncResultListener listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$listenUntilNextSync, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        SyncUtil.listenUntilNextSync$default($this$listenUntilNextSync, null, listener2, 1, null);
    }

    @JvmOverloads
    public static final void runWhenSmartAndSynced(@NotNull Project $this$runWhenSmartAndSynced, @NotNull Disposable parentDisposable, @NotNull Consumer<ProjectSystemSyncManager.SyncResult> callback2, boolean runOnEdt) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenSmartAndSynced, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        SyncUtil.runWhenSmartAndSynced$default($this$runWhenSmartAndSynced, parentDisposable, callback2, runOnEdt, null, 8, null);
    }

    @JvmOverloads
    public static final void runWhenSmartAndSynced(@NotNull Project $this$runWhenSmartAndSynced, @NotNull Disposable parentDisposable, @NotNull Consumer<ProjectSystemSyncManager.SyncResult> callback2) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenSmartAndSynced, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        SyncUtil.runWhenSmartAndSynced$default($this$runWhenSmartAndSynced, parentDisposable, callback2, false, null, 12, null);
    }

    @JvmOverloads
    public static final void runWhenSmartAndSynced(@NotNull Project $this$runWhenSmartAndSynced, @NotNull Consumer<ProjectSystemSyncManager.SyncResult> callback2) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenSmartAndSynced, (String)"<this>");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        SyncUtil.runWhenSmartAndSynced$default($this$runWhenSmartAndSynced, null, callback2, false, null, 13, null);
    }

    @JvmOverloads
    public static final void runWhenSmartAndSyncedOnEdt(@NotNull Project $this$runWhenSmartAndSyncedOnEdt, @NotNull Disposable parentDisposable, @NotNull Consumer<ProjectSystemSyncManager.SyncResult> callback2) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenSmartAndSyncedOnEdt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        SyncUtil.runWhenSmartAndSyncedOnEdt$default($this$runWhenSmartAndSyncedOnEdt, parentDisposable, callback2, null, 4, null);
    }

    @JvmOverloads
    public static final void runWhenSmartAndSyncedOnEdt(@NotNull Project $this$runWhenSmartAndSyncedOnEdt, @NotNull Consumer<ProjectSystemSyncManager.SyncResult> callback2) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenSmartAndSyncedOnEdt, (String)"<this>");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        SyncUtil.runWhenSmartAndSyncedOnEdt$default($this$runWhenSmartAndSyncedOnEdt, null, callback2, null, 5, null);
    }

    private static final void runWhenSmartAndSynced$lambda$1(Project $this_runWhenSmartAndSynced, Disposable $parentDisposable, Consumer $callback, boolean $runOnEdt, ProjectSystemSyncManager $syncManager) {
        SyncUtil.runWhenSmartAndSynced($this_runWhenSmartAndSynced, $parentDisposable, $callback, $runOnEdt, $syncManager);
    }

    private static final void runWhenSmartAndSynced$lambda$2(Project $this_runWhenSmartAndSynced, Disposable $parentDisposable, Consumer $callback, boolean $runOnEdt, ProjectSystemSyncManager $syncManager) {
        SyncUtil.runWhenSmartAndSynced($this_runWhenSmartAndSynced, $parentDisposable, $callback, $runOnEdt, $syncManager);
    }

    private static final void runWhenSmartAndSynced$lambda$4(Project $this_runWhenSmartAndSynced, Disposable $parentDisposable, Consumer $callback, boolean $runOnEdt, ProjectSystemSyncManager $syncManager, ProjectSystemSyncManager.SyncResult it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        SyncUtil.runWhenSmartAndSynced($this_runWhenSmartAndSynced, $parentDisposable, $callback, $runOnEdt, $syncManager);
    }

    private static final void runWhenSmartAndSynced$lambda$6(Project $this_runWhenSmartAndSynced, Disposable $parentDisposable, Consumer $callback, boolean $runOnEdt, ProjectSystemSyncManager $syncManager, ProjectSystemSyncManager.SyncResult it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        SyncUtil.runWhenSmartAndSynced($this_runWhenSmartAndSynced, $parentDisposable, $callback, $runOnEdt, $syncManager);
    }

    private static final void runWhenSmartAndSynced$lambda$8(Project $this_runWhenSmartAndSynced, Disposable $parentDisposable, Consumer $callback, boolean $runOnEdt, ProjectSystemSyncManager $syncManager) {
        SyncUtil.runWhenSmartAndSynced($this_runWhenSmartAndSynced, $parentDisposable, $callback, $runOnEdt, $syncManager);
    }
}

