/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J.\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/util/ReformatUtil;", "", "<init>", "()V", "reformatRearrangeAndSave", "", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Ljava/io/File;", "reformatAndRearrange", "psiElement", "Lcom/intellij/psi/PsiElement;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "keepDocumentLocked", "", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nReformatUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReformatUtil.kt\ncom/android/tools/idea/util/ReformatUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1321#2:99\n1322#2:101\n1#3:100\n*S KotlinDebug\n*F\n+ 1 ReformatUtil.kt\ncom/android/tools/idea/util/ReformatUtil\n*L\n39#1:99\n39#1:101\n*E\n"})
public final class ReformatUtil {
    @NotNull
    public static final ReformatUtil INSTANCE = new ReformatUtil();

    private ReformatUtil() {
    }

    @JvmStatic
    public static final void reformatRearrangeAndSave(@NotNull Project project, @NotNull Iterable<? extends File> files2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        WriteCommandAction.runWriteCommandAction((Project)project, () -> ReformatUtil.reformatRearrangeAndSave$lambda$0(files2, project));
    }

    @JvmStatic
    public static final void reformatAndRearrange(@NotNull Project project, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        ReformatUtil.reformatAndRearrange(project, virtualFile, psiElement, true);
    }

    @JvmStatic
    @JvmOverloads
    public static final void reformatAndRearrange(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement, boolean keepDocumentLocked) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document2);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document2);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        PsiElement psiElement2 = psiElement;
        TextRange textRange = psiElement2 == null ? psiFile2.getTextRange() : psiElement2.getTextRange();
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)psiFile2, textRange.getStartOffset(), textRange.getEndOffset());
        PsiElement psiElement3 = psiElement;
        textRange = psiElement3 == null ? psiFile2.getTextRange() : psiElement3.getTextRange();
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
        ((ArrangementEngine)project.getService(ArrangementEngine.class)).arrange(psiFile2, (Collection)SetsKt.setOf((Object)textRange));
        if (keepDocumentLocked) {
            psiDocumentManager.commitDocument(document2);
            PsiDocumentManager.getInstance((Project)project).reparseFiles((Collection)CollectionsKt.listOf((Object)virtualFile), false);
        }
    }

    public static /* synthetic */ void reformatAndRearrange$default(Project project, VirtualFile virtualFile, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            psiElement = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        ReformatUtil.reformatAndRearrange(project, virtualFile, psiElement, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final void reformatAndRearrange(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ReformatUtil.reformatAndRearrange$default(project, virtualFile, psiElement, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void reformatAndRearrange(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ReformatUtil.reformatAndRearrange$default(project, virtualFile, null, false, 12, null);
    }

    private static final void reformatRearrangeAndSave$lambda$0(Iterable $files, Project $project) {
        Sequence $this$forEach$iv = SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$files), ReformatUtil::reformatRearrangeAndSave$lambda$0$0), ReformatUtil::reformatRearrangeAndSave$lambda$0$1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Document document;
            VirtualFile virtualFile;
            File it = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)LocalFileSystem.getInstance().findFileByIoFile(it));
            ReformatUtil.reformatAndRearrange$default($project, virtualFile, null, true, 4, null);
            FileDocumentManager $this$reformatRearrangeAndSave_u24lambda_u240_u242_u240 = FileDocumentManager.getInstance();
            boolean bl2 = false;
            if ($this$reformatRearrangeAndSave_u24lambda_u240_u242_u240.getDocument(virtualFile) == null) continue;
            boolean bl3 = false;
            $this$reformatRearrangeAndSave_u24lambda_u240_u242_u240.saveDocument(document);
        }
    }

    private static final boolean reformatRearrangeAndSave$lambda$0$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final boolean reformatRearrangeAndSave$lambda$0$1(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)"gradlew", (boolean)false, (int)2, null);
    }
}

