/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.SettingsController;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.SourcesTableModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateSitesPanel {
    private JPanel myRootPanel;
    private TableView myUpdateSitesTable;
    private JPanel mySourcesPanel;
    private JPanel mySourcesLoadingPanel;
    private AsyncProcessIcon mySourcesLoadingIcon;
    private JCheckBox myForceHttp;
    private SourcesTableModel mySourcesTableModel;
    private static SettingsController ourSettingsController = StudioSettingsController.getInstance();

    public UpdateSitesPanel(@NotNull Runnable refreshCallback) {
        this.setupUI();
        this.init(refreshCallback);
    }

    private void init(@NotNull Runnable refreshCallback) {
        this.mySourcesTableModel.setRefreshCallback(refreshCallback);
    }

    private void createUIComponents() {
        this.mySourcesLoadingIcon = new AsyncProcessIcon("Loading...");
        Runnable finishLoadingCallback = () -> {
            this.mySourcesLoadingPanel.setVisible(false);
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = dataManager.getDataContext((Component)this.myRootPanel);
            @Nullable Settings settings = (Settings)Settings.KEY.getData(dataContext);
            if (settings != null) {
                settings.revalidate();
            }
        };
        this.mySourcesTableModel = new SourcesTableModel(() -> this.mySourcesLoadingPanel.setVisible(true), finishLoadingCallback, ModalityState.current());
        this.myUpdateSitesTable = new TableView((ListTableModel)this.mySourcesTableModel);
        ToolbarDecorator userDefinedDecorator = ToolbarDecorator.createDecorator((JTable)this.myUpdateSitesTable);
        this.mySourcesPanel = this.addExtraActions(userDefinedDecorator).createPanel();
        SdkUpdaterConfigPanel.setTableProperties((JTable)this.myUpdateSitesTable, null);
    }

    private ToolbarDecorator addExtraActions(ToolbarDecorator decorator2) {
        return decorator2.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                UpdateSitesPanel.this.mySourcesTableModel.editRow(UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRow());
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRowCount() == 1 && UpdateSitesPanel.this.mySourcesTableModel.isEditable(UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRow());
            }
        }).setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return UpdateSitesPanel.this.mySourcesTableModel.isEditable();
            }
        }).addExtraAction((AnAction)new DumbAwareAction("Select All", null, AllIcons.Actions.Selectall){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(UpdateSitesPanel.this.mySourcesTableModel.hasEditableRows());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                UpdateSitesPanel.this.mySourcesTableModel.setAllEnabled(true);
            }
        }).addExtraAction((AnAction)new DumbAwareAction("Deselect All", null, AllIcons.Actions.Unselectall){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(UpdateSitesPanel.this.mySourcesTableModel.hasEditableRows());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                UpdateSitesPanel.this.mySourcesTableModel.setAllEnabled(false);
            }
        }).setMoveDownAction(null).setMoveUpAction(null).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRowCount() < 1) {
                    return false;
                }
                for (int i : UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRows()) {
                    if (UpdateSitesPanel.this.mySourcesTableModel.isEditable(i)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public boolean isModified() {
        return this.mySourcesTableModel.isSourcesModified() || ourSettingsController.getForceHttp() != this.myForceHttp.isSelected();
    }

    public void reset() {
        this.mySourcesTableModel.reset();
        this.myForceHttp.setSelected(ourSettingsController.getForceHttp());
    }

    public void setConfigurable(@NotNull SdkUpdaterConfigurable configurable) {
        this.mySourcesTableModel.setConfigurable(configurable);
    }

    public void save() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                UpdateSitesPanel.this.mySourcesTableModel.save(ProgressManager.getInstance().getProgressIndicator());
                ourSettingsController.setForceHttp(UpdateSitesPanel.this.myForceHttp.isSelected());
            }
        }, "Saving Sources", false, null, (JComponent)this.myRootPanel);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("These sites are consulted for installing and updating SDK platforms and tools.");
        this.myRootPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1), 0, false));
        this.myRootPanel.add((Component)this.mySourcesPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.mySourcesLoadingPanel = new JPanel();
        this.mySourcesLoadingPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myRootPanel.add((Component)this.mySourcesLoadingPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Loading sources...");
        this.mySourcesLoadingPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.mySourcesLoadingPanel.add((Component)this.mySourcesLoadingIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.myForceHttp = new JCheckBox();
        this.myForceHttp.setText("Force https://... sources to be fetched using http://...");
        this.myRootPanel.add((Component)this.myForceHttp, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        this.myRootPanel.add((Component)jBLabel3, new GridConstraints(3, 1, 1, 2, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myRootPanel.add((Component)spacer1, new GridConstraints(4, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
    }

    public JComponent getRootComponent() {
        return this.myRootPanel;
    }
}

