/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.DelegatingProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileUtilKt;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.HtmlBuilder;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkUpdaterConfigurable
implements SearchableConfigurable {
    private static final int ESTIMATED_ZIP_DECOMPRESSION_RATE = 4;
    private SdkUpdaterConfigPanel myPanel;

    @NotNull
    public String getId() {
        return "AndroidSdkUpdater";
    }

    @Nls
    public String getDisplayName() {
        return "Android SDK Updater";
    }

    @Nullable
    public String getHelpTopic() {
        return "org.jetbrains.android.r/studio-ui/sdk-manager.html";
    }

    @Nullable
    public JComponent createComponent() {
        this.myPanel = new SdkUpdaterConfigPanel(new StudioDownloader(), StudioSettingsController.getInstance(), this);
        return this.myPanel.getComponent();
    }

    AndroidSdkHandler getSdkHandler() {
        File location = this.myPanel.getSelectedSdkLocation();
        return AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)(location == null ? null : location.toPath()));
    }

    RepoManager getRepoManager() {
        return this.getSdkHandler().getRepoManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        boolean sourcesModified = this.myPanel.areSourcesModified();
        this.myPanel.saveSources();
        ArrayList<LocalPackage> toDelete = new ArrayList<LocalPackage>();
        HashMap requestedPackages = Maps.newHashMap();
        for (PackageNodeModel model : this.myPanel.getStates()) {
            if (model.getState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
                if (!model.getPkg().hasLocal()) continue;
                toDelete.add(model.getPkg().getLocal());
                continue;
            }
            if (model.getState() != PackageNodeModel.SelectedState.INSTALLED || !model.getPkg().isUpdate() && model.getPkg().hasLocal()) continue;
            UpdatablePackage pkg = model.getPkg();
            requestedPackages.put(pkg.getRemote(), pkg);
        }
        boolean found = false;
        long spaceToBeFreedUp = 0L;
        long fullInstallationsDownloadSize = 0L;
        HtmlBuilder messageToDelete = new HtmlBuilder();
        if (!toDelete.isEmpty()) {
            found = true;
            messageToDelete.add("The following components will be deleted: \n");
            messageToDelete.beginList();
            try {
                spaceToBeFreedUp = (Long)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkUpdaterConfigurable.getLocalInstallationSize(toDelete), "Gathering Package Information", true, null);
            }
            catch (ProcessCanceledException e) {
                throw new ConfigurationException("Installation was canceled.");
            }
            for (LocalPackage item : toDelete) {
                messageToDelete.listItem().add(SdkUpdaterConfigurable.getItemMessage((RepoPackage)item));
            }
            messageToDelete.endList();
        }
        HtmlBuilder messageToInstall = new HtmlBuilder();
        if (!requestedPackages.isEmpty()) {
            found = true;
            messageToInstall.add("The following components will be installed: \n");
            messageToInstall.beginList();
            HashMultimap dependencies2 = HashMultimap.create();
            StudioLoggerProgressIndicator progress3 = new StudioLoggerProgressIndicator(this.getClass());
            final ConcurrentLinkedQueue dependencyIssues = new ConcurrentLinkedQueue();
            DelegatingProgressIndicator dependencyIssueReporter = new DelegatingProgressIndicator(this, (ProgressIndicator)progress3){

                public void logWarning(@NotNull String s) {
                    dependencyIssues.add(s);
                    super.logWarning(s);
                }

                public void logError(@NotNull String s) {
                    dependencyIssues.add(s);
                    super.logError(s);
                }
            };
            RepositoryPackages packages = this.getRepoManager().getPackages();
            for (RemotePackage item : requestedPackages.keySet()) {
                List packageDependencies = InstallerUtil.computeRequiredPackages((Collection)ImmutableList.of((Object)item), (RepositoryPackages)packages, (ProgressIndicator)dependencyIssueReporter);
                if (packageDependencies == null) {
                    String message;
                    if (!dependencyIssues.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        for (String issue2 : dependencyIssues) {
                            sb.append(issue2);
                            sb.append(", ");
                        }
                        message = "Unable to resolve dependencies for " + item.getDisplayName() + ": " + String.valueOf(sb);
                    } else {
                        message = "Unable to resolve dependencies for " + item.getDisplayName();
                    }
                    Messages.showErrorDialog((Project)null, (String)message, (String)"Dependency Error");
                    throw new ConfigurationException(message);
                }
                for (RemotePackage dependency : packageDependencies) {
                    dependencies2.put((Object)dependency, (Object)item);
                }
                messageToInstall.listItem().add(SdkUpdaterConfigurable.getItemMessage((RepoPackage)item));
                long itemDownloadSize = SdkUpdaterConfigurable.calculateDownloadSizeForPackage(item);
                fullInstallationsDownloadSize += itemDownloadSize;
            }
            for (RemotePackage dependency : dependencies2.keySet()) {
                if (requestedPackages.containsKey(dependency)) continue;
                HashSet requests2 = Sets.newHashSet((Iterable)dependencies2.get((Object)dependency));
                requests2.remove(dependency);
                if (requests2.isEmpty()) continue;
                messageToInstall.listItem().add(dependency.getDisplayName()).add(" (Required by ");
                Iterator requestIterator = requests2.iterator();
                messageToInstall.add(((RemotePackage)requestIterator.next()).getDisplayName());
                while (requestIterator.hasNext()) {
                    messageToInstall.add(", ").add(((RemotePackage)requestIterator.next()).getDisplayName());
                }
                messageToInstall.add(")");
                long itemDownloadSize = SdkUpdaterConfigurable.calculateDownloadSizeForPackage(dependency);
                fullInstallationsDownloadSize += itemDownloadSize;
            }
            messageToInstall.endList();
        }
        if (found) {
            Path location = this.getSdkHandler().getLocation();
            Pair<HtmlBuilder, HtmlBuilder> diskUsageMessages = SdkUpdaterConfigurable.getDiskUsageMessages(location, fullInstallationsDownloadSize, spaceToBeFreedUp);
            HtmlBuilder message = new HtmlBuilder();
            message.openHtmlBody();
            if (diskUsageMessages.getSecond() != null) {
                message.addHtml(((HtmlBuilder)diskUsageMessages.getSecond()).getHtml());
            }
            message.addHtml(messageToDelete.getHtml());
            message.addHtml(messageToInstall.getHtml());
            message.addHtml(((HtmlBuilder)diskUsageMessages.getFirst()).getHtml());
            message.closeHtmlBody();
            if (SdkUpdaterConfigurable.confirmChange(message)) {
                ModelWizardDialog dialog2;
                if (!(requestedPackages.isEmpty() && toDelete.isEmpty() || (dialog2 = SdkQuickfixUtils.createDialogForPackages(this.myPanel.getComponent(), requestedPackages.values(), toDelete, true)) == null)) {
                    dialog2.show();
                    for (RemotePackage remotePackage : requestedPackages.keySet()) {
                        PackageOperation installer = this.getRepoManager().getInProgressInstallOperation((RepoPackage)remotePackage);
                        if (installer == null) continue;
                        PackageOperation.StatusChangeListener listener2 = (installer1, progress2) -> this.myPanel.getComponent().repaint();
                        installer.registerStateChangeListener(listener2);
                    }
                }
                this.myPanel.refresh(sourcesModified);
            } else {
                throw new ConfigurationException("Installation was canceled.");
            }
        }
    }

    @VisibleForTesting
    @NotNull
    static String getItemMessage(@NotNull RepoPackage item) {
        return item.getDetailedDisplayName();
    }

    private static long getLocalInstallationSize(@NotNull Collection<LocalPackage> localPackages) {
        long size = 0L;
        for (LocalPackage item : localPackages) {
            if (item == null) continue;
            try {
                size += FileUtilKt.recursiveSize((Path)item.getLocation());
            }
            catch (IOException iOException) {}
        }
        return size;
    }

    private static long calculateDownloadSizeForPackage(@NotNull RemotePackage remotePackage) {
        Archive archive = remotePackage.getArchive();
        if (archive == null) {
            return 0L;
        }
        return archive.getComplete().getSize();
    }

    @VisibleForTesting
    static Pair<HtmlBuilder, HtmlBuilder> getDiskUsageMessages(@Nullable Path sdkRoot, long fullInstallationsDownloadSize, long spaceToBeFreedUp) {
        HtmlBuilder message = new HtmlBuilder();
        message.add("Disk usage:\n");
        boolean issueDiskSpaceWarning = false;
        message.beginList();
        if (spaceToBeFreedUp > 0L) {
            message.listItem().add("Disk space that will be freed: " + new Storage(spaceToBeFreedUp).toUiString());
        }
        if (fullInstallationsDownloadSize > 0L) {
            message.listItem().add("Estimated download size: " + new Storage(fullInstallationsDownloadSize).toUiString());
            long sdkRootUsageAfterInstallation = 4L * fullInstallationsDownloadSize - spaceToBeFreedUp;
            message.listItem().add("Estimated disk space to be additionally occupied on SDK partition after installation: " + new Storage(sdkRootUsageAfterInstallation).toUiString());
            if (sdkRoot != null) {
                long sdkRootUsableSpace = 0L;
                try {
                    sdkRootUsableSpace = Files.getFileStore(sdkRoot).getUsableSpace();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                message.listItem().add(String.format("Currently available disk space in SDK root (%1$s): %2$s", sdkRoot.toAbsolutePath(), new Storage(sdkRootUsableSpace).toUiString()));
                long totalSdkUsableSpace = sdkRootUsableSpace + spaceToBeFreedUp;
                issueDiskSpaceWarning = totalSdkUsableSpace < sdkRootUsageAfterInstallation;
            }
        }
        message.endList();
        if (issueDiskSpaceWarning) {
            HtmlBuilder warningMessage = new HtmlBuilder();
            warningMessage.beginColor((Color)JBColor.RED).addBold("WARNING: There might be insufficient disk space to perform this operation. ").newline().newline().add("Estimated disk usage is presented below. ").add("Consider freeing up more disk space before proceeding. ").endColor().newline().newline();
            return Pair.of((Object)message, (Object)warningMessage);
        }
        return Pair.of((Object)message, null);
    }

    static boolean confirmChange(HtmlBuilder message) {
        String[] options = new String[]{Messages.getCancelButton(), Messages.getOkButton()};
        Icon icon = AllIcons.General.Warning;
        return Messages.showIdeaMessageDialog(null, (String)message.getHtml(), (String)"Confirm Change", (String[])options, (int)1, (Icon)icon, null) == 1;
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
        }
    }
}

