/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.uidump;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002\u001a(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"implicitAttributeDefaultsInstruction", "", "getImplicitAttributeDefaultsInstruction", "()Ljava/lang/String;", "implicitAttributeDefaults", "", "getImplicitAttributeDefaults", "()Ljava/util/Map;", "createLlmInstruction", "postProcess", "xmlString", "parse", "Lorg/w3c/dom/Document;", "documentToString", "doc", "indent", "", "printNode", "", "node", "Lorg/w3c/dom/Node;", "writer", "Ljava/io/StringWriter;", "currentIndent", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nUiDumpXmlPostProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiDumpXmlPostProcessor.kt\ncom/android/tools/idea/ui/uidump/UiDumpXmlPostProcessorKt\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,134:1\n29#2,3:135\n*S KotlinDebug\n*F\n+ 1 UiDumpXmlPostProcessor.kt\ncom/android/tools/idea/ui/uidump/UiDumpXmlPostProcessorKt\n*L\n55#1:135,3\n*E\n"})
public final class UiDumpXmlPostProcessorKt {
    @NotNull
    private static final String implicitAttributeDefaultsInstruction = "For all the attributes listed below, if you don't see it in the input, assume it is the value provided below.\n";
    @NotNull
    private static final Map<String, String> implicitAttributeDefaults;

    @NotNull
    public static final String getImplicitAttributeDefaultsInstruction() {
        return implicitAttributeDefaultsInstruction;
    }

    @NotNull
    public static final Map<String, String> getImplicitAttributeDefaults() {
        return implicitAttributeDefaults;
    }

    @NotNull
    public static final String createLlmInstruction() {
        StringBuilder instruction = new StringBuilder();
        instruction.append(implicitAttributeDefaultsInstruction);
        for (Map.Entry<String, String> entry : implicitAttributeDefaults.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            instruction.append("  " + key + "=\"" + value2 + "\"\n");
        }
        String string = instruction.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String postProcess(@NotNull String xmlString) {
        Intrinsics.checkNotNullParameter((Object)xmlString, (String)"xmlString");
        String result2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Document doc = UiDumpXmlPostProcessorKt.parse(xmlString);
        result2 = UiDumpXmlPostProcessorKt.documentToString(doc, true);
        long time2 = System.currentTimeMillis() - start$iv;
        System.out.println((Object)("XMLPostProcess took " + time2 + " ms"));
        String string = result2;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            string = null;
        }
        return string;
    }

    private static final Document parse(String xmlString) {
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory2.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xmlString));
        Document document = builder.parse(inputSource);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        return document;
    }

    private static final String documentToString(Document doc, boolean indent) {
        Element rootElement;
        StringWriter writer2 = new StringWriter();
        if (doc.getXmlEncoding() != null && doc.getXmlVersion() != null) {
            writer2.write("<?xml version='" + doc.getXmlVersion() + "' encoding='" + doc.getXmlEncoding() + "' standalone='" + (doc.getXmlStandalone() ? "yes" : "no") + "' ?>\n");
        }
        if ((rootElement = doc.getDocumentElement()) != null) {
            UiDumpXmlPostProcessorKt.printNode(rootElement, writer2, "", indent);
        }
        String string = writer2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String documentToString$default(Document document, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UiDumpXmlPostProcessorKt.documentToString(document, bl);
    }

    private static final void printNode(Node node, StringWriter writer2, String currentIndent, boolean indent) {
        if (node.getNodeType() == 3) {
            String string = node.getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeValue(...)");
            String text2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)text2).length() > 0) {
                writer2.write(text2);
            }
            return;
        }
        if (node.getNodeType() == 1) {
            if (indent) {
                writer2.write(currentIndent);
            }
            writer2.write("<" + node.getNodeName());
            NamedNodeMap attributes = node.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Node attr = attributes.item(i);
                if (Intrinsics.areEqual((Object)implicitAttributeDefaults.get(attr.getNodeName()), (Object)attr.getNodeValue())) continue;
                writer2.write(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
            if (node.hasChildNodes()) {
                int i;
                writer2.write(">");
                NodeList children2 = node.getChildNodes();
                boolean hasElementChildren = false;
                int n2 = children2.getLength();
                for (i = 0; i < n2; ++i) {
                    if (children2.item(i).getNodeType() != 1) continue;
                    hasElementChildren = true;
                    break;
                }
                if (indent && hasElementChildren) {
                    writer2.write("\n");
                }
                n2 = children2.getLength();
                for (i = 0; i < n2; ++i) {
                    Node child = children2.item(i);
                    if (child.getNodeType() != 1) {
                        if (child.getNodeType() != 3) continue;
                        String string = child.getNodeValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeValue(...)");
                        if (!(((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() > 0)) continue;
                    }
                    Intrinsics.checkNotNull((Object)child);
                    UiDumpXmlPostProcessorKt.printNode(child, writer2, (String)(indent ? currentIndent + "  " : ""), indent);
                    if (!indent || child.getNodeType() != 1) continue;
                    writer2.write("\n");
                }
                if (indent && hasElementChildren) {
                    writer2.write(currentIndent);
                }
                writer2.write("</" + node.getNodeName() + ">");
            } else {
                writer2.write("/>");
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"checkable", (Object)"false"), TuplesKt.to((Object)"checked", (Object)"false"), TuplesKt.to((Object)"clickable", (Object)"false"), TuplesKt.to((Object)"content-desc", (Object)""), TuplesKt.to((Object)"enabled", (Object)"true"), TuplesKt.to((Object)"focusable", (Object)"false"), TuplesKt.to((Object)"focused", (Object)"false"), TuplesKt.to((Object)"long-clickable", (Object)"false"), TuplesKt.to((Object)"password", (Object)"false"), TuplesKt.to((Object)"resource-id", (Object)""), TuplesKt.to((Object)"scrollable", (Object)"false"), TuplesKt.to((Object)"selected", (Object)"false"), TuplesKt.to((Object)"text", (Object)"")};
        implicitAttributeDefaults = MapsKt.mapOf((Pair[])pairArray);
    }
}

