/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.device.SkinDefinition;
import com.android.tools.adtui.device.SkinLayout;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010$\u001a\u00020\u00002\b\b\u0002\u0010%\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020'J \u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-J,\u0010.\u001a\u00020/*\u0002002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0011\u0010!\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0015R\u0011\u0010#\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001e\u00a8\u00065"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "", "image", "Ljava/awt/image/BufferedImage;", "screenshotOrientationQuadrants", "", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "deviceName", "", "displayId", "displaySize", "Ljava/awt/Dimension;", "displayDensity", "isRoundDisplay", "", "<init>", "(Ljava/awt/image/BufferedImage;ILcom/android/sdklib/deviceprovisioner/DeviceType;Ljava/lang/String;ILjava/awt/Dimension;IZ)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getScreenshotOrientationQuadrants", "()I", "getDeviceType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getDeviceName", "()Ljava/lang/String;", "getDisplayId", "getDisplaySize", "()Ljava/awt/Dimension;", "getDisplayDensity", "()Z", "width", "getWidth", "height", "getHeight", "isWear", "rotatedAndScaled", "rotationQuadrants", "scale", "", "decorate", "drawFrame", "skinDefinition", "Lcom/android/tools/adtui/device/SkinDefinition;", "backgroundColor", "Ljava/awt/Color;", "drawImageWithRoundedCorners", "", "Ljava/awt/Graphics2D;", "displayRectangle", "Ljava/awt/Rectangle;", "arcWidth", "arcHeight", "intellij.android.adb.ui"})
public final class ScreenshotImage {
    @NotNull
    private final BufferedImage image;
    private final int screenshotOrientationQuadrants;
    @NotNull
    private final DeviceType deviceType;
    @NotNull
    private final String deviceName;
    private final int displayId;
    @NotNull
    private final Dimension displaySize;
    private final int displayDensity;
    private final boolean isRoundDisplay;

    public ScreenshotImage(@NotNull BufferedImage image, int screenshotOrientationQuadrants, @NotNull DeviceType deviceType, @NotNull String deviceName, int displayId, @NotNull Dimension displaySize, int displayDensity, boolean isRoundDisplay) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        this.image = image;
        this.screenshotOrientationQuadrants = screenshotOrientationQuadrants;
        this.deviceType = deviceType;
        this.deviceName = deviceName;
        this.displayId = displayId;
        this.displaySize = displaySize;
        this.displayDensity = displayDensity;
        this.isRoundDisplay = isRoundDisplay;
    }

    public /* synthetic */ ScreenshotImage(BufferedImage bufferedImage, int n, DeviceType deviceType, String string, int n2, Dimension dimension2, int n3, boolean bl, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x20) != 0) {
            dimension2 = new Dimension();
        }
        if ((n4 & 0x40) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x80) != 0) {
            bl = false;
        }
        this(bufferedImage, n, deviceType, string, n2, dimension2, n3, bl);
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    public final int getScreenshotOrientationQuadrants() {
        return this.screenshotOrientationQuadrants;
    }

    @NotNull
    public final DeviceType getDeviceType() {
        return this.deviceType;
    }

    @NotNull
    public final String getDeviceName() {
        return this.deviceName;
    }

    public final int getDisplayId() {
        return this.displayId;
    }

    @NotNull
    public final Dimension getDisplaySize() {
        return this.displaySize;
    }

    public final int getDisplayDensity() {
        return this.displayDensity;
    }

    public final boolean isRoundDisplay() {
        return this.isRoundDisplay;
    }

    public final int getWidth() {
        return this.image.getWidth();
    }

    public final int getHeight() {
        return this.image.getHeight();
    }

    public final boolean isWear() {
        return this.deviceType == DeviceType.WEAR;
    }

    @NotNull
    public final ScreenshotImage rotatedAndScaled(int rotationQuadrants, double scale) {
        if (rotationQuadrants == 0 && scale == 1.0) {
            return this;
        }
        int w = 0;
        int h = 0;
        if (rotationQuadrants % 2 == 0) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = this.getHeight();
            h = this.getWidth();
        }
        BufferedImage bufferedImage = ImageUtils.rotateByQuadrantsAndScale((BufferedImage)this.image, (int)rotationQuadrants, (int)MathKt.roundToInt((double)((double)w * scale)), (int)MathKt.roundToInt((double)((double)h * scale)));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"rotateByQuadrantsAndScale(...)");
        return new ScreenshotImage(bufferedImage, this.screenshotOrientationQuadrants + rotationQuadrants & 3, this.deviceType, this.deviceName, this.displayId, this.displaySize, this.displayDensity, this.isRoundDisplay);
    }

    public static /* synthetic */ ScreenshotImage rotatedAndScaled$default(ScreenshotImage screenshotImage, int n, double d, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            d = 1.0;
        }
        return screenshotImage.rotatedAndScaled(n, d);
    }

    @NotNull
    public final BufferedImage decorate(boolean drawFrame, @NotNull SkinDefinition skinDefinition, @Nullable Color backgroundColor) {
        Intrinsics.checkNotNullParameter((Object)skinDefinition, (String)"skinDefinition");
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        SkinLayout skin = skinDefinition.createScaledLayout(w, h, this.screenshotOrientationQuadrants);
        int arcWidth = 2 * skin.getDisplayCornerSize().width;
        int arcHeight = 2 * skin.getDisplayCornerSize().height;
        if (drawFrame) {
            Rectangle frameRectangle = skin.getFrameRectangle();
            BufferedImage decoratedImage = new BufferedImage(frameRectangle.width, frameRectangle.height, 2);
            Graphics2D graphics = decoratedImage.createGraphics();
            Rectangle displayRectangle = new Rectangle(-frameRectangle.x, -frameRectangle.y, w, h);
            Intrinsics.checkNotNull((Object)graphics);
            this.drawImageWithRoundedCorners(graphics, this.image, displayRectangle, arcWidth, arcHeight);
            SkinLayout.drawFrameAndMask$default((SkinLayout)skin, (Graphics2D)graphics, (Rectangle)displayRectangle, null, (int)4, null);
            graphics.dispose();
            return decoratedImage;
        }
        BufferedImage decoratedImage = new BufferedImage(w, h, 2);
        Graphics2D graphics = decoratedImage.createGraphics();
        Rectangle displayRectangle = new Rectangle(0, 0, w, h);
        Intrinsics.checkNotNull((Object)graphics);
        this.drawImageWithRoundedCorners(graphics, this.image, displayRectangle, arcWidth, arcHeight);
        graphics.setComposite(AlphaComposite.getInstance(8));
        SkinLayout.drawFrameAndMask$default((SkinLayout)skin, (Graphics2D)graphics, (Rectangle)displayRectangle, null, (int)4, null);
        if (backgroundColor != null) {
            graphics.setColor(backgroundColor);
            graphics.setComposite(AlphaComposite.getInstance(4));
            graphics.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        }
        graphics.dispose();
        return decoratedImage;
    }

    private final void drawImageWithRoundedCorners(Graphics2D $this$drawImageWithRoundedCorners, BufferedImage image, Rectangle displayRectangle, int arcWidth, int arcHeight) {
        if (arcWidth > 0 && arcHeight > 0) {
            $this$drawImageWithRoundedCorners.setClip(new Area(new RoundRectangle2D.Double(displayRectangle.x, displayRectangle.y, displayRectangle.width, displayRectangle.height, arcWidth, arcHeight)));
        }
        $this$drawImageWithRoundedCorners.drawImage(image, null, displayRectangle.x, displayRectangle.y);
        $this$drawImageWithRoundedCorners.setClip(null);
    }
}

