/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.save.SaveConfiguration;
import com.android.tools.idea.ui.save.SaveConfigurationPanel;
import com.android.tools.idea.ui.screenrecording.DeviceScreenRecordingSettings;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettingsPage;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fileExtension", "", "getFileExtension", "()Ljava/lang/String;", "setFileExtension", "(Ljava/lang/String;)V", "state", "Lcom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings;", "getId", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "Provider", "intellij.android.adb.ui"})
public final class DeviceScreenRecordingSettingsPage
extends BoundConfigurable
implements SearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private String fileExtension;
    @NotNull
    private final DeviceScreenRecordingSettings state;

    public DeviceScreenRecordingSettingsPage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(AndroidAdbUiBundle.message("device.screenrecording.text", new Object[0]), null, 2, null);
        this.project = project;
        this.fileExtension = "mp4";
        this.state = DeviceScreenRecordingSettings.Companion.getInstance();
    }

    @NotNull
    public final String getFileExtension() {
        return this.fileExtension;
    }

    public final void setFileExtension(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fileExtension = string;
    }

    @NotNull
    public String getId() {
        return "device.screenrecording";
    }

    @NotNull
    public DialogPanel createPanel() {
        SaveConfiguration saveConfiguration = this.state.getSaveConfig();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new SaveConfigurationPanel(saveConfiguration, this.fileExtension, instant, this.state.getRecordingCount() + 1, this.project).createPanel();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettingsPage$Provider;", "Lcom/intellij/openapi/options/ConfigurableProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createConfigurable", "Lcom/intellij/openapi/options/Configurable;", "intellij.android.adb.ui"})
    public static final class Provider
    extends ConfigurableProvider {
        @NotNull
        private final Project project;

        public Provider(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public Configurable createConfigurable() {
            return (Configurable)new DeviceScreenRecordingSettingsPage(this.project);
        }
    }
}

