/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.FetchImageExecutor;
import com.android.tools.idea.ui.resourcemanager.rendering.ImageCache;
import com.android.tools.idea.ui.resourcemanager.rendering.ResourceRenderingUtilsKt;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResourcePreviewManagerKt;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResourcePreviewProvider;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JD\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110 H\u0016J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u000fH\u0002J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002JF\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110 2\u0006\u0010.\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010/\u001a\u00020\u0011H\u0002J \u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u00062"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewManager;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetIconProvider;", "imageCache", "Lcom/android/tools/idea/ui/resourcemanager/rendering/ImageCache;", "resourcePreviewProvider", "Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewProvider;", "<init>", "(Lcom/android/tools/idea/ui/resourcemanager/rendering/ImageCache;Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewProvider;)V", "fetchImageExecutor", "Lcom/android/tools/idea/ui/resourcemanager/rendering/FetchImageExecutor;", "PLACEHOLDER_IMAGE", "Ljava/awt/image/BufferedImage;", "imageIcon", "Lcom/intellij/util/ui/JBImageIcon;", "contentRatio", "", "supportsTransparency", "", "getSupportsTransparency", "()Z", "setSupportsTransparency", "(Z)V", "getIcon", "Ljavax/swing/ImageIcon;", "assetToRender", "Lcom/android/tools/idea/ui/resourcemanager/model/Asset;", "width", "", "height", "component", "Ljava/awt/Component;", "refreshCallback", "Lkotlin/Function0;", "", "shouldBeRendered", "shouldScale", "scale", "getScale", "target", "Ljava/awt/Dimension;", "source", "fetchImage", "Ljava/awt/Image;", "asset", "refreshCallBack", "isStillVisible", "targetSize", "forceImageRender", "scaleToFitIfNeeded", "bufferedImage", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nSlowResourcePreviewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlowResourcePreviewManager.kt\ncom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewManager\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,219:1\n40#2,3:220\n*S KotlinDebug\n*F\n+ 1 SlowResourcePreviewManager.kt\ncom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewManager\n*L\n74#1:220,3\n*E\n"})
public final class SlowResourcePreviewManager
implements AssetIconProvider {
    @NotNull
    private final ImageCache imageCache;
    @NotNull
    private final SlowResourcePreviewProvider resourcePreviewProvider;
    @NotNull
    private final FetchImageExecutor fetchImageExecutor;
    @NotNull
    private final BufferedImage PLACEHOLDER_IMAGE;
    @NotNull
    private final JBImageIcon imageIcon;
    private final double contentRatio;
    private boolean supportsTransparency;

    public SlowResourcePreviewManager(@NotNull ImageCache imageCache, @NotNull SlowResourcePreviewProvider resourcePreviewProvider) {
        Intrinsics.checkNotNullParameter((Object)imageCache, (String)"imageCache");
        Intrinsics.checkNotNullParameter((Object)resourcePreviewProvider, (String)"resourcePreviewProvider");
        this.imageCache = imageCache;
        this.resourcePreviewProvider = resourcePreviewProvider;
        boolean $i$f$service = false;
        Class<FetchImageExecutor> serviceClass$iv = FetchImageExecutor.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.fetchImageExecutor = (FetchImageExecutor)object;
        this.PLACEHOLDER_IMAGE = this.resourcePreviewProvider.getPreviewPlaceholder();
        this.imageIcon = new JBImageIcon((Image)this.PLACEHOLDER_IMAGE);
        this.contentRatio = 0.1;
        this.supportsTransparency = true;
    }

    @Override
    public boolean getSupportsTransparency() {
        return this.supportsTransparency;
    }

    public void setSupportsTransparency(boolean bl) {
        this.supportsTransparency = bl;
    }

    @Override
    @NotNull
    public ImageIcon getIcon(@NotNull Asset assetToRender, int width, int height, @NotNull Component component, @NotNull Function0<Unit> refreshCallback, @NotNull Function0<Boolean> shouldBeRendered) {
        Image image;
        Image image2;
        Intrinsics.checkNotNullParameter((Object)assetToRender, (String)"assetToRender");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(refreshCallback, (String)"refreshCallback");
        Intrinsics.checkNotNullParameter(shouldBeRendered, (String)"shouldBeRendered");
        if (height < 1 || width < 1) {
            this.imageIcon.setImage((Image)this.PLACEHOLDER_IMAGE);
            return (ImageIcon)this.imageIcon;
        }
        Dimension targetSize = new Dimension(width, height);
        Image image3 = SlowResourcePreviewManager.fetchImage$default(this, assetToRender, refreshCallback, shouldBeRendered, targetSize, component, false, 32, null);
        int imageWidth = image3.getWidth(null);
        int imageHeight = image3.getHeight(null);
        double scale = this.getScale(targetSize, new Dimension(imageWidth, imageHeight));
        if (!Intrinsics.areEqual((Object)image3, (Object)this.PLACEHOLDER_IMAGE) && !Intrinsics.areEqual((Object)image3, (Object)ResourceRenderingUtilsKt.getERROR_IMAGE()) && this.shouldScale(scale)) {
            if (scale < 1.0) {
                Image image4 = ImageUtil.scaleImage((Image)image3, (double)scale);
                Intrinsics.checkNotNullExpressionValue((Object)image4, (String)"scaleImage(...)");
                image3 = image4;
            } else {
                try {
                    BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image3);
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(...)");
                    BufferedImage bufferedImage2 = bufferedImage;
                    BufferedImage bufferedImage3 = ImageUtils.lowQualityFastScale((BufferedImage)bufferedImage2, (double)scale, (double)scale);
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage3, (String)"lowQualityFastScale(...)");
                    image3 = bufferedImage3;
                    image2 = this.fetchImage(assetToRender, refreshCallback, shouldBeRendered, targetSize, component, true);
                }
                catch (Throwable t) {
                    SlowResourcePreviewManagerKt.access$getLOG$p().warn("Unable to scale image (scale=" + scale + ", source=" + imageWidth + "x" + imageHeight + ",target=" + width + "x" + height + ", asset=" + assetToRender.getName() + ")", t);
                    this.imageIcon.setImage((Image)ResourceRenderingUtilsKt.getERROR_IMAGE());
                    image2 = Unit.INSTANCE;
                }
            }
        }
        if (Intrinsics.areEqual((Object)(image2 = image3), (Object)ResourceRenderingUtilsKt.getERROR_IMAGE())) {
            image = ResourceRenderingUtilsKt.createFailedIcon(targetSize);
        } else if (Intrinsics.areEqual((Object)image2, (Object)this.PLACEHOLDER_IMAGE)) {
            BufferedImage bufferedImage = this.shouldScale(scale) ? ImageUtils.lowQualityFastScale((BufferedImage)this.PLACEHOLDER_IMAGE, (double)scale, (double)scale) : this.PLACEHOLDER_IMAGE;
            Intrinsics.checkNotNull((Object)bufferedImage);
            image = bufferedImage;
        } else {
            image = image3;
        }
        this.imageIcon.setImage(image);
        this.setSupportsTransparency(!Intrinsics.areEqual((Object)image3, (Object)ResourceRenderingUtilsKt.getERROR_IMAGE()));
        return (ImageIcon)this.imageIcon;
    }

    private final boolean shouldScale(double scale) {
        double d = 1.0 - this.contentRatio;
        return !(scale <= 1.0 + this.contentRatio ? d <= scale : false);
    }

    private final double getScale(Dimension target2, Dimension source2) {
        double xScale = (double)target2.width / source2.getWidth();
        double yScale = (double)target2.height / source2.getHeight();
        return Math.min(xScale, yScale);
    }

    private final Image fetchImage(Asset asset, Function0<Unit> refreshCallBack, Function0<Boolean> isStillVisible, Dimension targetSize, Component component, boolean forceImageRender) {
        return ImageCache.computeAndGet$default(this.imageCache, asset, this.PLACEHOLDER_IMAGE, forceImageRender, refreshCallBack, null, () -> SlowResourcePreviewManager.fetchImage$lambda$0(isStillVisible, this, component, targetSize, asset), 16, null);
    }

    static /* synthetic */ Image fetchImage$default(SlowResourcePreviewManager slowResourcePreviewManager, Asset asset, Function0 function0, Function0 function02, Dimension dimension2, Component component, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return slowResourcePreviewManager.fetchImage(asset, (Function0<Unit>)function0, (Function0<Boolean>)function02, dimension2, component, bl);
    }

    private final BufferedImage scaleToFitIfNeeded(BufferedImage bufferedImage, Dimension targetSize, Component component) {
        Image image = ImageUtil.ensureHiDPI((Image)bufferedImage, (ScaleContext)ScaleContext.Companion.create(component));
        Dimension imageSize = new Dimension(image.getWidth(null), image.getHeight(null));
        double scale = this.getScale(targetSize, imageSize);
        if (this.shouldScale(scale)) {
            int newWidth = (int)((double)imageSize.width * scale);
            int newHeight = (int)((double)imageSize.height * scale);
            if (newWidth > 0 && newHeight > 0) {
                image = ImageUtil.scaleImage((Image)image, (double)scale);
            }
        }
        if (!(image instanceof BufferedImage)) {
            Logger.getInstance(SlowResourcePreviewManager.class).error("Not BufferedImage");
            BufferedImage bufferedImage2 = ImageUtil.toBufferedImage((Image)image);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"toBufferedImage(...)");
            return bufferedImage2;
        }
        return (BufferedImage)image;
    }

    private static final CompletableFuture fetchImage$lambda$0(Function0 $isStillVisible, SlowResourcePreviewManager this$0, Component $component, Dimension $targetSize, Asset $asset) {
        CompletableFuture<Object> completableFuture;
        if (((Boolean)$isStillVisible.invoke()).booleanValue()) {
            CompletableFuture<BufferedImage> completableFuture2 = CompletableFuture.supplyAsync(() -> SlowResourcePreviewManager.fetchImage$lambda$0$0($isStillVisible, this$0, $component, $targetSize, $asset), this$0.fetchImageExecutor);
            Intrinsics.checkNotNull(completableFuture2);
            completableFuture = completableFuture2;
        } else {
            CompletableFuture<Object> completableFuture3 = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNull(completableFuture3);
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    private static final BufferedImage fetchImage$lambda$0$0(Function0 $isStillVisible, SlowResourcePreviewManager this$0, Component $component, Dimension $targetSize, Asset $asset) {
        if (((Boolean)$isStillVisible.invoke()).booleanValue()) {
            try {
                BufferedImage bufferedImage = this$0.resourcePreviewProvider.getSlowPreview((int)(JBUI.pixScale((Component)$component) * (float)$targetSize.width), (int)(JBUI.pixScale((Component)$component) * (float)$targetSize.height), $asset);
                if (bufferedImage == null) {
                    throw new Exception("Failed to resolve resource");
                }
                BufferedImage previewImage = bufferedImage;
                return this$0.scaleToFitIfNeeded(previewImage, $targetSize, $component);
            }
            catch (Exception throwable) {
                SlowResourcePreviewManagerKt.access$getLOG$p().warn("Error while rendering " + $asset, (Throwable)throwable);
                return ResourceRenderingUtilsKt.getERROR_IMAGE();
            }
        }
        return null;
    }
}

