/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.ui.resourcemanager.importer.DesignAssetImporter;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.android.tools.idea.ui.resourcemanager.plugin.ResourceImporter;
import com.android.tools.idea.ui.resourcemanager.plugin.SVGAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.SketchImporterKt;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetPreviewManagerImpl;
import com.android.tools.idea.ui.resourcemanager.rendering.ImageCache;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.SketchParser;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.meta.SketchMeta;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchFile;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchImporterPresenter;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchImporterView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Set;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J'\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010%R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0017\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/SketchImporter;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/ResourceImporter;", "<init>", "()V", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "supportsBatchImport", "", "getSupportsBatchImport", "()Z", "invokeCustomImporter", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "filePaths", "", "hasCustomImport", "getHasCustomImport", "showImportDialog", "view", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/SketchImporterView;", "userCanEditQualifiers", "getUserCanEditQualifiers", "getSupportedFileTypes", "", "getSourcePreview", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "showInvalidSketchFileNotification", "path", "version", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Ljava/lang/Double;Lcom/intellij/openapi/project/Project;)V", "intellij.android.core"})
public final class SketchImporter
implements ResourceImporter {
    @NotNull
    private final String presentableName;
    private final boolean supportsBatchImport;
    private final boolean hasCustomImport;

    public SketchImporter() {
        this.presentableName = "Sketch Importer";
        this.hasCustomImport = true;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    @Override
    public boolean getSupportsBatchImport() {
        return this.supportsBatchImport;
    }

    @Override
    public void invokeCustomImporter(@NotNull AndroidFacet facet, @NotNull Collection<String> filePaths) {
        block5: {
            VirtualFile virtualFile;
            ImageCache imageCache;
            Disposable disposable;
            SketchImporterView view;
            SketchFile sketchFile;
            block7: {
                block6: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
                        Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
                        String string = (String)CollectionsKt.firstOrNull((Iterable)filePaths);
                        if (string == null) {
                            return;
                        }
                        String filePath = string;
                        sketchFile = SketchParser.read(filePath);
                        if (sketchFile != null && !(sketchFile.getMeta().getAppVersion() < 50.0)) break block4;
                        Object object = sketchFile;
                        Double d = object != null && (object = ((SketchFile)object).getMeta()) != null ? Double.valueOf(((SketchMeta)object).getAppVersion()) : null;
                        Project project = facet.getModule().getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        this.showInvalidSketchFileNotification(filePath, d, project);
                        break block5;
                    }
                    view = new SketchImporterView();
                    Disposable disposable2 = Disposer.newDisposable((String)"SketchImporter");
                    Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
                    disposable = disposable2;
                    imageCache = ImageCache.Companion.createImageCache$default(ImageCache.Companion, disposable, null, 2, null);
                    virtualFile = facet.getModule().getProject().getProjectFile();
                    if (virtualFile == null) break block6;
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    ResourceResolver resourceResolver = ConfigurationManager.getOrCreateInstance(facet.getModule()).getConfiguration(it).getResourceResolver();
                    virtualFile = resourceResolver;
                    if (resourceResolver != null) break block7;
                }
                return;
            }
            VirtualFile resourceResolver = virtualFile;
            AssetPreviewManagerImpl assetPreviewManager = new AssetPreviewManagerImpl(facet, imageCache, (ResourceResolver)resourceResolver, null, null, null, 56, null);
            view.setPresenter(new SketchImporterPresenter(view, sketchFile, new DesignAssetImporter(), facet, assetPreviewManager));
            this.showImportDialog(view);
            Disposer.dispose((Disposable)disposable);
        }
    }

    @Override
    public boolean getHasCustomImport() {
        return this.hasCustomImport;
    }

    private final void showImportDialog(SketchImporterView view) {
        int option = JOptionPane.showOptionDialog(null, view, "Choose the assets you would like to import", -1, -1, null, SketchImporterKt.getDIALOG_OPTIONS(), SketchImporterKt.getDIALOG_OPTIONS()[0]);
        switch (option) {
            case 0: {
                view.getPresenter().importAllFilesIntoProject();
                break;
            }
            case 1: {
                view.getPresenter().importFilesIntoProject();
            }
        }
    }

    @Override
    public boolean getUserCanEditQualifiers() {
        return true;
    }

    @Override
    @NotNull
    public Set<String> getSupportedFileTypes() {
        return SketchImporterKt.access$getSUPPORTED_FILE_TYPES$p();
    }

    @Override
    @Nullable
    public DesignAssetRenderer getSourcePreview(@NotNull DesignAsset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        return DesignAssetRendererManager.Companion.getInstance().getViewer(SVGAssetRenderer.class);
    }

    private final void showInvalidSketchFileNotification(String path, Double version2, Project project) {
        String fileName = FilenameUtils.getName((String)path);
        String generalInfo = "Please make sure you use Sketch 50.0 or higher to save your sketch file.";
        String versionInfo = version2 == null ? fileName + " seems to not be a valid Sketch file or has been saved with a version of Sketch older than 43.0." : fileName + " seems to have been saved using Sketch " + version2 + ".";
        String notificationContent = generalInfo + "<br/>" + versionInfo;
        String notificationTitle = "Invalid sketch file";
        new Notification("Invalid Sketch file", notificationTitle, notificationContent, NotificationType.ERROR).setSubtitle(fileName).notify(project);
    }
}

