/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.resources.ResourceType;
import com.android.tools.idea.ui.resourcemanager.importer.QualifierMatcher;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.android.tools.idea.ui.resourcemanager.plugin.ResourceImporter;
import com.android.tools.idea.ui.resourcemanager.plugin.SVGAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.SVGImporterKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/SVGImporter;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/ResourceImporter;", "<init>", "()V", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "userCanEditQualifiers", "", "getUserCanEditQualifiers", "()Z", "getSupportedFileTypes", "", "getSourcePreview", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "processFile", "file", "Ljava/io/File;", "convertSVGToVectorDrawable", "Lcom/intellij/testFramework/LightVirtualFile;", "it", "intellij.android.core"})
public final class SVGImporter
implements ResourceImporter {
    @NotNull
    private final String presentableName;

    public SVGImporter() {
        this.presentableName = "SVG Importer";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    @Override
    public boolean getUserCanEditQualifiers() {
        return true;
    }

    @Override
    @NotNull
    public Set<String> getSupportedFileTypes() {
        return SVGImporterKt.access$getSupportedFileTypes$p();
    }

    @Override
    @Nullable
    public DesignAssetRenderer getSourcePreview(@NotNull DesignAsset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        return DesignAssetRendererManager.Companion.getInstance().getViewer(SVGAssetRenderer.class);
    }

    @Override
    @Nullable
    public DesignAsset processFile(@NotNull File file) {
        DesignAsset designAsset;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        QualifierMatcher qualifierMatcher = new QualifierMatcher(null, 1, null);
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        QualifierMatcher.Result qualifierMatcherResult = qualifierMatcher.parsePath(string);
        LightVirtualFile lightVirtualFile = this.convertSVGToVectorDrawable(file);
        if (lightVirtualFile != null) {
            LightVirtualFile it = lightVirtualFile;
            boolean bl = false;
            designAsset = new DesignAsset((VirtualFile)it, CollectionsKt.toList((Iterable)qualifierMatcherResult.getQualifiers()), ResourceType.DRAWABLE, qualifierMatcherResult.getResourceName(), null, 16, null);
        } else {
            designAsset = null;
        }
        return designAsset;
    }

    private final LightVirtualFile convertSVGToVectorDrawable(File it) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = Svg2Vector.parseSvgToXml((Path)it.toPath(), (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            Logger.getInstance(SVGImporter.class).warn("Error converting " + it.getAbsolutePath() + " to vector drawable - " + e.getLocalizedMessage());
            return null;
        }
        String errors = object;
        Intrinsics.checkNotNull((Object)errors);
        if (!StringsKt.isBlank((CharSequence)errors)) {
            Logger.getInstance(SVGImporter.class).warn("Error converting " + it.getAbsolutePath() + " to vector drawable:\n" + errors);
        }
        if (byteArrayOutputStream.size() == 0) {
            return null;
        }
        String string = FilesKt.getNameWithoutExtension((File)it) + ".xml";
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        object = byArray;
        return new LightVirtualFile(string, (CharSequence)new String((byte[])object, Charsets.UTF_8));
    }
}

