/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.svg.SvgKt;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J4\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/SVGAssetRenderer;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "<init>", "()V", "isFileSupported", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getImage", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/image/BufferedImage;", "module", "Lcom/intellij/openapi/module/Module;", "dimension", "Ljava/awt/Dimension;", "context", "", "logFileNotSupported", "", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.android.core"})
public final class SVGAssetRenderer
implements DesignAssetRenderer {
    @Override
    public boolean isFileSupported(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return StringsKt.equals((String)"svg", (String)file.getExtension(), (boolean)true);
    }

    @NotNull
    public CompletableFuture<BufferedImage> getImage(@NotNull VirtualFile file, @Nullable Module module, @NotNull Dimension dimension2, @Nullable Object context) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dimension2, (String)"dimension");
        CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> SVGAssetRenderer.getImage$lambda$0(file, this, dimension2));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private final void logFileNotSupported(VirtualFile file, Exception ex) {
        Logger.getInstance(SVGAssetRenderer.class).warn(file.getPath() + " content is not supported by the SVG Loader\n " + ex.getLocalizedMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BufferedImage getImage$lambda$0(VirtualFile $file, SVGAssetRenderer this$0, Dimension $dimension) {
        Object object;
        try {
            BufferedImage bufferedImage;
            object = $file.getInputStream();
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)object;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)inputStream);
                bufferedImage = SvgKt.renderSvgWithSize$default((InputStream)inputStream, (float)$dimension.width, (float)$dimension.height, (float)0.0f, (int)8, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = bufferedImage;
        }
        catch (IOException e) {
            this$0.logFileNotSupported($file, e);
            object = null;
        }
        return object;
    }
}

