/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.rendering.AndroidBuildTargetReference;
import com.android.tools.idea.ui.resourcemanager.plugin.FrameworkDrawableRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.FrameworkDrawableRendererKt;
import com.android.tools.idea.ui.resourcemanager.plugin.ImageFuturesManager;
import com.android.tools.rendering.RenderTask;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J&\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\b2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J(\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\b2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0017H\u0002R(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/FrameworkDrawableRenderer;", "Lorg/jetbrains/android/facet/AndroidFacetScopedService;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "renderTaskProvider", "Lkotlin/Function2;", "Lcom/android/tools/idea/rendering/AndroidBuildTargetReference;", "Lcom/android/tools/configurations/Configuration;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/rendering/RenderTask;", "futuresManager", "Lcom/android/tools/idea/ui/resourcemanager/plugin/ImageFuturesManager;", "Lcom/android/ide/common/rendering/api/ResourceValue;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Lkotlin/jvm/functions/Function2;Lcom/android/tools/idea/ui/resourcemanager/plugin/ImageFuturesManager;)V", "onServiceDisposal", "", "getDrawableRender", "Ljava/awt/image/BufferedImage;", "resourceValue", "fileForConfiguration", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetSize", "Ljava/awt/Dimension;", "getImage", "value", "dimension", "Companion", "intellij.android.core"})
public final class FrameworkDrawableRenderer
extends AndroidFacetScopedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<AndroidBuildTargetReference, Configuration, CompletableFuture<RenderTask>> renderTaskProvider;
    @NotNull
    private final ImageFuturesManager<ResourceValue> futuresManager;

    @VisibleForTesting
    public FrameworkDrawableRenderer(@NotNull AndroidFacet facet, @NotNull Function2<? super AndroidBuildTargetReference, ? super Configuration, ? extends CompletableFuture<RenderTask>> renderTaskProvider, @NotNull ImageFuturesManager<ResourceValue> futuresManager) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter(renderTaskProvider, (String)"renderTaskProvider");
        Intrinsics.checkNotNullParameter(futuresManager, (String)"futuresManager");
        super(facet);
        this.renderTaskProvider = renderTaskProvider;
        this.futuresManager = futuresManager;
        Disposer.register((Disposable)this, (Disposable)this.futuresManager);
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
    }

    @NotNull
    public final CompletableFuture<BufferedImage> getDrawableRender(@NotNull ResourceValue resourceValue, @NotNull VirtualFile fileForConfiguration, @NotNull Dimension targetSize) {
        Intrinsics.checkNotNullParameter((Object)resourceValue, (String)"resourceValue");
        Intrinsics.checkNotNullParameter((Object)fileForConfiguration, (String)"fileForConfiguration");
        Intrinsics.checkNotNullParameter((Object)targetSize, (String)"targetSize");
        Function0 renderImageCallback = () -> FrameworkDrawableRenderer.getDrawableRender$lambda$0(this, resourceValue, fileForConfiguration, targetSize);
        return this.futuresManager.registerAndGet(resourceValue, (Function0<CompletableFuture<BufferedImage>>)renderImageCallback);
    }

    private final CompletableFuture<BufferedImage> getImage(ResourceValue value2, VirtualFile fileForConfiguration, Dimension dimension2) {
        AndroidFacet androidFacet = this.getFacet();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"getFacet(...)");
        CompletionStage completionStage = FrameworkDrawableRendererKt.access$getConfigurationFuture(androidFacet, fileForConfiguration).thenComposeAsync(arg_0 -> FrameworkDrawableRenderer.getImage$lambda$0(this, dimension2, value2, arg_0), (Executor)PooledThreadExecutor.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenComposeAsync(...)");
        return completionStage;
    }

    private static final CompletableFuture getDrawableRender$lambda$0(FrameworkDrawableRenderer this$0, ResourceValue $resourceValue, VirtualFile $fileForConfiguration, Dimension $targetSize) {
        return this$0.getImage($resourceValue, $fileForConfiguration, $targetSize);
    }

    private static final CompletableFuture getImage$lambda$0(FrameworkDrawableRenderer this$0, Dimension $dimension, ResourceValue $value, Configuration configuration2) {
        Function2<AndroidBuildTargetReference, Configuration, CompletableFuture<RenderTask>> function2 = this$0.renderTaskProvider;
        AndroidFacet androidFacet = this$0.getFacet();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"getFacet(...)");
        AndroidBuildTargetReference androidBuildTargetReference = AndroidBuildTargetReference.Companion.gradleOnly(androidFacet);
        Intrinsics.checkNotNull((Object)configuration2);
        return ((CompletableFuture)function2.invoke((Object)androidBuildTargetReference, (Object)configuration2)).thenCompose(arg_0 -> FrameworkDrawableRenderer.getImage$lambda$0$1(arg_0 -> FrameworkDrawableRenderer.getImage$lambda$0$0($dimension, $value, arg_0), arg_0));
    }

    private static final CompletionStage getImage$lambda$0$0(Dimension $dimension, ResourceValue $value, RenderTask renderTask) {
        Object object;
        block1: {
            RenderTask renderTask2 = renderTask;
            if (renderTask2 != null) {
                renderTask2.setOverrideRenderSize($dimension.width, $dimension.height);
            }
            RenderTask renderTask3 = renderTask;
            if (renderTask3 == null) break block1;
            renderTask3.setMaxRenderSize($dimension.width, $dimension.height);
        }
        return (object = renderTask) != null && (object = ((RenderTask)object).renderDrawable($value)) != null ? ((CompletableFuture)object).whenComplete((arg_0, arg_1) -> FrameworkDrawableRenderer.getImage$lambda$0$0$1((arg_0, arg_1) -> FrameworkDrawableRenderer.getImage$lambda$0$0$0(renderTask, arg_0, arg_1), arg_0, arg_1)) : null;
    }

    private static final Unit getImage$lambda$0$0$0(RenderTask $renderTask, BufferedImage bufferedImage, Throwable throwable) {
        $renderTask.dispose();
        return Unit.INSTANCE;
    }

    private static final void getImage$lambda$0$0$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final CompletionStage getImage$lambda$0$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final FrameworkDrawableRenderer getInstance(@NotNull AndroidFacet facet) {
        return Companion.getInstance(facet);
    }

    @VisibleForTesting
    @JvmStatic
    public static final void setInstance(@NotNull AndroidFacet facet, @Nullable FrameworkDrawableRenderer drawableRenderer) {
        Companion.setInstance(facet, drawableRenderer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/FrameworkDrawableRenderer$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/ui/resourcemanager/plugin/FrameworkDrawableRenderer;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "setInstance", "", "drawableRenderer", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FrameworkDrawableRenderer getInstance(@NotNull AndroidFacet facet) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            FrameworkDrawableRenderer renderer2 = (FrameworkDrawableRenderer)facet.getUserData(FrameworkDrawableRendererKt.access$getFRAMEWORK_DRAWABLE_KEY$p());
            if (renderer2 == null) {
                renderer2 = new FrameworkDrawableRenderer(facet, (Function2<? super AndroidBuildTargetReference, ? super Configuration, ? extends CompletableFuture<RenderTask>>)((Function2)getInstance.1.INSTANCE), new ImageFuturesManager<ResourceValue>());
                facet.putUserData(FrameworkDrawableRendererKt.access$getFRAMEWORK_DRAWABLE_KEY$p(), (Object)renderer2);
            }
            return renderer2;
        }

        @VisibleForTesting
        @JvmStatic
        public final void setInstance(@NotNull AndroidFacet facet, @Nullable FrameworkDrawableRenderer drawableRenderer) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            facet.putUserData(FrameworkDrawableRendererKt.access$getFRAMEWORK_DRAWABLE_KEY$p(), (Object)drawableRenderer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

