/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.actions;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorer;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorerKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/actions/ShowFileInResourceManagerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "showResourceExplorer", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isSupportedInResManager", "", "isSupportedResource", "getPsiDir", "Lcom/intellij/psi/PsiDirectory;", "intellij.android.core"})
public final class ShowFileInResourceManagerAction
extends DumbAwareAction {
    public ShowFileInResourceManagerAction() {
        super("Show In Resource Manager", "Display selected file in the Resource Manager", null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && file != null && this.isSupportedInResManager(file, project)) {
            this.showResourceExplorer(project, file);
            return;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean isSupported = this.isSupportedInResManager(file, project);
        if (e.isFromContextMenu()) {
            e.getPresentation().setEnabledAndVisible(isSupported);
        } else {
            e.getPresentation().setEnabled(isSupported);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final void showResourceExplorer(Project project, VirtualFile file) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Resources Explorer");
        Intrinsics.checkNotNull((Object)toolWindow);
        ToolWindow toolWindow2 = toolWindow;
        AndroidFacet facet = AndroidFacet.getInstance((VirtualFile)file, (Project)project);
        if (facet != null) {
            toolWindow2.show(() -> ShowFileInResourceManagerAction.showResourceExplorer$lambda$0(toolWindow2, facet, file));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSupportedInResManager(VirtualFile file, Project project) {
        if (file == null) return false;
        if (project == null) {
            return false;
        }
        PsiDirectory psiDirectory = this.getPsiDir(file, project);
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory dir = psiDirectory;
        if (IdeResourcesUtil.isResourceDirectory$default(dir, false, 2, null)) return true;
        if (!IdeResourcesUtil.isResourceSubdirectory$default(dir, null, false, 6, null)) return false;
        VirtualFile virtualFile = dir.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        if (!this.isSupportedResource(virtualFile)) return false;
        return true;
    }

    private final boolean isSupportedResource(VirtualFile file) {
        Object object = ResourceFolderType.getFolderType((String)file.getName());
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object folderName = object;
        return ArraysKt.contains((Object[])ResourceExplorerKt.getMANAGER_SUPPORTED_RESOURCES(), (Object)ResourceType.fromFolderName((String)folderName));
    }

    private final PsiDirectory getPsiDir(VirtualFile file, Project project) {
        Object object;
        if (file.isDirectory()) {
            object = PsiManager.getInstance((Project)project).findDirectory(file);
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            object = psiFile != null ? psiFile.getContainingDirectory() : null;
        }
        return object;
    }

    private static final void showResourceExplorer$lambda$0(ToolWindow $toolWindow, AndroidFacet $facet, VirtualFile $file) {
        block0: {
            ResourceExplorer resourceExplorer;
            Content content2 = $toolWindow.getContentManager().getContent(0);
            JComponent jComponent = content2 != null ? content2.getComponent() : null;
            ResourceExplorer resourceExplorer2 = resourceExplorer = jComponent instanceof ResourceExplorer ? (ResourceExplorer)jComponent : null;
            if (resourceExplorer2 == null) break block0;
            resourceExplorer2.selectAsset($facet, $file);
        }
    }
}

