/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager;

import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.ui.resourcemanager.AndroidFacetChooserKt;
import com.android.tools.idea.ui.resourcemanager.MyFileEditorListener;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorer;
import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.SyncResultListener;
import com.android.tools.idea.ui.resourcemanager.explorer.NoFacetView;
import com.android.tools.idea.util.SyncUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\r\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0004*\u00020\u0006H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0004*\u00020\u0006H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"RESOURCE_EXPLORER_TOOL_WINDOW_ID", "", "STRIPE_TITLE", "connectListeners", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "resourceExplorer", "Lcom/android/tools/idea/ui/resourcemanager/ResourceExplorer;", "createContent", "displayNoFacetView", "displayWaitingView", "message", "showWarning", "", "displayWaitingForGoodSync", "displayLoading", "displayInToolWindow", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.core"})
public final class ResourceExplorerToolFactoryKt {
    @NotNull
    public static final String RESOURCE_EXPLORER_TOOL_WINDOW_ID = "Resources Explorer";
    @NotNull
    private static final String STRIPE_TITLE = "Resource Manager";

    private static final void connectListeners(ToolWindow toolWindow, Project project, ResourceExplorer resourceExplorer) {
        MessageBusConnection connection2 = project.getMessageBus().connect((Disposable)resourceExplorer);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        connection2.subscribe(topic, (Object)new MyFileEditorListener(project, toolWindow, resourceExplorer));
        connection2.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)new SyncResultListener(project, resourceExplorer, toolWindow));
    }

    private static final void createContent(ToolWindow toolWindow, Project project) {
        AndroidFacet facet;
        toolWindow.getContentManager().removeAllContents(true);
        AndroidFacet androidFacet = AndroidFacetChooserKt.findLastSelectedFacet(project);
        if (androidFacet == null) {
            androidFacet = AndroidFacetChooserKt.findCompatibleFacetFromOpenedFiles(project);
        }
        if ((facet = androidFacet) == null) {
            ResourceExplorerToolFactoryKt.displayNoFacetView(project, toolWindow);
            return;
        }
        ResourceExplorerToolFactoryKt.displayWaitingForGoodSync(toolWindow);
        SyncUtil.runWhenSmartAndSyncedOnEdt$default(project, null, arg_0 -> ResourceExplorerToolFactoryKt.createContent$lambda$0(facet, toolWindow, project, arg_0), null, 5, null);
    }

    private static final void displayNoFacetView(Project project, ToolWindow toolWindow) {
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content content2 = contentManager2.getFactory().createContent((JComponent)new NoFacetView(project), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        contentManager2.addContent(content3);
    }

    private static final void displayWaitingView(ToolWindow $this$displayWaitingView, String message, boolean showWarning) {
        JBLabel jBLabel;
        JPanel jPanel;
        $this$displayWaitingView.getContentManager().removeAllContents(true);
        JPanel $this$displayWaitingView_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$displayWaitingView_u24lambda_u240.setLayout(new BoxLayout($this$displayWaitingView_u24lambda_u240, 1));
        JBLabel $this$displayWaitingView_u24lambda_u240_u240 = jBLabel = new JBLabel();
        boolean bl2 = false;
        $this$displayWaitingView_u24lambda_u240_u240.setText(message);
        if (showWarning) {
            $this$displayWaitingView_u24lambda_u240_u240.setIcon(AllIcons.General.Warning);
        }
        $this$displayWaitingView_u24lambda_u240_u240.setForeground(ColorUtil.toAlpha((Color)UIUtil.getLabelForeground(), (int)150));
        $this$displayWaitingView_u24lambda_u240_u240.setAlignmentX(0.5f);
        $this$displayWaitingView_u24lambda_u240_u240.setAlignmentY(0.5f);
        JBLabel waitingLabel = jBLabel;
        $this$displayWaitingView_u24lambda_u240.add(Box.createVerticalGlue());
        $this$displayWaitingView_u24lambda_u240.add((Component)waitingLabel);
        $this$displayWaitingView_u24lambda_u240.add(Box.createVerticalGlue());
        JPanel waitingForSyncPanel = jPanel;
        Content content2 = $this$displayWaitingView.getContentManager().getFactory().createContent((JComponent)waitingForSyncPanel, null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        $this$displayWaitingView.getContentManager().addContent(content3);
    }

    private static final void displayWaitingForGoodSync(ToolWindow $this$displayWaitingForGoodSync) {
        ResourceExplorerToolFactoryKt.displayWaitingView($this$displayWaitingForGoodSync, "Waiting for successful sync...", true);
    }

    private static final void displayLoading(ToolWindow $this$displayLoading) {
        ResourceExplorerToolFactoryKt.displayWaitingView($this$displayLoading, "Loading...", false);
    }

    private static final void displayInToolWindow(AndroidFacet facet, ToolWindow toolWindow) {
        ResourceExplorer resourceExplorer = ResourceExplorer.Companion.createForToolWindow(facet);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        contentManager2.removeAllContents(true);
        Content content2 = contentManager2.getFactory().createContent((JComponent)resourceExplorer, null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        Disposer.register((Disposable)((Disposable)content3), (Disposable)resourceExplorer);
        contentManager2.addContent(content3);
        content3.setPreferredFocusableComponent((JComponent)resourceExplorer);
        Project project = facet.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ResourceExplorerToolFactoryKt.connectListeners(toolWindow, project, resourceExplorer);
        ResourceManagerTracking.INSTANCE.logPanelOpens(facet);
    }

    private static final void createContent$lambda$0(AndroidFacet $facet, ToolWindow $toolWindow, Project $project, ProjectSystemSyncManager.SyncResult result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        if (result2.isSuccessful()) {
            ResourceExplorerToolFactoryKt.displayInToolWindow($facet, $toolWindow);
        } else {
            SyncUtil.listenUntilNextSync$default($project, null, new ProjectSystemSyncManager.SyncResultListener($toolWindow, $project){
                final /* synthetic */ ToolWindow $toolWindow;
                final /* synthetic */ Project $project;
                {
                    this.$toolWindow = $toolWindow;
                    this.$project = $project;
                }

                public void syncEnded(ProjectSystemSyncManager.SyncResult result2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
                    ResourceExplorerToolFactoryKt.access$createContent(this.$toolWindow, this.$project);
                }
            }, 1, null);
        }
    }

    public static final /* synthetic */ void access$displayLoading(ToolWindow $receiver) {
        ResourceExplorerToolFactoryKt.displayLoading($receiver);
    }

    public static final /* synthetic */ void access$createContent(ToolWindow toolWindow, Project project) {
        ResourceExplorerToolFactoryKt.createContent(toolWindow, project);
    }

    public static final /* synthetic */ void access$displayWaitingForGoodSync(ToolWindow $receiver) {
        ResourceExplorerToolFactoryKt.displayWaitingForGoodSync($receiver);
    }
}

